#!/bin/bash
#: Title      : test_pbconv
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM1=../../b2plasma$EXT;
PROGRAM2=../../p2blood$EXT;
PROGRAM3=../../p2bfuncs$EXT;

printf "\n\n"
printf "=====================================================================\n"
printf "creating test data for %s and %s\n" $PROGRAM1 $PROGRAM2
printf "=====================================================================\n"

printf "\n NORBC \n"

taccalc input.kbq x 0.63 NORBC_b.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n PK11195 \n"

fit2dat -f=input.kbq PK11195.fit PK11195_c_to_p.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc PK11195_c_to_p.rat x 0.41 temp.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc temp.kbq + 0.59 PK11195_b_to_p_41.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc input.kbq x PK11195_b_to_p_41.rat PK11195_b.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n PE2I \n"

fit2dat -f=input.kbq PE2I.fit PE2I_c_to_p.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc PE2I_c_to_p.rat x 0.40 temp.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc temp.kbq + 0.60 PE2I_b_to_p_40.rat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taccalc input.kbq x PE2I_b_to_p_40.rat PE2I_b.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n MTO: BL=PL*(1 - HCT*(1-63/94)) \n"

taccalc input.kbq x 0.86808510638297872340425531914894 MTO_b.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"





printf "\n\n"
printf "=====================================================================\n"
printf "testing %s and %s\n" $PROGRAM1 $PROGRAM2
printf "=====================================================================\n"

printf "\n 0.1.0 Unknown option \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 -stupidoption PE2I input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 -stupidoption PE2I input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.2.0 Extra argument \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 PE2I input.kbq 0.40 output.kbq extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 PE2I input.kbq 0.40 output.kbq extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.3.0 Option -Log \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 -d -log PE2I input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt save_log "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.kbq HCT "0.40"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 -d -log PE2I input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt save_log "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.kbq HCT "0.40"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n0.4.0 Unknown tracer code \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 NONEXISTING input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid tracer code 'NONEXISTING'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 NONEXISTING input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid tracer code 'NONEXISTING'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.5.0 Missing tracer code \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt output.kbq
$PROGRAM2 input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.5.1 Missing input file \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 PE2I 0.40 output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt output.kbq
$PROGRAM2 PE2I 0.40 output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.5.2 Missing hematocrit \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 PE2I input.kbq output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt output.kbq
$PROGRAM2 PE2I input.kbq output.kbq &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n0.5.3 Missing output file \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 PE2I input.kbq 0.40 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt output.kbq
$PROGRAM2 PE2I input.kbq 0.40 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.0.0 NORBC \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 norbc NORBC_b.kbq 0.37 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 norbc input.kbq 0.37 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y NORBC_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.1.0 FTHA \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 ftha NORBC_b.kbq 0.37 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 ftha input.kbq 0.37 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y NORBC_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.2.0 PK11195 \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 PK11195 PK11195_b.kbq 0.41 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 pk11195 input.kbq 0.41 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y PK11195_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.3.0 PE2I \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 PE2I PE2I_b.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 pe2i input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y PE2I_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.4.0 Metomidate \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 Metomidate MTO_b.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 MTO input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y MTO_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.5.0 InWater \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 inwater MTO_b.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 inwater input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y MTO_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.6.0 RATFDG \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 ratfdg test_ratfdg_ab.kbq 0,4 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y test_ratfdg_ap.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 RATFDG test_ratfdg_ap.kbq 0,4 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y test_ratfdg_ab.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n2.0.0 Time units: sec \n\n"

rm -f stdout.txt output.kbq secinput.kbq
cp -f PE2I_b.kbq secinput.kbq
tacunit -xconv=sec secinput.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM1 pe2i secinput.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacunit -xconv=min output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq secinput.kbq
cp -f input.kbq secinput.kbq
tacunit -xconv=sec secinput.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM2 pe2i secinput.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacunit -xconv=min output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y PE2I_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n2.0.1 Time units: min \n\n"

rm -f stdout.txt output.kbq
$PROGRAM1 pe2i PE2I_b.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq
$PROGRAM2 pe2i input.kbq 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=y -xunit=y -yunit=y PE2I_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n2.0.2 Time units: min , but not given in datafile \n\n"

rm -f stdout.txt output.kbq input.dat
tacformat -f=SIMPLE -hdr=n PE2I_b.kbq input.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM1 pe2i input.dat 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=n -xunit=n -yunit=n input.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.kbq input.dat
tacformat -f=SIMPLE -hdr=n input.kbq input.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM2 pe2i input.dat 0.40 output.kbq &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 -x=y -y=y -tacnames=n -xunit=n -yunit=n PE2I_b.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n"
printf "\n===================================================================\n"
printf "\n  Testing with real measured data \n"
printf "\n===================================================================\n"

printf "\n3.0.0 Flumazenil blood to plasma \n\n"

STUDY=ua0028;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 flu ${STUDY}ab.kbq 0.43 output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ap.svg -s ${STUDY}ap.kbq -l output_${STUDY}ap.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=5 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ap.kbq output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

STUDY=ua0038;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 flu ${STUDY}ab.kbq 0.43 output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ap.svg -s ${STUDY}ap.kbq -l output_${STUDY}ap.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=5 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ap.kbq output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.0.1 Flumazenil plasma to blood \n\n"

STUDY=ua0028;
rm -f output_${STUDY}ab.kbq
$PROGRAM2 flu ${STUDY}ap.kbq 0.43 output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ab.svg -s ${STUDY}ab.kbq -l output_${STUDY}ab.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=5 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ab.kbq output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

STUDY=ua0038;
rm -f output_${STUDY}ab.kbq
$PROGRAM2 flu ${STUDY}ap.kbq 0.43 output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ab.svg -s ${STUDY}ab.kbq -l output_${STUDY}ab.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=5 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ab.kbq output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n3.1.0 Palmitate blood to plasma \n\n"

STUDY=s03208;
rm -f output_${STUDY}vp.kbq
$PROGRAM1 palmitate ${STUDY}vb.kbq 0.41 output_${STUDY}vp.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}vp.svg -s ${STUDY}vp.kbq -l output_${STUDY}vp.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=5 -tacnames=y -xunit=y -yunit=y ${STUDY}vp.kbq output_${STUDY}vp.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.1.1 Palmitate plasma to blood \n\n"

STUDY=s03208;
rm -f output_${STUDY}vb.kbq
$PROGRAM2 palmitate ${STUDY}vp.kbq 0.41 output_${STUDY}vb.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}vb.svg -s ${STUDY}vb.kbq -l output_${STUDY}vb.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=5 -tacnames=y -xunit=y -yunit=y ${STUDY}vb.kbq output_${STUDY}vb.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n3.2.0 PK11195 blood to plasma \n\n"

STUDY=i00061;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 pk11195 ${STUDY}ab.kbq 0.38 output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ap.svg -s ${STUDY}ap.kbq -l output_${STUDY}ap.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n3.2.1 PK11195 plasma to blood \n\n"

STUDY=i00061;
rm -f output_${STUDY}ab.kbq
$PROGRAM2 pk11195 ${STUDY}ap.kbq 0.38 output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ab.svg -s ${STUDY}ab.kbq -l output_${STUDY}ab.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"

printf "\n3.3.0 PE2I blood to plasma \n\n"

STUDY=rb20;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 pe2i ${STUDY}ab_combined.kbq 0.42 output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ap.svg -s ${STUDY}ap_combined.kbq -l output_${STUDY}ap.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=10 -tacnames=y -xunit=y -yunit=y ${STUDY}ap_combined.kbq output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.3.1 PE2I plasma to blood \n\n"

STUDY=rb20;
rm -f output_${STUDY}ab.kbq
$PROGRAM2 pe2i ${STUDY}ap_combined.kbq 0.38 output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ab.svg -s ${STUDY}ab_combined.kbq -l output_${STUDY}ab.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=10 -tacnames=y -xunit=y -yunit=y ${STUDY}ab_combined.kbq output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n3.4.0 Carfentanil blood to plasma \n\n"

STUDY=uf0640;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 carfentanil ${STUDY}ab.kbq 40 output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ap.svg -s ${STUDY}ap.kbq -l output_${STUDY}ap.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=10 -tacnames=y -xunit=y -yunit=y ${STUDY}ap.kbq output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.4.1 Carfentanil plasma to blood \n\n"

STUDY=uf0640;
rm -f output_${STUDY}ab.kbq
$PROGRAM2 carfentanil ${STUDY}ap.kbq 40 output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ab.svg -s ${STUDY}ab.kbq -l output_${STUDY}ab.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=10 -tacnames=y -xunit=y -yunit=y ${STUDY}ab.kbq output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n3.5.0 PBR28 HAB blood to plasma \n\n"
STUDY=PBR28HAB;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 pbr28hab ${STUDY}ab.kbq 40 output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -y1=0 output_${STUDY}ap.svg -s ${STUDY}ap.kbq -l output_${STUDY}ap.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ap.kbq output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.5.1 PBR28 HAB plasma to blood \n\n"
STUDY=PBR28HAB;
rm -f output_${STUDY}ab.kbq
$PROGRAM2 pbr28hab ${STUDY}ap.kbq 40 output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -y1=0 output_${STUDY}ab.svg -s ${STUDY}ab.kbq -l output_${STUDY}ab.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ab.kbq output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.5.2 PBR28 MAB blood to plasma \n\n"
STUDY=PBR28MAB;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 pbr28mab ${STUDY}ab.kbq 40 output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -y1=0 output_${STUDY}ap.svg -s ${STUDY}ap.kbq -l output_${STUDY}ap.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ap.kbq output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.5.3 PBR28 MAB plasma to blood \n\n"
STUDY=PBR28MAB;
rm -f output_${STUDY}ab.kbq
$PROGRAM2 pbr28mab ${STUDY}ap.kbq 40 output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -y1=0 output_${STUDY}ab.svg -s ${STUDY}ab.kbq -l output_${STUDY}ab.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ab.kbq output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.5.4 PBR28 LAB blood to plasma \n\n"
STUDY=PBR28LAB;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 pbr28lab ${STUDY}ab.kbq 40 output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -y1=0 output_${STUDY}ap.svg -s ${STUDY}ap.kbq -l output_${STUDY}ap.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ap.kbq output_${STUDY}ap.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.5.5 PBR28 LAB plasma to blood \n\n"
STUDY=PBR28LAB;
rm -f output_${STUDY}ab.kbq
$PROGRAM2 pbr28lab ${STUDY}ap.kbq 40 output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -y1=0 output_${STUDY}ab.svg -s ${STUDY}ab.kbq -l output_${STUDY}ab.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=20 -tacnames=y -xunit=y -yunit=y ${STUDY}ab.kbq output_${STUDY}ab.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n3.6.0 FMPEP-d2 blood to plasma \n\n"

STUDY=RB154;
rm -f output_${STUDY}AP.kBq
$PROGRAM1 FMPEP-d2 ${STUDY}AB.kBq 0.37 output_${STUDY}AP.kBq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ap.svg -s ${STUDY}AP.kBq -l output_${STUDY}AP.kBq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=25 -tacnames=y -xunit=y -yunit=y ${STUDY}AP.kBq output_${STUDY}AP.kBq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.6.1 FMPEP-d2 plasma to blood \n\n"

STUDY=RB154;
rm -f output_${STUDY}AB.kBq
$PROGRAM2 FMPEP-d2 ${STUDY}AP.kBq 37 output_${STUDY}AB.kBq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ab.svg -s ${STUDY}AB.kBq -l output_${STUDY}AB.kBq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=25 -tacnames=y -xunit=y -yunit=y ${STUDY}AB.kBq output_${STUDY}AB.kBq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n3.7.0 Fluoride blood to plasma \n\n"

STUDY=ur0001;
rm -f output_${STUDY}vp.dat
$PROGRAM1 fluoride ${STUDY}vb.dat 0.39 output_${STUDY}vp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}vp.svg -s ${STUDY}vp.dat -l output_${STUDY}vp.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=15 -tacnames=y -xunit=y -yunit=y ${STUDY}vp.dat output_${STUDY}vp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

STUDY=ur0002;
rm -f output_${STUDY}vp.dat
$PROGRAM1 fluoride ${STUDY}vb.dat 0.41 output_${STUDY}vp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}vp.svg -s ${STUDY}vp.dat -l output_${STUDY}vp.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=10 -tacnames=y -xunit=y -yunit=y ${STUDY}vp.dat output_${STUDY}vp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.7.1 Fluoride plasma to blood \n\n"

STUDY=ur0001;
rm -f output_${STUDY}vb.dat
$PROGRAM2 Fluoride ${STUDY}vp.dat 39 output_${STUDY}vb.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}vb.svg -s ${STUDY}vb.dat -l output_${STUDY}vb.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=15 -tacnames=y -xunit=y -yunit=y ${STUDY}vb.dat output_${STUDY}vb.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

STUDY=ur0002;
rm -f output_${STUDY}vb.dat
$PROGRAM2 Fluoride ${STUDY}vp.dat 0.41 output_${STUDY}vb.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}vb.svg -s ${STUDY}vb.dat -l output_${STUDY}vb.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=10 -tacnames=y -xunit=y -yunit=y ${STUDY}vb.dat output_${STUDY}vb.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"

printf "\n3.8.0 SMW139 blood to plasma \n\n"

STUDY=P111949;
rm -f output_${STUDY}ap.kbq
$PROGRAM1 SMW139 ${STUDY}AB.kbq 0.40 output_${STUDY}AP.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ap.svg -s ${STUDY}AP.kbq -l output_${STUDY}AP.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.5 -rel=1 -tacnames=y -xunit=y -yunit=y ${STUDY}AP.kbq output_${STUDY}AP.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.8.1 SMW139 plasma to blood \n\n"

STUDY=P111949;
rm -f output_${STUDY}AB.dat
$PROGRAM2 SMW139 ${STUDY}AP.kbq 40 output_${STUDY}AB.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output_${STUDY}ab.svg -s ${STUDY}AB.kbq -l output_${STUDY}AB.kbq 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.5 -rel=1 -tacnames=y -xunit=y -yunit=y ${STUDY}AB.kbq output_${STUDY}AB.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM3
printf "This program is not used in data analysis, thus not really tested\n"
printf "=====================================================================\n"

printf "\n 5.0.0 Plot all supported plasma-to-blood curves \n\n"

$PROGRAM3 AH690 0.40 60 p2b_ah690.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="AH690" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_ah690.svg -l p2b_ah690.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 AH691 0.40 60 p2b_ah691.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="AH691" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_ah691.svg -l p2b_ah691.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 Carfentanil 0.40 60 p2b_carfentanil.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]carfentanil" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_carfentanil.svg -l p2b_carfentanil.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 FBPA 0.40 60 p2b_fbpa.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]FBPA" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_fbpa.svg -l p2b_fbpa.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 FDG 0.40 60 p2b_fdg_human.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]FDG" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_fdg_human.svg -l p2b_fdg_human.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 FDOPA 0.40 60 p2b_fdopa.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]FDOPA" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_fdopa.svg -l p2b_fdopa.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 flumazenil 0.40 60 p2b_flumazenil.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]flumazenil" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_flumazenil.svg -l p2b_flumazenil.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 fluoride 0.40 60 p2b_fluoride.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]fluoride" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_fluoride.svg -l p2b_fluoride.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 FMPEP-D2 0.40 60 p2b_fmpep-d2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]FMPEP-d2" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_fmpep-d2.svg -l p2b_fmpep-d2.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 FTHA 0.40 60 p2b_ftha.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]FTHA" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_ftha.svg -l p2b_ftha.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 MEAIB 0.40 60 p2b_meaib.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]MeAIB" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_meaib.svg -l p2b_meaib.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 MTO 0.40 60 p2b_mto.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]MTO" -y1=0 -y2=1.5 -xt="Time (min)" -yt="Plasma/blood" p2b_mto.svg -l p2b_mto.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 ORM-B 0.40 60 p2b_ormb.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]ORM-B" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_ormb.svg -l p2b_ormb.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 palmitate 0.40 60 p2b_palmitate.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]palmitate" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_palmitate.svg -l p2b_palmitate.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 PBR28HAB 0.40 60 p2b_pbr28hab.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM3 PBR28MAB 0.40 60 p2b_pbr28mab.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM3 PBR28LAB 0.40 60 p2b_pbr28lab.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacadd -ovr p2b_pbr28.dat p2b_pbr28hab.dat
tacadd p2b_pbr28.dat p2b_pbr28mab.dat
tacadd p2b_pbr28.dat p2b_pbr28lab.dat
tacren p2b_pbr28.dat 1 HAB__
tacren p2b_pbr28.dat 2 MAB__
tacren p2b_pbr28.dat 3 LAB__
tac2svg -legend=y -mt="[C-11]PBR28" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_pbr28.svg -l p2b_pbr28.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 PE2I 0.40 60 p2b_pe2i.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]PE2I" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_pe2i.svg -l p2b_pe2i.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 PK11195 0.40 60 p2b_pk11195.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]PK11195" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_pk11195.svg -l p2b_pk11195.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 SMW139 0.40 60 p2b_smw139.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]SMW139" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_smw139.svg -l p2b_smw139.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 UCB-J 0.43 90 p2b_ucb-j.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[C-11]UCB-J" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_ucb-j.svg -l p2b_ucb-j.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=p2b_ucb-j.dat UCB-J_p2b_median.fit temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.0001 temp.dat p2b_ucb-j.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 MOUSEFDG1 0.40 60 p2b_mousefdg1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]FDG in mice" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_mousefdg1.svg -l p2b_mousefdg1.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 MOUSEFDG2 0.40 60 p2b_mousefdg2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]FDG in mice" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_mousefdg2.svg -l p2b_mousefdg2.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 RATFDG 0.40 60 p2b_ratfdg.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="[F-18]FDG in rats" -y1=0 -xt="Time (min)" -yt="Plasma/blood" p2b_ratfdg.svg -l p2b_ratfdg.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n plot all fdg options together\n"
tacstudy --force p2b_fdg_human.dat Human
tacstudy --force p2b_ratfdg.dat Rat
tacstudy --force p2b_mousefdg1.dat Mouse1
tacstudy --force p2b_mousefdg2.dat Mouse2
tacren p2b_fdg_human.dat 0 ___
tacren p2b_ratfdg.dat 0 ___
tacren p2b_mousefdg1.dat 0 ___
tacren p2b_mousefdg2.dat 0 ___
tac2svg -y1=0.8 -x2=64 -legend=y -mt="[F-18]FDG" -yt="Plasma-to-blood ratio" -xt="Time (min)" p2b_fdg.svg -l p2b_fdg_human.dat p2b_ratfdg.dat p2b_mousefdg?.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


$PROGRAM3 NORBC 0.40 60 p2b_norbc.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="No tracer in red blood cells" -y1=0 -y2=2 -xt="Time (min)" -yt="Plasma/blood" p2b_norbc.svg -l p2b_norbc.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM3 inwater 0.40 60 p2b_inwater.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tac2svg -mt="Tracer in plasma and RBC water" -y1=0 -y2=1.5 -xt="Time (min)" -yt="Plasma/blood" p2b_inwater.svg -l p2b_inwater.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n passed. \n\n"


printf "\n 5.1.0 Test that output file is valid PMOD BLD. \n\n"

rm -f output.txt output2.txt

$PROGRAM3 MOUSEFDG1 0.40 60 p2b_mousefdg1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist -ift p2b_mousefdg1.dat > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt tacNr 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt tacname[1] P2B
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacformat p2b_mousefdg1.dat > output2.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftren output2.txt "" format
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output2.txt format PMOD
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n"
printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
