/// @file libtpcimgp.h
/// @brief Header file for libtpcimgp.
/// @author Vesa Oikonen
///
#ifndef _LIBTPCIMGP_H
#define _LIBTPCIMGP_H
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
//#include <omp.h>
/*****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdint.h>
#include <stdlib.h>
#include <strings.h>
#include <ctype.h>
#include <float.h>
#include <unistd.h>
#include <locale.h>
#include <time.h>
/*****************************************************************************/
#include "libtpcmisc.h"
#include "libtpcimgio.h"
/*****************************************************************************/

/*****************************************************************************/
/** PET image color scale */
#define	PET_GRAYSCALE     1
/** PET image color scale */
#define	PET_GRAYSCALE_INV 2
/** PET image color scale */
#define PET_RAINBOW       3
/** PET image color scale */
#define PET_RAINBOW_WB    4
/*****************************************************************************/
/** 3D image point */
typedef struct point{
  /** x coordinate */
  float x;
  /** y coordinate */
  float y;
  /** z coordinate */
  float z;
} point;
/*****************************************************************************/

/*****************************************************************************/
/* imgarithm */
extern int imgArithm(IMG *img1, IMG *img2, char operation, float ulimit, int verbose);
extern int imgArithmConst(IMG *img, float operand, char operation, float ulimit, int verbose);
extern int imgArithmFrame(IMG *img1, IMG *img2, char operation, float ulimit, int verbose);
extern int imgLn(IMG *img);
extern int imgLog10(IMG *img);
extern int imgAbs(IMG *img);
extern int imgInv(IMG *img);
extern int imgFrameIntegral(IMG *img, int first, int last, IMG *iimg, int verbose);
extern int imgRawCountsPerTime(IMG *img, int operation);
extern int imgConvertUnit(IMG *img, char *unit);
extern int imgAUMC(IMG *img, IMG *oimg, int verbose);
extern int imgMRT(IMG *img, IMG *oimg, int verbose);
/*****************************************************************************/

/*****************************************************************************/
/* imgeval.c */
extern int imgAverageTAC(IMG *img, float *tac);
extern int imgAverageMaskTAC(IMG *img, IMG *timg, float *tac);
extern int imgAverageAUC(IMG *img, float *avgauc);
extern int imgMaskTAC(IMG *img, IMG *mask, double *tac, int verbose);
extern int imgMaskRoiNr(IMG *img, INTEGER_LIST *list);
extern int imgVoiMaskTAC(IMG *img, IMG *mask, int mv, double *tac, int verbose);
/*****************************************************************************/

/*****************************************************************************/
/* imgfilter */
extern int imgGaussianFIRFilter(IMG *img, float xsd, float ysd, float zsd, double tolerance, int verbose);
extern int imgGaussianAMFilter(
  IMG *img, float xsd, float ysd, float zsd, int passNr, double tolerance, int verbose
);
extern int filterAMGaussian(double *a, int n, int passNr, double nu, double scale, int termNr);
extern int filterHSSBE(int n, int r);
extern double filterAMLB(double *a, int n, double nu, int termNr);
extern int imgGaussianEBoxFilter(
  IMG *img, float xsd, float ysd, float zsd, int passNr, int verbose
);
extern int filterEbox(double *a, int n, double wob, double wib, int rib, int passNr);
extern int fMean1DFilter(float *data, const int n, const int s);
extern int imgMeanFilter(IMG *img, int xn, int yn, int zn, int tn, int verbose);
/*****************************************************************************/

/*****************************************************************************/
/* imgflips */
extern void imgFlipHorizontal(IMG *img);
extern void imgFlipVertical(IMG *img);
extern void imgFlipPlanes(IMG *img);
extern int imgFlipRight(IMG *img);
extern int imgFlipAbove(IMG *img);
extern int imgMeanZ(IMG *img1, IMG *img2);
/*****************************************************************************/

/*****************************************************************************/
/* imgframe */
extern int imgFramesCheck(IMG *img, int verbose);
extern int imgFrameGapFill(IMG *img, int verbose);
extern int imgDeleteFrameOverlap_old(IMG *img);
extern int imgDeleteFrameOverlap(IMG *img);
extern int imgSmoothOverFrames(IMG *img, int n);
extern int imgGetFrameDiff(IMG *img, IMG *dimg, IMG *mimg, int verbose);
extern int imgGetFrameDyn(IMG *img, IMG *iimg, IMG *dimg, int verbose);
/* Deprecated functions. Please don't use these anymore */
/// @cond
#define NEW_imgDeleteFrameOverlap imgDeleteFrameOverlap
/// @endcond
/*****************************************************************************/

/*****************************************************************************/
/* imgscanner */
extern int imgSetScanner(IMG *img, int scanner_type);
/*****************************************************************************/

/*****************************************************************************/
/* imgsegm */
extern int imgsegmThresholdMask(
  IMG *img, float minValue, float maxValue, IMG *timg
);
extern int imgsegmThresholdByMask(
  IMG *img, IMG *template, float minValue, float maxValue
);
extern int imgsegmThreshold(
  IMG *img, float minValue, float maxValue
);
extern int imgsegmMaskToCluster(
  IMG *img
);
extern int imgsegmFindMaxOutsideClusters(
  IMG *sumimg, IMG *cluster, float *max, int *plane, int *row, int *col
);
extern int imgsegmClusterExpand(
  IMG *cluster, IMG *sum, IMG *dynamic, int clusterID,
  int pi, int ri, int ci, int pj, int rj, int cj, float CVlim, float CClim,
  int verbose
);
extern float imgsegmPearson(
  float *x, float *y, long long nr
);
extern int imgsegmClusterMean(
  IMG *dimg, IMG *cimg, int clusterID, float *avg, int verbose
);
extern int imgsegmCheckNeighbours(
  IMG *cimg, int pi, int ri, int ci
);
extern int imgsegmFindBestNeighbour(
  IMG *dimg, IMG *cimg, int pi, int ri, int ci
);
extern int imgsegmSimilar(
  IMG *input, int smoothDim, int smoothNr, IMG *output, int verbose
);
extern int imgsegmCalcMRL(
  float y1[], float y2[], long long n
);
/*****************************************************************************/

/*****************************************************************************/
/* imgthreshold */
extern int imgThresholding(IMG *img, float threshold_level, long long *thr_nr);
extern int imgThresholdingLowHigh(
  IMG *img, float lower_threshold_level, float upper_threshold_level,
  IMG *timg, long long *lower_thr_nr, long long *upper_thr_nr
);
extern int imgOutlierFilter(IMG *img, float limit);
extern int imgThresholdMaskCount(
  IMG *img, float minValue, float maxValue, IMG *timg, long long *count
);
extern int imgThresholdMask(
  IMG *img, float minValue, float maxValue, IMG *timg
);
extern int imgThresholdByMask(IMG *img, IMG *templt, float thrValue);
extern void imgCutoff(IMG *image, float cutoff, int mode);
extern int imgRegionGrowingByThreshold(
  IMG *img, const int sz, const int sy, const int sx, float lthr, float uthr,
  IMG *mask, int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* imgtiff */
extern int tiffWriteImg(
  IMG *img, int plane, int frame, float *maxvalue, int colorscale,
  char *fname, int matXdim, int matYdim,
  int verbose, char *status
);
/*****************************************************************************/

/*****************************************************************************/
/* imgtransform */
extern int img2cube(IMG *img1, int dim, IMG *img2);
extern void imgScale(IMG *src, IMG *targ, float zoom, int method);
extern void integerScale(int frame, float ***src, float **targ, int width, int height, int zoom);
extern int imgShrink(IMG *img1, IMG *img2, int doz);
extern int imgSwell(IMG *img1, IMG *img2, int doz);
/*****************************************************************************/

/*****************************************************************************/
/* mask.c */
extern long long imgMaskCount(IMG *img);
extern int imgMaskErode(IMG *img, IMG *se);
extern int imgMaskDilate(IMG *img, IMG *se);
extern int imgStructuringElement(IMG *img, const int structuring_element, int verbose);
extern void imgMaskInvert(IMG *img);
extern int imgMaskConjunction(IMG *mask1, IMG *mask2);
extern int imgMaskRegionLabeling(IMG *mask1, IMG *mask2, int *n, int verbose);
extern int imgMaskFloodFill(IMG *m, int sz, int sy, int sx, int label, long long *n, int verbose);
extern int imgMaskCloak(IMG *img, int dim, float id);
/*****************************************************************************/

/*****************************************************************************/
/* point */
extern int pRound(float);
extern float getDistance(point, point);
extern float getAngle(point, point);
/*****************************************************************************/

/*****************************************************************************/
#endif // _LIBTPCIMGP_H
