@echo off
setLocal EnableDelayedExpansion
@echo.
@echo ========================================================================
@echo test_rescoll.bat
@echo.
@echo ========================================================================
if exist stdout.txt del stdout.txt
@echo 1.1.1: option -h print user info
@echo on
..\rescoll -h > stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "See also"
if not %errorlevel%==0 goto FAILED
@echo passed.
iftisval_1_0_3 stdout.txt "Keywords"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo ========================================================================
if exist stdout.txt del stdout.txt
@echo 1.1.2: option --help print user info
@echo on
..\rescoll --help > stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "See also"
if not %errorlevel%==0 goto FAILED
@echo passed.
iftisval_1_0_3 stdout.txt "Keywords"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo ========================================================================
if exist stdout.txt del stdout.txt
if exist test.dat del test.dat
@echo 1.2.1: option -v prints software version info
@echo on
..\rescoll -v | grep --count Build > stdout.txt
addtimes stdout.txt
echo # Nr of lines containing Build >> stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
echo 0.5 3.0 > test.dat
dftmatch_1_1_5 stdout.txt test.dat
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo ========================================================================
if exist stdout.txt del stdout.txt
if exist test.dat del test.dat
@echo 1.2.2: option --version prints software version info
@echo on
..\rescoll --version | grep --count Build > stdout.txt
addtimes stdout.txt
echo # Nr of lines containing Build >> stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
echo 0.5 3.0 > test.dat
dftmatch_1_1_5 stdout.txt test.dat
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo ========================================================================
if exist stdout.txt del stdout.txt
@echo 1.2.3: option -build prints software version info
@echo on
..\rescoll -build | grep --count Build > stdout.txt
addtimes stdout.txt
echo # Nr of lines containing Build >> stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
del test.dat
echo 0.5 3.0 > test.dat
dftmatch_1_1_5 stdout.txt test.dat
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =========================================================================
if exist stderr.txt del stderr.txt
@echo 1.3.1: unknown option should lead to an error:
@echo on
..\rescoll -nonexistingoption test450?.res 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt Error "invalid option -nonexistingoption"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
@echo.
@echo =============================================================================
@echo 2.1.1: tabulation file name not given
@echo on
..\rescoll test450?.res
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
@echo 2.1.2: tabulation file name with wrong extension
if exist stderr.txt del stderr.txt
@echo on
..\rescoll collected.txt test450?.res 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "collection file extension must be .htm or .html"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist collected.html del collected.html
@echo 2.2.1: tabulation file does not exist (like it normally shouldn't)
@echo on
..\rescoll collected.html test450?.res
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist collected.html.bak del collected.html.bak
@echo 2.2.2: tabulation file exists (should not be a problem)
@echo on
..\rescoll collected.html test450?.res
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
if not exist collected.html.bak goto FAILED
@echo passed.
@echo.
@echo =============================================================================
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
if exist collected.html del collected.html
@echo 3.1.1: no res files are given
@echo on
..\rescoll collected.html 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "no result files to process."
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 3.1.2: just one res file is given
@echo on
del collected.html
..\rescoll collected.html test4502.res 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "at least two result files must be given."
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 3.2.1: non-existing resultfile. Error must be printed.
@echo on
..\rescoll collected.htm test450?.res nonexisting.res 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "result file nonexisting.res does not exist."
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 3.2.2: one of several result files has wrong format. Warning.
@echo on
..\rescoll collected.htm test450?.res test_rescoll.bat 2> stderr.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Warning" "'test_rescoll.bat' not read: wrong format"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 3.2.3: one of two result files has wrong format. Error.
@echo on
..\rescoll collected.htm test4500.res test_rescoll.bat 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Warning" "'test_rescoll.bat' not read: wrong format"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "only one result file could be read."
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 3.3.1: software name is different. Error.
@echo on
..\rescoll collected.htm test450?.res test5000.res 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "different software used in result files."
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 3.3.2: parameter number is different. Error.
@echo on
..\rescoll collected.htm test450?.res test6000.res 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "different parameter nr in result files."
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 3.3.3: parameter name is different. Error.
@echo on
..\rescoll collected.htm test450?.res test6001.res 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "different parameters in result files."
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 3.4.1: duplicate region names. Error.
@echo on
..\rescoll collected.htm test450?.res test7000.res 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error" "test7000.res contains duplicate region names."
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
@echo.
@echo =============================================================================
if exist stderr.txt del stderr.txt
@echo 4.1.1: Option -strict; one of several result files has wrong format. Error.
@echo on
..\rescoll -strict collected.htm test450?.res test_rescoll.bat 2> stderr.txt
@echo off
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stderr.txt "Error in reading 'test_rescoll.bat'" "wrong format"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
@echo.
@echo =============================================================================
if exist stdout.txt del stdout.txt
@echo 5.1.1: Option -silent: without it
@echo on
..\rescoll collected.htm test450?.res > stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "file[1]" "test4500.res"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "file[2]" "test4501.res"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "file[3]" "test4502.res"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "file[4]" "test4503.res"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "region_name[1]" "refer mean All"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "region_name[2]" "reg1 mean All"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "region_name[3]" "reg2 mean All"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "region_name[4]" "reg3 mean All"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stdout.txt del stdout.txt
@echo 5.1.2: Option -silent: with it
@echo on
..\rescoll -silent collected.htm test450?.res > stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "file[1]"
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "region_name[1]"
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftlist_1_0_3 stdout.txt
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
@echo.
@echo =============================================================================
if exist stdout.txt del stdout.txt
@echo 6.1.1: Option -sort: without it
@echo on
..\rescoll collected1.html test4503.res test4502.res test4500.res test4501.res > stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "study_number[1]" "test4503"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "study_number[2]" "test4502"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "study_number[3]" "test4500"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "study_number[4]" "test4501"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
if exist stdout.txt del stdout.txt
@echo 6.1.2: Option -sort: with it
@echo on
..\rescoll -sort collected2.html test4503.res test4502.res test4500.res test4501.res > stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "study_number[1]" "test4500"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "study_number[2]" "test4501"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "study_number[3]" "test4502"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "study_number[4]" "test4503"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo =============================================================================
@echo.
@echo =============================================================================
@echo 7.1.1: Same ROIs
@echo on
..\rescoll test_7_1_1.html test450?.res
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo CHECK THE CONTENTS OF test_7_1_1.html AGAINST valid_7_1_1.html !!!
@echo.
@echo =============================================================================
@echo 7.1.2: Compatibility with spreadheet software
@echo.
@echo CHECK THAT FILE test_7_1_1.html can be read into MS Excel 2002 or later !!!
@echo.
@echo =============================================================================
if exist temp.res del temp.res
@echo 7.2.1: One result file contains one region less than the others
resdel -o=temp.res test4501.res 2
@echo on
..\rescoll -sort test_7_2_1.html test4500.res test4502.res test4503.res temp.res
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo CHECK THE CONTENTS OF test_7_2_1.html AGAINST valid_7_2_1.html !!!
@echo.
@echo =============================================================================
@echo 7.2.2: One result file contains one extra region
@echo on
..\rescoll -sort test_7_2_2.html test4500.res test4501.res test4502.res test4513.res
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo CHECK THE CONTENTS OF test_7_2_2.html AGAINST valid_7_2_2.html !!!
@echo.
@echo =============================================================================
@echo 7.3.1: One result file contains different region names: hemisphere field is empty,
@echo        when in others it has some content
@echo on
..\rescoll -sort test_7_3_1.html test4500.res test4501.res test4512.res test4503.res
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo CHECK THE CONTENTS OF test_7_3_1.html AGAINST valid_7_3_1.html !!!
@echo.
@echo =============================================================================
@echo 7.3.2: One result file contains different region names: plane field is empty,
@echo        when in others it has some content
@echo on
..\rescoll -sort test_7_3_2.html test4500.res test4501.res test4522.res test4503.res
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo CHECK THE CONTENTS OF test_7_3_2.html AGAINST valid_7_3_2.html !!!
@echo.
@echo =============================================================================
@echo.
@echo =============================================================================
if exist stdout.txt del stdout.txt
@echo 8.0.0: Option -list: all result files
@echo on
..\rescoll -list test_8_0_0.html test*.res > stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "file[1]" "test4500.res"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "file[11]" "test7000.res"
if not %errorlevel%==0 goto FAILED
@echo passed.
iftisval_1_0_3 stdout.txt "study_number[1]" "test4500"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "study_number[11]" "test4500"
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo CHECK THE CONTENTS OF test_8_0_0.html AGAINST valid_8_0_0.html !!!
@echo.
@echo =============================================================================
if exist stdout.txt del stdout.txt
if exist stderr.txt del stderr.txt
@echo 8.0.1: Option -list: all result files
@echo on
..\rescoll -list test_8_0_1.html test4501.res > stdout.txt
@echo off
if not %errorlevel%==0 goto FAILED
@echo passed.
@echo.
iftisval_1_0_3 stdout.txt "file[1]" "test4501.res"
if not %errorlevel%==0 goto FAILED
@echo passed.
iftisval_1_0_3 stdout.txt "study_number[1]" "test4501"
if not %errorlevel%==0 goto FAILED
iftisval_1_0_3 stdout.txt "study_number[2]"
if %errorlevel%==0 goto FAILED
@echo passed.
@echo.
@echo CHECK THE CONTENTS OF test_8_0_1.html AGAINST valid_8_0_1.html !!!
@echo.
@echo =============================================================================
@echo.


:ALL_PASSED
@echo =============================================================
@echo.
@echo All test passed!
@echo.
goto END
:FAILED
@echo.
@echo Failed!
@echo.
:END
@echo =============================================================
@echo.
