#!/bin/bash
#: Title      : test_fit2dat
#: Date       : 2023-04-06
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../fit2dat$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f parent.rat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f tissue.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f step.fit ] || [ ! -f step.dat ]; then
  printf "FIT1        General\n" > step.fit
  printf "Date:	\n" >> step.fit
  printf "Data file:	\n" >> step.fit
  printf "Data unit:	unknown\n" >> step.fit
  printf "Time unit:	unknown\n" >> step.fit
  printf "Nr of VOIs:	2\n" >> step.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> step.fit
  printf "Step1	0.000	60.000	100	0	2	1010	10	1\n" >> step.fit
  printf "Step2	0.000	60.000	100	0	8	1010	0	1	10	0	20	1	30	0\n" >> step.fit

  printf "0	0	1\n" > step.dat
  printf "1	0	1\n" >> step.dat
  printf "2	0	1\n" >> step.dat
  printf "3	0	1\n" >> step.dat
  printf "4	0	1\n" >> step.dat
  printf "5	0	1\n" >> step.dat
  printf "6	0	1\n" >> step.dat
  printf "7	0	1\n" >> step.dat
  printf "8	0	1\n" >> step.dat
  printf "9	0	1\n" >> step.dat
  printf "10	1	0\n" >> step.dat
  printf "11	1	0\n" >> step.dat
  printf "12	1	0\n" >> step.dat
  printf "13	1	0\n" >> step.dat
  printf "14	1	0\n" >> step.dat
  printf "15	1	0\n" >> step.dat
  printf "16	1	0\n" >> step.dat
  printf "17	1	0\n" >> step.dat
  printf "18	1	0\n" >> step.dat
  printf "19	1	0\n" >> step.dat
  printf "20	1	1\n" >> step.dat
  printf "21	1	1\n" >> step.dat
  printf "22	1	1\n" >> step.dat
  printf "23	1	1\n" >> step.dat
  printf "24	1	1\n" >> step.dat
  printf "25	1	1\n" >> step.dat
  printf "26	1	1\n" >> step.dat
  printf "27	1	1\n" >> step.dat
  printf "28	1	1\n" >> step.dat
  printf "29	1	1\n" >> step.dat
  printf "30	1	0\n" >> step.dat
  printf "31	1	0\n" >> step.dat
  printf "32	1	0\n" >> step.dat
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Fit Hill-type function to fraction curve and use fit2dat to \n"
printf " calculate and extrapolate the fitted fractions to 90 min. \n"
printf " Check the plot of original and fitted data: fraction1a.svg \n\n"

rm -f parent.fit fraction1a.dat fraction1a.svg
fit_ppf -model=hill -w1 parent.rat parent.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -a=90 parent.fit fraction1a.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg fraction1a.svg -s parent.rat -l fraction1a.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n 1.0.1 \n"
printf " Above fitted Hill-type function is used to simulate fraction curve \n"
printf " at random times with even distribution. \n"
printf " Check the plot of original and fitted data: fraction1b.svg \n\n"

rm -f fraction1b.dat fraction1b.svg

$PROGRAM -r=10,90,50 parent.fit fraction1b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg fraction1b.svg -s fraction1b.dat -l fraction1a.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"



printf "\n 1.0.2 \n"
printf " Above fitted Hill-type function is used to simulate fraction curve \n"
printf " at random times with distribution biased towards low abs values. \n"
printf " Check the plot of original and fitted data: fraction1c.svg \n\n"

rm -f fraction1c.dat fraction1c.svg

$PROGRAM -rst=0,120,20 parent.fit fraction1c.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg fraction1c.svg -s fraction1c.dat -l fraction1a.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n\n===============================================================\n\n"



printf "\n 2.0.0 \n"
printf " Fit rational function (pol3/pol2) to PET tissue curve and use \n"
printf " fit2dat to calculate the fitted tissue curve at measurement times. \n"
printf " Check the plot of original and fitted data: tissue2a.svg \n\n"

rm -f tissue.fit tissue2a.dat tissue2a.svg
fit_ratf -p3p2 tissue.dft tissue.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -f=tissue.dft tissue.fit tissue2a.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg tissue2a.svg -s tissue.dft -l tissue2a.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.5 -rel=5 tissue.dft tissue2a.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Use fit2dat to calculate the fitted tissue curve at 4 points \n"
printf " between fit start and end times. \n"
printf " Check the plot of original and fitted data: tissue2b.svg \n\n"

rm -f tissue2b.dat tissue2b.svg

$PROGRAM -n=4 tissue.fit tissue2b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg tissue2b.svg -s tissue.dft -l tissue2b.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n 2.0.2 \n"
printf " Use fit2dat to calculate the fitted tissue curve at \n"
printf " 10 and 90 minutes. \n"
printf " Check the plot of original and fitted data: tissue2c.svg \n\n"

rm -f tissue2c.dat tissue2c.svg
# For comparison, the same values are inter/extrapolated with interpol
interpol -a -x=10,90 tissue.dft interp_tissue2c.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -x=10,90 tissue.fit tissue2c.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg tissue2c.svg -s interp_tissue2c.dat -l tissue2c.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"



printf "\n 2.0.3 \n"
printf " Use fit2dat to calculate the fitted tissue curve \n"
printf " between 10 and 60 minutes at every 10 minutes. \n"
printf " Check the plot of original and fitted data: tissue2d.svg \n\n"

rm -f tissue2d.dat tissue2d.svg

$PROGRAM -c=10,60,10 tissue.fit tissue2d.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg tissue2d.svg -s tissue.dft -l tissue2d.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"



printf "\n 3.0.0 \n"
printf " Test step function \n\n"

rm -f output.dat

$PROGRAM -c=0,32,1 step.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch step.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

