#!/bin/bash
#: Title      : test_fit_hiad
#: Date       : 2016-01-31
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../fit_hiad$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f typical.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f typical_hill.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n\n making test data \n"

if [ ! -f typical.dat ]; then
  printf "\n making typical.dat \n"
  fit2dat -n=15 typical.fit typical.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f typical_k0.fit ]; then
  fitedit typical.fit 5 1 0 typical_k0.fit
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f typical_k0.dat ]; then
  printf "\n making typical_k0.dat \n"
  fit2dat -n=15 typical_k0.fit typical_k0.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f typical_hill.dat ]; then
  printf "\n making typical_hill.dat \n"
  fit2dat -n=15 typical_hill.fit typical_hill.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f typical_hill_half.fit ]; then
  fitedit typical_hill.fit 2 1 50 typical_hill_half.fit
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f typical_hill_half.dat ]; then
  printf "\n making typical_hill_half.dat \n"
  fit2dat -n=15 typical_hill_half.fit typical_hill_half.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Executed with typical data and with default settings. \n"
printf " Test case 2: Options and arguments are correctly set. \n"
printf " Expected result: Good fitting result with no errors. \n"
printf " Options and variables have correct values in test mode. \n\n"

rm -f output.fit output.dat stdout.txt

$PROGRAM -d2 typical.dat output.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=typical.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt datfile "typical.dat"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt parfile "output.fit"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt resfile ""
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt fitfile ""
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt svgfile ""
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt type "1821"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt weights "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt MRL_check "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n===============================================================\n\n"

printf "\n 1.1.0 \n"
printf " Test case: Executed with typical data with k constrained to 0. \n"
printf " Expected result: Good fitting result with no errors. \n\n"

rm -f output.fit output.dat

$PROGRAM -k=0 typical_k0.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=typical_k0.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical_k0.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n===============================================================\n\n"

printf "\n 1.2.0 \n"
printf " Test case: Data file may contain more than one TAC. \n"
printf " Expected result: All curves are fitted. \n\n"

rm -f output.fit output.dat
tacadd -ovr temp.dat typical.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacadd -force temp.dat typical_k0.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -svg=test_1_2_0.svg temp.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=temp.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 temp.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n===============================================================\n"
printf "   Hill fit without derivative \n"
printf "===============================================================\n\n"



printf "\n 2.0.0 \n"
printf " Test case 1: Executed with typical data and with default Hill settings. \n"
printf " Test case 2: Options and arguments are correctly set. \n"
printf " Expected result: Good fitting result with no errors. \n"
printf " Options and variables have correct values in test mode. \n\n"

rm -f output.fit output.dat stdout.txt

$PROGRAM -d2 -Hill typical_hill.dat output.fit &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=typical_hill.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical_hill.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval stdout.txt datfile "typical_hill.dat"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt parfile "output.fit"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt resfile ""
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt fitfile ""
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt svgfile ""
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt type "1801"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt weights "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt MRL_check "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n===============================================================\n\n"

printf "\n 2.1.0 \n"
printf " Test case: Data file may contain more than one TAC. \n"
printf " Expected result: All curves are fitted. \n\n"

rm -f output.fit output.dat
tacadd -ovr temp.dat typical_hill.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacadd -force temp.dat typical_hill_half.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -hill -svg=test_2_1_0.svg temp.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=temp.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 temp.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n===============================================================\n"
printf "   Testing options for constraining parameters \n"
printf "===============================================================\n\n"

printf "\n 3.0.0 \n"
printf " Test case: Option -n=1 for fixing parameter n \n"
printf " Expected result: Probably bad fit but parameter is as required. \n\n"


rm -f output.fit output.ift

$PROGRAM -n=1 typical.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output.fit output.ift 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift p4 "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.fit output.ift

$PROGRAM -n=1 typical_hill.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output.fit output.ift 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift p4 "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: Option -k=0.01 for fixing parameter k \n"
printf " Expected result: Probably bad fit but parameter is as required. \n\n"


rm -f output.fit output.ift

$PROGRAM -k=0.01 typical.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output.fit output.ift 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift p5 "0.01"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.2.0 \n"
printf " Test case: Option -delay=2 for fixing delay parameter.\n"
printf " Expected result: Probably bad fit but parameter is as required. \n\n"


rm -f output.fit output.ift

$PROGRAM -delay=2 typical.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output.fit output.ift 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift p1 "2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.fit output.ift

$PROGRAM -delay=2 typical_hill.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=ift output.fit output.ift 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift p1 "2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.1 \n"
printf " Test case: Option -delay=mean for fixing delay parameter.\n"
printf " Expected result: No effect with one TAC. \n\n"


rm -f output.fit output.ift

$PROGRAM -delay=mean typical.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=typical.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.2 \n"
printf " Test case: Option -delay=median for fixing delay parameter.\n"
printf " Expected result: No effect with one TAC. \n\n"

rm -f output.fit output.ift

$PROGRAM -delay=median typical.dat output.fit 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=typical.dat output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -abs=0.5 -rel=1 typical.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n===============================================================\n"
printf "   Testing weights, weighting options, and missing values \n"
printf "===============================================================\n\n"

printf "\n Not tested. \n\n"



printf "\n\n===============================================================\n"
printf "   Tests for error handling \n"
printf "===============================================================\n\n"


printf "\n 5.0.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Appropriate error message and error code returned. \n\n"

rm -f output.fit output.dat stdout.txt

$PROGRAM -stupidoption typical.dat output.fit &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 5.1.0 \n"
printf " Test case: Obligatory argument is missing. \n"
printf " Expected result: error code returned. \n\n"

rm -f output.fit output.dat stdout.txt

$PROGRAM  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.1.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Appropriate error message and error code returned. \n\n"

rm -f output.fit output.dat stdout.txt

$PROGRAM typical.dat output.fit extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.2.0 \n"
printf " Test case: Nonexisting data file. \n"
printf " Expected result: Appropriate error message and error code returned. \n\n"

rm -f output.fit output.dat stdout.txt

$PROGRAM nonexistingfile.dat output.fit &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexistingfile.dat'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.3.0 \n"
printf " Test case: Wrong data file format. \n"
printf " Expected result: Appropriate error message and error code returned. \n\n"

echo bleah meh > temp.dat
echo more rubbish >> temp.dat
rm -f output.fit output.dat stdout.txt

$PROGRAM temp.dat output.fit &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'temp.dat'" "wrong format"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n\n===============================================================\n"
printf "   Testing optional output data \n"
printf "===============================================================\n\n"


printf "\n 7.0.0 \n"
printf " Test case: SVG plot can be saved optionally. \n"
printf " Expected result: SVG file is created. \n\n"

rm -f output.fit output.dat stdout.txt output.svg

$PROGRAM -svg=output.svg typical.dat output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.svg ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 7.1.0 \n"
printf " Test case: Fitted TAC can be saved optionally. \n"
printf " Expected result: TAC file is created, and contents match the one \n"
printf "                  computed with fit2dat \n\n"

rm -f output.fit output.dat stdout.txt output2.dat

$PROGRAM -fit=output2.dat typical.dat output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output2.dat ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=typical.dat output.fit output.dat 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -y=y -abs=0.01 -rel=0.1 output.dat output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 7.2.0 \n"
printf " Test case: Fitted parameters can be saved in result format. \n"
printf " Expected result: RES file is created, and contents are close to correct. \n\n"

rm -f output.fit output.res

$PROGRAM -res=output.res typical.dat output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.res ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


