#!/bin/bash
#: Title      : test_paucinf
#: Date       : 2018-06-11
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../paucinf$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f plasma.dat ] || [ ! -f plasma.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f plasma2.dat ] || [ ! -f plasma2f.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f plasma3.dat ] || [ ! -f plasma3.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f plasma4.dat ] || [ ! -f plasma5.dat ] || [ ! -f plasma_na.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f plasma_few2.dat ] || [ ! -f plasma_few4.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f true1.res ] || [ ! -f true3.res ] || [ ! -f true4.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Reasonable data, default settings. \n"
printf " Expected result: Correct results saved and printed. \n\n"

rm -f stdout.txt output.res output.svg

$PROGRAM -svg=output.svg plasma.dat output.res > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -abs=0.01 -rel=1 true1.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "AUC(0-Inf)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "k(el)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Result file name not given. \n"
printf " Expected result: Results printed. \n\n"

rm -f stdout.txt

$PROGRAM plasma.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "AUC(0-Inf)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "k(el)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Datafile contains two TACs. \n"
printf " Expected result: Correct results saved. \n\n"

rm -f output3.res output3.svg

$PROGRAM -svg=output3.svg plasma3.dat output3.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -abs=0.01 -rel=1 true3.res output3.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi


printf "\n 1.2.0 \n"
printf " Test case: option -winnonlin used. \n"
printf " Expected result: Correct results saved. \n\n"

rm -f output4.res output4.svg

$PROGRAM -winnonlin -svg=output4.svg plasma4.dat output4.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -abs=0.01 -rel=1 true4.res output4.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption plasma.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat output.res extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.tac output.res &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexistingfile.tac'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.0 \n"
printf " Test case: Invalid data file contents. \n"
printf " Expected result: Error. \n\n"

rm -f badfile.dat
printf "# badfile\n"  > badfile.dat
printf "ugh banzai\n" >> badfile.dat
printf "2 meh\n"      >> badfile.dat

rm -f stdout.txt
$PROGRAM badfile.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'badfile.dat'" "wrong format"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.3.0 \n"
printf " Test case: Datafile contains less than 3 samples. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM plasma_few2.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "too few samples for exponential fitting"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.3.1 \n"
printf " Test case: Datafile contains less than 5 samples. \n"
printf " Expected result: Warning. \n\n"

rm -f stdout.txt

$PROGRAM plasma_few4.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "few samples for exponential fitting"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.4.0 \n"
printf " Test case: Datafile has missing values. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM plasma_na.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing sample(s) in plasma_na.dat"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"



printf "\n 3.0.0 \n"
printf " Test case: Option -end used to limit fit time. \n"
printf " Expected result: Correct results saved. \n\n"

rm -f stdout.txt output2.res output2.svg

$PROGRAM -end=5 -svg=output2.svg plasma2.dat output2.res > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

parmatch -abs=0.01 -rel=1 true1.res output2.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: Option -end leads to too few samples. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM -end=0.9 plasma2.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "too few samples for exponential fitting"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.1 \n"
printf " Test case: Option -end leads to maybe too few samples. \n"
printf " Expected result: Warning. \n\n"

rm -f stdout.txt

$PROGRAM -end=1.05 plasma2.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "few samples for exponential fitting"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.0 \n"
printf " Test case: Option -start. \n"
printf " Expected result: Correct results. \n\n"

rm -f outputs.res outputs.svg

$PROGRAM -start=2 -svg=outputs.svg plasma.dat outputs.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.01 -rel=1 -par=1-3,5 true1.res outputs.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

parformat -f=ift outputs.res outputs.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 outputs.ift "Start" 2.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.3.0 \n"
printf " Test case 1: Data contains outlier which would cause fit to start too late. \n"
printf " Test case 2: Option -minnr. \n"
printf " Expected result: Fit started from the original start time. \n\n"

rm -f outputmn.res outputmn.svg

$PROGRAM -minnr=35 -svg=outputmn.svg plasma5.dat outputmn.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -abs=0.01 -rel=1 -par=1,2 true1.res outputmn.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=5 -par=3,5 true1.res outputmn.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

parformat -f=ift outputmn.res outputmn.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 outputmn.ift "Start" 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

