#!/bin/bash
#: Title      : test_dftavg
#: Date       : 2014-10-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dftavg$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f dftavg.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_test1.dft ] || [ ! -f correct_test3.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Average over planes, removing original TACs. \n"
printf " Test case 2: Average over voi1. \n"
printf " Test case 3: Average over voi2 and voi3. \n"
printf " Expected result: Edited file contents are correct. \n\n"

cp -f dftavg.dft temp.dft

$PROGRAM -rm temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.dft voi1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM temp.dft voi2 voi3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.1 -rel=0.1 correct_test1.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.0 \n"
printf " Test case 1: Average over hemispheres when not available. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
tacadd -ovr temp.dft dftavg.dft pl04
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacadd temp.dft dftavg.dft pl05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacadd temp.dft dftavg.dft pl06
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -hemispheres -rm temp.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "no hemispheres to average were found."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 3.0.0 \n"
printf " Test case 1: Average over planes, removing original TACs. \n"
printf " Test case 2: Average over hemispheres of voi1, removing original TACs. \n"
printf " Expected result: Edited file contents are correct. \n\n"

cp -f dftavg.dft temp.dft

$PROGRAM -rm temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -hemispheres -rm temp.dft voi1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y -abs=0.1 -rel=0.1 correct_test3.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

