#!/bin/bash
#: Title      : test_dftscale
#: Date       : 2014-11-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dftscale$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n making data for testing \n"


if [ ! -f test1.dat ] || [ ! -f test2.dat ]; then
  rm -f test1.dat test2.dat
  printf "1 0 0\n" >> test1.dat
  printf "2 2 3\n" >> test1.dat
  printf "3 3 4\n" >> test1.dat
  printf "4 2 3\n" >> test1.dat
  printf "5 1 2\n" >> test1.dat
  printf "# timeunit := min\n# unit := kBq/mL\n" >> test1.dat
  printf "2 20 30\n" >> test2.dat
  printf "3 30 40\n" >> test2.dat
  printf "4 20 30\n" >> test2.dat
  printf "5 10 20\n" >> test2.dat
  printf "6 10 10\n" >> test2.dat
  printf "# timeunit := min\n# unit := kBq/mL\n" >> test2.dat
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Scale file2 to the level of file1 with default time range. \n"
printf " Expected result: Correctly scaled file is created. \n\n"

rm -f output.dat
taccalc test2.dat x 0.1 correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM test1.dat test2.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y test100.svg test1.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -abs=0.001 -rel=0.001 correct.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.0 \n"
printf " Test case: Scale file2 max peak to 1. \n"
printf " Expected result: Correctly scaled file is created. \n\n"

rm -f output.dat
taccalc test2.dat : 40 correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM 1 test2.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y test200.svg output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -abs=0.001 -rel=0.001 correct.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

