/** @file bigend.c
 *  @brief Report the byte order of the current platform.
 *  @copyright (c) Turku PET Centre
 *  @author Vesa Oikonen
 */
/// @cond
/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
/*****************************************************************************/
#include "libtpcmisc.h"
/*****************************************************************************/

/*****************************************************************************/
static char *info[] = {
  "Reports the byte order of the current platform.",
  "Big endian computers include Sun Sparc, Motorola, and PowerPC,",
  "while PC/Intel computers are little endian.",
  "Programs return code is either 1 (big endian) or 0 (little endian),",
  "and, by default, either one of the following is printed on screen:",
  "  byte_order := big",
  "  byte_order := little",
  " ",
  "Usage: @P [Options]",
  " ",
  "Options:",
  " -stdoptions", // List standard options like --help, -v, etc
  " ",
  "See also: convend, img2flat, flat2img, anabyteo",
  " ",
  "Keywords: image, byte order, big endian, little endian",
  0};
/*****************************************************************************/

/*****************************************************************************/
/* Turn on the globbing of the command line, since it is disabled by default in
   mingw-w64 (_dowildcard=0); in MinGW32 define _CRT_glob instead, if necessary;
   In Unix&Linux wildcard command line processing is enabled by default. */
/*
#undef _CRT_glob
#define _CRT_glob -1
*/
int _dowildcard = -1;
/*****************************************************************************/

/*****************************************************************************/
/**
 *  Main
 */
int main(int argc, char **argv)
{
  int       ai, help=0, version=0, verbose=1;
  char     *cptr;


  /*
   *  Get arguments
   */
  //if(argc==1) {tpcPrintUsage(argv[0], info, stderr); return(1);}
  /* Options */
  for(ai=1; ai<argc; ai++) if(*argv[ai]=='-') { /* options */
    cptr=argv[ai]+1; if(*cptr=='-') cptr++; if(cptr==NULL) continue;
    if(tpcProcessStdOptions(argv[ai], &help, &version, &verbose)==0) continue;
    fprintf(stderr, "Error: invalid option '%s'\n", argv[ai]);
    return(1);
  } else break;
  
  /* Print help or version? */
  if(help==2) {tpcHtmlUsage(argv[0], info, ""); return(0);}
  if(help) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  if(version) {tpcPrintBuild(argv[0], stdout); return(0);}

  /* Process other arguments, starting from the first non-option */
  if(ai<argc) {
    fprintf(stderr, "Error: invalid argument '%s'\n", argv[ai]);
    return(1);
  }

  if(little_endian()) {
    if(verbose>0) printf("byte_order := little\n");
    return(0);
  }
  if(verbose>0) printf("byte_order := big\n");
  return(1);
}
/*****************************************************************************/

/*****************************************************************************/
/// @endcond
