#!/bin/bash
#: Title      : test_asc2flat
#: Date       : 2014-09-21
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../asc2flat$EXT;

rm -f asc2flat_labyr.tif
rm -f asc2flat_labyr2.tif
rm -f asc2flat_cortex.tif
rm -f asc2flat_cortex2.tif


printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n0.1.0\n"

printf "Nonexisting argument file should give an error\n"
$PROGRAM -d nonexistingfile.dat
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.1.1\n"

printf "Binary file as argument file should not crash program\n"
$PROGRAM -d $PROGRAM meh.bin
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n1.0.0\n"

$PROGRAM asc2flat_labyr.dat labyr.flo
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
flat2img -zoom=2 -scanner=hr+ labyr.flo labyr.v 1 1 16 16
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
img2tif -rb labyr.v labyr.tif
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n1.0.1\n"

$PROGRAM asc2flat_labyr2.dat labyr2.flo
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
flat2img -zoom=2 -scanner=hr+ labyr2.flo labyr2.v 1 1 16 16
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
img2tif -rb labyr2.v labyr2.tif
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n1.1.0\n"

$PROGRAM asc2flat_cortex.dat cortex.flo
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
flat2img -zoom=2 -scanner=hr+ cortex.flo cortex.v 1 1 32 32
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
img2tif -rb cortex.v cortex.tif
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.1.1\n"

$PROGRAM asc2flat_cortex2.dat cortex2.flo
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
flat2img -zoom=2 -scanner=hr+ cortex2.flo cortex2.v 1 1 32 32
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n"
img2tif -rb cortex2.v cortex2.tif
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
