#!/bin/bash
#: Title      : test_abssexam
#: Date       : 2016-12-12
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../abssexam$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f ../data/t00061.alg ] || [ ! -f ../data/ME_ABSS09282_is731dy1.txt ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/us1316.bld ] || [ ! -f ../data/us1317.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/us1318.bld ] || [ ! -f ../data/us1319.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/us1320.bld ] || [ ! -f ../data/us1321.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../data/ep0152_blo.lis ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Examine Scanditronics and GEMS files. \n"
printf " Expected result: Finds the fails that it should with default limit. \n\n"

rm -f stdout.csv
rm -f output.ift

$PROGRAM --silent ../data/us131?.bld ../data/us1320.bld ../data/us1321.bld ../data/ep*_blo.lis > stdout.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
csv2ift stdout.csv output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift "[1][5]" "../data/us1321.bld"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output.ift "[1][2]" 0.207
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: Examine Scanditronics and GEMS files. \n"
printf " Expected result: Finds the fails that it should with user-defined limit. \n\n"

rm -f stdout.csv
rm -f output.ift

$PROGRAM --silent -limit=0.9 ../data/us131?.bld ../data/us1320.bld ../data/us1321.bld ../data/ep*_blo.lis > stdout.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
csv2ift stdout.csv output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift "[1][5]" "../data/us1321.bld"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output.ift "[1][2]" 0.207
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift "[2][5]" "../data/ep0152_blo.lis"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output.ift "[2][2]" 0.805
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM -stupidoption ../data/us131?.bld &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Other files are processed as usual. \n\n"

$PROGRAM --silent -limit=0.9 nonexistingfile.dat ../data/us131?.bld ../data/us1320.bld ../data/us1321.bld ../data/ep*_blo.lis > stdout.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
csv2ift stdout.csv output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift "[1][5]" "../data/us1321.bld"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output.ift "[1][2]" 0.207
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift "[2][5]" "../data/ep0152_blo.lis"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.05 output.ift "[2][2]" 0.805
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.1 \n"
printf " Test case: Allogg format cannot be processed. \n"
printf " Expected result: Error. \n\n"

cp -f  test.bld
rm -f stdout.txt

$PROGRAM ../data/t00061.alg ../data/ME_ABSS09282_is731dy1.txt &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "no on-line sampler datafile was successfully examined."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "bypassed ../data/t00061.alg" "ABSS-ALLOGG-OLD format."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "bypassed ../data/ME_ABSS09282_is731dy1.txt" "ABSS-ALLOGG format."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

