#!/bin/bash
#: Title      : test_dcmmlist
#: Date       : 2017-11-08
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../dcmmlist$EXT;


printf "\n====================================================================\n"
printf "verifying that required data exists for %s\n" $PROGRAM
printf "====================================================================\n"


if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

DCMFILE1=../dicom/f170.dcm
if [ ! -f $DCMFILE1 ]; then
  printf "Failed: test file does not exist.\n"
  exit 1
fi
DCMFILE2=../dicom/f30.dcm
if [ ! -f $DCMFILE2 ]; then
  printf "Failed: test file does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: List matrices default settings. \n"
printf " Expected result: Contents are listed. \n\n"

rm -f output.tsv

$PROGRAM -d $DCMFILE1 > output.tsv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

