#!/bin/bash
#: Title      : test_execlong
#: Date       : 2017-10-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../execlong$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Dry run. \n"
printf " Expected result: Correct command line made. \n\n"

printf "command\n"    >  test.ift
printf "key := :=\n"  >> test.ift
printf "arg1\n"       >> test.ift
printf "arg2\n"       >> test.ift

rm -f output.txt
$PROGRAM -dry test.ift > output.txt 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt command "arg1 arg2"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "key := command := arg1 arg2\n"    >  test.ift

rm -f output.txt
$PROGRAM -dry test.ift > output.txt 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.txt command "arg1 arg2"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n If command shell not available, the stop testing. \n"
$PROGRAM test.ift 
if [ $? -eq 10 ] ; then exit 0 ; fi
printf "\n ok \n"




printf "\n 1.2.0 \n"
printf " Test case: Run simple system command. \n"
printf " Expected result: Correctly executed. \n\n"

printf "ls\n"       >  test.ift
printf '%s\n' '-l'  >> test.ift
printf ".\n"        >> test.ift

rm -f output.txt
$PROGRAM test.ift > output.txt 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Run non-existing command. \n"
printf " Expected result: Return value is not standardized, thus not tested. \n\n"

printf "./nonexisting arg1\n"  >  test.ift

$PROGRAM test.ift
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
