#!/bin/bash
#: Title      : test_iftlist
#: Date       : 2014-10-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../iftlist$EXT;

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n0.1.0\n"

printf "Nonexisting argument file should give an error\n"
$PROGRAM -d nonexistingfile.ift
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.1.0\n"

printf "Binary file as argument file should not crash program\n"
$PROGRAM -d $PROGRAM
printf "passed.\n\n"

printf "\n1.0.0\n"

printf "Nonexisting key should not fail\n"
$PROGRAM -d test4.ift nothiskey
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.1\n"

printf "Existing key should pass\n"
$PROGRAM -d test4.ift unit
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.0.1\n"

printf "Existing keys should pass\n"
$PROGRAM -d test4.ift patient_name
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.1.0\n"

printf "Option -all should pass\n"
$PROGRAM -d -all test1a.ift
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n1.2.0\n"

printf "Option -value should pass\n"
$PROGRAM -d -value test4.ift patient_name
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
