#!/bin/bash
#: Title      : test_imgdelay
#: Date       : 2023-03-22
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgdelay$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f blood.fit ] || [ ! -f blood.bld ]; then
rm -f dyn.nii
printf "FIT1        fit_sinf 0.6.19 (c) 2018 by Turku PET Centre\n" > blood.fit
printf "Date:	2018-02-12 09:00:05\n" >> blood.fit
printf "Data file:	lvcav.tac\n" >> blood.fit
printf "Data unit:	g/mL\n" >> blood.fit
printf "Time unit:	sec\n" >> blood.fit
printf "Nr of VOIs:	1\n" >> blood.fit
printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> blood.fit
printf "LV cav	0	290	1336	0	8	0331	7.856	11.54	5.697	1.384E-003	38	0.081	4.24	10\n" >> blood.fit

fit2dat -c=0,360,1 blood.fit blood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tac2svg blood.svg -l blood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f frames.sif ]; then
rm -f dyn.nii
printf "22/10/2021 17:59:46  25 2 1 SIM1 O-15\n" > frames.sif
printf "0 5\n" >> frames.sif
printf "5 10\n" >> frames.sif
printf "10 15\n" >> frames.sif
printf "15 20\n" >> frames.sif
printf "20 25\n" >> frames.sif
printf "25 30\n" >> frames.sif
printf "30 35\n" >> frames.sif
printf "35 40\n" >> frames.sif
printf "40 45\n" >> frames.sif
printf "45 50\n" >> frames.sif
printf "50 55\n" >> frames.sif
printf "55 60\n" >> frames.sif
printf "60 65\n" >> frames.sif
printf "65 70\n" >> frames.sif
printf "70 80\n" >> frames.sif
printf "80 90\n" >> frames.sif
printf "90 100\n" >> frames.sif
printf "100 120\n" >> frames.sif
printf "120 140\n" >> frames.sif
printf "140 160\n" >> frames.sif
printf "160 190\n" >> frames.sif
printf "190 220\n" >> frames.sif
printf "220 250\n" >> frames.sif
printf "250 280\n" >> frames.sif
printf "280 310\n" >> frames.sif
fi

if [ ! -f sim.par ] || [ ! -f tissue.tac ] || [ ! -f dyn.nii ] || [ ! -f mask.nii ] || [ ! -f blood.tac ]; then
printf "# model := SER3TCM\n" > sim.par
printf "Parameters	K1[mL/(mL*min)]	K1/k2[mL/mL]	k3[1/min]	k3/k4	k5[1/min]	k5/k6	Vb[%%]	dT[sec]\n" >> sim.par
printf "tac1	0.30	0.8	0	0	0	0	5	0\n" >> sim.par
printf "tac2	0.20	0.8	0	0	0	0	5	2\n" >> sim.par
printf "tac3	0.10	0.8	0	0	0	0	5	4\n" >> sim.par
printf "tac4	0.05	0.8	0	0	0	0	5	8\n" >> sim.par
printf "tac5	0.30	0.8	0	0	0	0	5	10\n" >> sim.par
printf "tac6	0.20	0.8	0	0	0	0	5	15\n" >> sim.par
printf "tac7	0.10	0.8	0	0	0	0	5	20\n" >> sim.par
printf "tac8	0.05	0.8	0	0	0	0	5	30\n" >> sim.par
printf "tac9	0.30	0.8	0	0	0	0	5	-1\n" >> sim.par
printf "tac10	0.20	0.8	0	0	0	0	5	-2\n" >> sim.par
printf "tac11	0.10	0.8	0	0	0	0	5	-3\n" >> sim.par
printf "tac12	0.05	0.8	0	0	0	0	5	-4\n" >> sim.par

sim_3tcm sim.par blood.bld blood.bld tissue.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
simframe tissue.dat frames.sif tissue.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tac2svg tissue.svg -s tissue.tac -l tissue.dat blood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

tac2nii tissue.tac 2 2 3 dyn.nii mask.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

simframe blood.bld frames.sif blood.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f blood_dc.bld ]; then
fitdelay -model=1 -o=blood_dc.bld blood.bld tissue.tac 300 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f truedelay.nii ]; then
printf "start[unknown]	end[seconds]	M1	M2	M3	M4	M5	M6	M7	M8	M9	M10	M11	M12\n" > temp.tac
printf "0	0	0	2	4	8	10	15	20	30	-1	-2	-3	-4\n" >> temp.tac

tac2nii temp.tac 2 2 3 truedelay.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f truevb.nii ] || [ ! -f truek1.nii ]; then
printf "start[unknown]	end[seconds]	M1	M2	M3	M4	M5	M6	M7	M8	M9	M10	M11	M12\n" > vb.tac
printf "0	0	0.05	0.05	0.05	0.05	0.05	0.05	0.05	0.05	0.05	0.05	0.05	0.05\n" >> vb.tac
printf "start[unknown]	end[seconds]	M1	M2	M3	M4	M5	M6	M7	M8	M9	M10	M11	M12\n" > k1.tac
printf "0	0	0.3	0.2	0.1	0.05	0.3	0.2	0.1	0.05	0.3	0.2	0.1	0.05\n" >> k1.tac
tac2nii vb.tac 2 2 3 truevb.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tac2nii k1.tac 2 2 3 temp.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
# convert K1 per tissue volume to K1 per PET volume like what imgdelay computes
imgcalc temp.nii x 0.95 truek1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: BTAC with frequent sampling. \n"
printf " Expected result: Close to correct delay map. \n\n"

rm -f output.tac
$PROGRAM --verbose dyn.nii blood.bld output.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.nii mask.nii output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output.tac

imgmatch -abs=0.05 truedelay.nii output.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: BTAC with image frames. \n"
printf " Expected result: Close to correct delay map. \n\n"

rm -f output.tac
$PROGRAM dyn.nii blood.tac output.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.nii mask.nii output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output.tac

imgmatch -abs=0.05 truedelay.nii output.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Set reasonable delay range. \n"
printf " Expected result 1: Close to correct delay map. \n\n"

rm -f output.nii output.txt
$PROGRAM --verbose -min=-5 -max=30 dyn.nii blood.tac output.nii > output.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.05 truedelay.nii output.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.txt delay_range "-5 - 30 s"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.2.0 \n"
printf " Test case 1: Save optional Vb and K1 maps. \n"
printf " Expected result 2: Close to correct Vb and K1 maps. \n\n"

rm -f output.nii vb.nii k1.nii

$PROGRAM -vb=vb.nii -k1=k1.nii -min=-6 -max=32 dyn.nii blood.bld output.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft vb.nii mask.nii outputvb.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
img2dft k1.nii mask.nii outputk1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

taclist outputvb.tac
imgmatch -abs=0.0005 truevb.nii vb.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist outputk1.tac
imgmatch -abs=0.0005 truek1.nii k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
