#!/bin/bash
#: Title      : test_bpr2cpr
#: Date       : 2014-10-19
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../bpr2cpr$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n\n Making data for testing \n\n"

if [ ! -f blood.dat ] || [ ! -f blood.bld ]; then
  printf "1 4.8\n2 48\n3 24\n10 12\n" > blood.dat
  tacformat -f=PMOD -hdr=no -mid blood.dat blood.bld 
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacunit -xset=min -yset=kBq/mL blood.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f plasma.dat ] || [ ! -f plasma.bld ]; then
  printf "1 4.0\n2 40\n3 20\n10 10\n" > plasma.dat
  tacformat -f=PMOD -hdr=no -mid plasma.dat plasma.bld 
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacunit -xset=min -yset=kBq/mL plasma.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f rbc.dat ] || [ ! -f rbc.bld ]; then
  printf "1 6\n2 60\n3 30\n10 15\n" > rbc.dat
  tacformat -f=PMOD -hdr=no -mid rbc.dat rbc.bld 
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacunit -xset=min -yset=kBq/mL rbc.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_cpr.dat ] || [ ! -f correct_cpr.bld ]; then
  taccalc -f rbc.dat : plasma.dat correct_cpr.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  taccalc rbc.bld : plasma.bld correct_cpr.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case 1: Simple data format. \n"
printf " Test case 2: HCT given as fraction. \n"
printf " Expected result: Correct RBC/plasma curve calculated. \n\n"

rm -f output.rat bp.rat
taccalc -f blood.dat : plasma.dat bp.rat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM bp.rat 0.40 output.rat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 correct_cpr.dat output.rat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: PMOD BLD data format. \n"
printf " Test case 2: HCT given as percentage. \n"
printf " Expected result: Correct RBC/plasma curve calculated. \n\n"

rm -f output.bld bpr.bld
taccalc -f blood.bld : plasma.bld bpr.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM bpr.bld 40 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -yunit=y -abs=0.00001 correct_cpr.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Option -pbr. \n"
printf " Expected result: Correct RBC/plasma curve calculated. \n\n"

rm -f output.bld pbr.bld
taccalc -f plasma.bld : blood.bld pbr.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -pbr pbr.bld 0,40 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -xunit=y -yunit=y -abs=0.00001 correct_cpr.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
