#!/bin/bash
#: Title      : test_fit_av
#: Date       : 2019-02-25
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_av$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"
if [ ! -f arterial3.kbq ] || [ ! -f venous3.kbq ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi

printf "\n creating data for testing \n"


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Test with real arterial and venous curves. \n"
printf " Test case 2: one compartment. \n"
printf " Note: fit can be bad, because model may not be optimal. \n"
printf " Expected result: No error. \n\n"

rm -f av1.svg av1.par
$PROGRAM -d3 -wf -svg=av1.svg arterial3.kbq venous3.kbq av1.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f av1.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.0 \n"
printf " Test case 1: Test with real arterial and venous curves. \n"
printf " Test case 2: two compartments. \n"
printf " Note: fit can be bad, because model may not be optimal. \n"
printf " Expected result: No error. \n\n"

rm -f av2.svg av2.par
$PROGRAM -d3 -wf -ser2 -svg=av2.svg arterial3.kbq venous3.kbq av2.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f av2.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

