#!/bin/bash
#: Title      : test_liverpv
#: Date       : 2018-05-11
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../liverpv$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f radiowater_lvcav.fit ] || [ ! -f radiowater.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f wd_radiowater_ab.bld ] || [ ! -f wd_radiowater_pv.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



if [ ! -f step.bld ]; then
  printf "time[sec]\tCa\n" > step.bld
  printf "0\t0\n"    >> step.bld
  printf "1\t0\n"    >> step.bld
  printf "1\t1\n"    >> step.bld
  printf "2\t1\n"    >> step.bld
  printf "3\t1\n"    >> step.bld
  printf "4\t1\n"    >> step.bld
  printf "5\t1\n"    >> step.bld
  printf "6\t1\n"    >> step.bld
  printf "7\t1\n"    >> step.bld
  printf "8\t1\n"    >> step.bld
  printf "10\t1\n"   >> step.bld
  printf "12\t1\n"   >> step.bld
  printf "14\t1\n"   >> step.bld
  printf "16\t1\n"   >> step.bld
  printf "18\t1\n"   >> step.bld
  printf "20\t1\n"   >> step.bld
  printf "25\t1\n"   >> step.bld
  printf "30\t1\n"   >> step.bld
  printf "35\t1\n"   >> step.bld
  printf "40\t1\n"   >> step.bld
  printf "50\t1\n"   >> step.bld
  printf "60\t1\n"   >> step.bld
  printf "70\t1\n"   >> step.bld
  printf "80\t1\n"   >> step.bld
  printf "90\t1\n"   >> step.bld
  printf "100\t1\n"  >> step.bld
  printf "120\t1\n"  >> step.bld
  printf "140\t1\n"  >> step.bld
  printf "160\t1\n"  >> step.bld
  printf "180\t1\n"  >> step.bld
  printf "200\t1\n"  >> step.bld
  printf "250\t1\n"  >> step.bld
  printf "300\t1\n"  >> step.bld
  printf "1000\t1\n" >> step.bld
fi

if [ ! -f box.bld ]; then
  printf "time[sec]\tCa\n" > box.bld
  printf "0\t0\n"    >> box.bld
  printf "1\t0\n"    >> box.bld
  printf "1\t1\n"    >> box.bld
  printf "1.1\t1\n"  >> box.bld
  printf "1.2\t1\n"  >> box.bld
  printf "1.3\t1\n"  >> box.bld
  printf "1.4\t1\n"  >> box.bld
  printf "1.5\t1\n"  >> box.bld
  printf "1.6\t1\n"  >> box.bld
  printf "1.7\t1\n"  >> box.bld
  printf "1.8\t1\n"  >> box.bld
  printf "1.9\t1\n"  >> box.bld
  printf "2\t1\n"    >> box.bld
  printf "2\t0\n"    >> box.bld
  printf "2.1\t0\n"  >> box.bld
  printf "2.2\t0\n"  >> box.bld
  printf "2.3\t0\n"  >> box.bld
  printf "2.4\t0\n"  >> box.bld
  printf "2.5\t0\n"  >> box.bld
  printf "2.6\t0\n"  >> box.bld
  printf "2.7\t0\n"  >> box.bld
  printf "2.8\t0\n"  >> box.bld
  printf "2.9\t0\n"  >> box.bld
  printf "3\t0\n"    >> box.bld
  printf "3.5\t0\n"  >> box.bld
  printf "4\t0\n"    >> box.bld
  printf "4.5\t0\n"  >> box.bld
  printf "5\t0\n"    >> box.bld
  printf "6\t0\n"    >> box.bld
  printf "7\t0\n"    >> box.bld
  printf "8\t0\n"    >> box.bld
  printf "10\t0\n"   >> box.bld
  printf "12\t0\n"   >> box.bld
  printf "14\t0\n"   >> box.bld
  printf "16\t0\n"   >> box.bld
  printf "18\t0\n"   >> box.bld
  printf "20\t0\n"   >> box.bld
  printf "25\t0\n"   >> box.bld
  printf "30\t0\n"   >> box.bld
  printf "35\t0\n"   >> box.bld
  printf "40\t0\n"   >> box.bld
  printf "50\t0\n"   >> box.bld
  printf "60\t0\n"   >> box.bld
  printf "70\t0\n"   >> box.bld
  printf "80\t0\n"   >> box.bld
  printf "90\t0\n"   >> box.bld
  printf "100\t0\n"  >> box.bld
  printf "120\t0\n"  >> box.bld
  printf "140\t0\n"  >> box.bld
  printf "160\t0\n"  >> box.bld
  printf "180\t0\n"  >> box.bld
  printf "200\t0\n"  >> box.bld
  printf "250\t0\n"  >> box.bld
  printf "300\t0\n"  >> box.bld
  printf "1000\t0\n" >> box.bld
fi

if [ ! -f fdg_ap.bld ] || [ ! -f correct_fdg_pv.bld ]; then
# Based on figure in publication by Winterdahl et al., 2011
  printf "time[sec]\tCa\n"   > fdg_ap.bld
  printf "5\t0\n"     >> fdg_ap.bld
  printf "10\t0\n"    >> fdg_ap.bld
  printf "15\t2\n"    >> fdg_ap.bld
  printf "20\t52\n"   >> fdg_ap.bld
  printf "25\t100\n"  >> fdg_ap.bld
  printf "31\t137\n"  >> fdg_ap.bld
  printf "36\t300\n"  >> fdg_ap.bld
  printf "41\t282\n"  >> fdg_ap.bld
  printf "46\t114\n"  >> fdg_ap.bld
  printf "51\t55\n"   >> fdg_ap.bld
  printf "56\t50\n"   >> fdg_ap.bld
  printf "61\t52\n"   >> fdg_ap.bld
  printf "65\t52\n"   >> fdg_ap.bld
  printf "71\t52\n"   >> fdg_ap.bld
  printf "76\t52\n"   >> fdg_ap.bld
  printf "81\t52\n"   >> fdg_ap.bld
  printf "86\t51\n"   >> fdg_ap.bld
  printf "91\t50\n"   >> fdg_ap.bld
  printf "101\t48\n"  >> fdg_ap.bld
  printf "111\t46\n"  >> fdg_ap.bld
  printf "121\t43\n"  >> fdg_ap.bld
  printf "151\t38\n"  >> fdg_ap.bld
  printf "# studynr := test1\n"  >> fdg_ap.bld

  printf "time[sec]\tCpv\n"   > correct_fdg_pv.bld
  printf "5\t0\n"     >> correct_fdg_pv.bld
  printf "10\t0\n"    >> correct_fdg_pv.bld
  printf "15\t0\n"    >> correct_fdg_pv.bld
  printf "20\t3\n"    >> correct_fdg_pv.bld
  printf "25\t10\n"   >> correct_fdg_pv.bld
  printf "31\t25\n"   >> correct_fdg_pv.bld
  printf "36\t45\n"   >> correct_fdg_pv.bld
  printf "41\t80\n"   >> correct_fdg_pv.bld
  printf "46\t92\n"   >> correct_fdg_pv.bld
  printf "51\t80\n"   >> correct_fdg_pv.bld
  printf "56\t75\n"   >> correct_fdg_pv.bld
  printf "61\t72\n"   >> correct_fdg_pv.bld
  printf "65\t64\n"   >> correct_fdg_pv.bld
  printf "71\t59\n"   >> correct_fdg_pv.bld
  printf "76\t55\n"   >> correct_fdg_pv.bld
  printf "81\t53\n"   >> correct_fdg_pv.bld
  printf "86\t51\n"   >> correct_fdg_pv.bld
  printf "91\t50\n"   >> correct_fdg_pv.bld
  printf "101\t48\n"  >> correct_fdg_pv.bld
  printf "111\t46\n"  >> correct_fdg_pv.bld
  printf "121\t43\n"  >> correct_fdg_pv.bld
  printf "151\t38\n"  >> correct_fdg_pv.bld
  printf "# studynr := test1\n"  >> correct_fdg_pv.bld
fi

if [ ! -f radiowater_pump.bld ] || [ ! -f radiowater_ab.bld ]; then
  fit2dat -c=0,420,1 radiowater_lvcav.fit radiowater_pump.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  simframe --silent radiowater_pump.bld radiowater.sif radiowater_ab.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Step function as input. \n"
printf " Expected result: PV and input converge to the same level. \n\n"

rm -f output.bld output100.svg
taccut step.bld 999 1001 test.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM step.bld 0.02 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -x2=20 -legend=n -mt="Step function start" output100b.svg -l step.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=n -mt="Step function" output100a.svg -l step.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccut output.bld 999 1001
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.2 test.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Box function as input. \n"
printf " Expected result: PV and input AUC are the same. \n\n"

rm -f output.bld output110.svg
taccut box.bld 999 1001 test.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
interpol -i -x=1000 box.bld testi.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM -i=0.01 box.bld 0.10 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -x2=20 -legend=n -mt="Box function start" output110.svg -l box.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=1000 output.bld temp.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tacmatch -rel=2 testi.bld temp.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccut output.bld 999 1001
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.00001 test.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.0.0 \n"
printf " Test case: Beta for FDG. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

rm -f output.bld output200.svg

#$PROGRAM -i=0.1 fdg_ap.bld 0.5 output.bld
$PROGRAM fdg_ap.bld 0.5 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="" output200.svg fdg_ap.bld -s correct_fdg_pv.bld -l output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=13 -rel=1 correct_fdg_pv.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: Same but times in minutes. \n"
printf " Expected result: Correct TAC is calculated. \n\n"

cp -f fdg_ap.bld fdg_ap_min.bld
cp -f correct_fdg_pv.bld correct_fdg_pv_min.bld
tacunit -xconv=min fdg_ap_min.bld correct_fdg_pv_min.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output.bld output201.svg

$PROGRAM -i=0.1 fdg_ap_min.bld 0.5 output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="" output201.svg fdg_ap_min.bld -s correct_fdg_pv_min.bld -l output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=13 -rel=1 correct_fdg_pv_min.bld output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case 1: Beta for radiowater. \n"
printf " Test case 2: Image-derived input with frame durations. \n"
printf " Expected result: Reasonable TAC is calculated. \n\n"

rm -f output1.bld output210.svg

$PROGRAM -i=0.1 radiowater_ab.bld 2.17 output1.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="Radiowater" output210.svg radiowater_ab.bld output1.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case 1: Beta for radiowater. \n"
printf " Test case 2: ABSS. \n"
printf " Expected result: Reasonable TAC is calculated. \n\n"

rm -f output2.bld output211.svg

$PROGRAM -i=0.01 radiowater_pump.bld 2.17 output2.bld
#$PROGRAM -d2 radiowater_pump.bld 2.17 output2.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="Radiowater" output211.svg -l radiowater_pump.bld output2.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

interpol -f=output1.bld output2.bld temp.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.2 -rel=0.1 -xunit=n -x=n output1.bld temp.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.2 \n"
printf " Test case: Radiowater data from Winterdahl et al 2011. \n"
printf " Expected result: Reasonably good PV TAC is calculated. \n\n"

rm -f wd_output.bld wd_output.svg
tactime wd_radiowater_pv.bld -0.12 temp.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

$PROGRAM -d3 wd_radiowater_ab.bld 2.17 wd_output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y -mt="Radiowater" wd_output.svg -l wd_radiowater_ab.bld -s temp.bld -l wd_output.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -f=temp.bld wd_output.bld temp2.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=8 -rel=1 temp.bld temp2.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
