/** @file tpcabss.h
 *  @brief Header file for libtpcabss.
 *  @details Defines for ABSS library.
 *  @author Vesa Oikonen
 *  @copyright (c) Turku PET Centre
 */
#ifndef _TPCABSS_H_
#define _TPCABSS_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcisotope.h"
#include "tpcift.h"
#include "tpccsv.h"
#include "tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
/** Individual ID number for automatic blood sampling system (ABSS), 
    so that appropriate calibration, dead-time and dispersion correction 
    coefficients can be applied. */
typedef enum {
  ABSS_UNKNOWN, ABSS_SCANDITRONICS, ABSS_GEMS, 
  ABSS_ALLOGG_OLD, ABSS_ALLOGG
} ABSS_DEVICE;
/*****************************************************************************/

/*****************************************************************************/
/* abssio */
ABSS_DEVICE abssIdFromFName(const char *fname);
int abssWrite(TAC *d, FILE *fp, TPCSTATUS *status);
/*****************************************************************************/

/*****************************************************************************/
/* abss */
int abssAboveZero(TAC *abss, int *n1, int *n2, int *n);
int abssHigherCounts(TAC *abss, int *n1, int *n2);
int abssCalculateRatio(TAC *abss, double *ratio, int *n);
int abssFixChannel(TAC *abss, int channel, double ratio);
int abssCalculateCps(TAC *abss);
int abssChannelMean(TAC *abss, double *mean);
/*****************************************************************************/
#endif /* TPCABSS */
