/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpctac.h"
#include "tpctacmod.h"
#include "tpcli.h"
#include "test_tpcbfm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_bf_1tcm(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;

  ret=bfm1TCM(NULL, NULL, 0, 0, 0, 0, NULL, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==TPCERROR_OK) return(1);

  {
  if(verbose>1) {
    printf("\n testing with perfect bolus (non-realistic for any recirculating tracer)\n");
    printf("\n correctness not tested here but later in programs that use this\n");
  }
  PAR par; parInit(&par); parExamplePerfectBolus(&par, NULL);
  TAC inp; tacInit(&inp);
  ret=tacAllocateWithPAR(&inp, &par, 6001, status);
  if(ret!=TPCERROR_OK) {parFree(&par); tacFree(&inp); return(100);}

  int i;
  double fdur=1.0;

  /* set sample times */
  for(i=0; i<inp.sampleNr; i++) {
    inp.x1[i]=(double)i*fdur;
    inp.x2[i]=inp.x1[i]+fdur; inp.x[i]=0.5*(inp.x1[i]+inp.x2[i]);
  }
  /* compute input values */
  ret=mfEvalFrameY(modelCode(par.r[0].model), modelParNr(par.r[0].model),
                   par.r[0].p, inp.sampleNr, inp.x1, inp.x2, inp.c[0].y, verbose-20);
  if(ret) {tacFree(&inp); parFree(&par); return(101);}
  parFree(&par);

  TAC bf; tacInit(&bf);
  TAC tis; tacInit(&tis); 

  /* Try BF set calculation with frame mid times and with equal input and tissue sample times */
  if(tacDuplicate(&inp, &tis)) {tacFree(&inp); return(102);}

  if(verbose>1) printf("\n compute basis functions and save as SVG plot\n");

  ret=bfm1TCM(&inp, &tis, 10, 0.0001667, 0.01667, 0, &bf, status);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "ret := %s\n", errorMsg(status->error));
    tacFree(&inp); tacFree(&tis); tacFree(&bf); return(103);
  }
  if(bf.sampleNr!=tis.sampleNr || bf.tacNr!=10) {
    tacFree(&inp); tacFree(&tis); tacFree(&bf); return(104);
  }
  ret=tacPlotLineSVG(&bf, "Basis functions for radiowater", nan(""), nan(""), nan(""), nan(""),
                     "bf_radiowater1.svg", NULL);
  statusSet(status, __func__, __FILE__, __LINE__, ret);
  if(ret!=TPCERROR_OK) {tacFree(&inp); tacFree(&tis); tacFree(&bf); return(100);}

  tacFree(&inp); tacFree(&tis); tacFree(&bf);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
