/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcdcm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_dcmSOPIdentify(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i;
  char buf[64];

  if(verbose>1) printf("\ntry with NULL input...\n");
  i=dcmSOPIdentify(NULL);
  if(verbose>2) printf("  index := %u\n", i);
  if(i!=0) return(1);

  strcpy(buf, "");
  i=dcmSOPIdentify(buf);
  if(verbose>2) printf("  index := %u\n", i);
  if(i!=0) return(2);

  if(verbose>1) printf("\ntry with stupid UID representation...\n");
  strcpy(buf, "9.9.9.9.9.9.9.9");
  i=dcmSOPIdentify(buf);
  if(verbose>2) printf("  index := %u\n", i);
  if(strcasecmp(dcmSOPName(i), "unknown SOP")!=0) return(3);

  if(verbose>1) printf("\ntry to identify '1.2.840.10008.5.1.4.1.1.128'...\n");
  strcpy(buf, "1.2.840.10008.5.1.4.1.1.128");
  i=dcmSOPIdentify(buf);
  if(verbose>2) printf("  index := %u\n", i);
  if(strcasecmp(dcmSOPName(i), "Positron Emission Tomography Image Storage")!=0) return(4);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmSOPName(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i;
  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  i=0;
  cptr=dcmSOPName(i);
  if(strcasecmp(cptr, "invalid SOP")!=0) return(1);
  if(verbose>2) printf("  SOP Name := %s\n", cptr);

  if(verbose>1) printf("\ntry with too high index...\n");
  i=99999;
  cptr=dcmSOPName(i);
  if(strcasecmp(cptr, "unknown SOP")!=0) return(2);
  if(verbose>2) printf("  SOP Name := %s\n", cptr);

  if(verbose>1) printf("\ntry with valid index...\n");
  i=dcmSOPIdentify("1.2.840.10008.5.1.4.1.1.128");
  cptr=dcmSOPName(i);
  if(verbose>2) printf("  SOP Name := %s\n", cptr);
  if(strcasecmp(cptr, "Positron Emission Tomography Image Storage")!=0) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmSOPUID(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i;
  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  i=0;
  cptr=dcmSOPUID(i);
  if(strcasecmp(cptr, "invalid")!=0) return(1);
  if(verbose>2) printf("  SOP UID := %s\n", cptr);

  if(verbose>1) printf("\ntry with too high index...\n");
  i=99999;
  cptr=dcmSOPUID(i);
  if(strcasecmp(cptr, "unknown")!=0) return(2);
  if(verbose>2) printf("  SOP UID := %s\n", cptr);

  if(verbose>1) printf("\ntry with valid index...\n");
  i=dcmSOPIdentify("1.2.840.10008.5.1.4.1.1.128");
  cptr=dcmSOPUID(i);
  if(verbose>2) printf("  SOP UID := %s\n", cptr);
  if(strcasecmp(cptr, "1.2.840.10008.5.1.4.1.1.128")!=0) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmSOPUIDName(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char buf[64];
  char *cptr;

  if(verbose>1) printf("\ntry with NULL input...\n");
  cptr=dcmSOPUIDName(NULL);
  if(verbose>2) printf("  SOP UID Name := %s\n", cptr);
  if(strcasecmp(cptr, "invalid SOP")!=0) return(1);

  strcpy(buf, "");
  cptr=dcmSOPUIDName(buf);
  if(verbose>2) printf("  SOP UID Name := %s\n", cptr);
  if(strcasecmp(cptr, "invalid SOP")!=0) return(2);

  if(verbose>1) printf("\ntry with stupid UID representation...\n");
  strcpy(buf, "9.9.9.9.9.9.9.9");
  cptr=dcmSOPUIDName(buf);
  if(verbose>2) printf("  SOP UID Name := %s\n", cptr);
  if(strcasecmp(cptr, "unknown SOP")!=0) return(3);

  if(verbose>1) printf("\ntry to identify '1.2.840.10008.5.1.4.1.1.128'...\n");
  strcpy(buf, "1.2.840.10008.5.1.4.1.1.128");
  cptr=dcmSOPUIDName(buf);
  if(verbose>2) printf("  SOP UID Name := %s\n", cptr);
  if(strcasecmp(cptr, "Positron Emission Tomography Image Storage")!=0) return(4);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
