/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcdcm.h"
/*****************************************************************************/

/*****************************************************************************/
int test_dcmVRName(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  dcmvr vr;
  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  cptr=dcmVRName(0);
  if(verbose>2) printf("  VR := %s\n", cptr);
  if(strcmp(cptr, "AE")!=0) return(1);

  if(verbose>1) printf("\ntry with too large VR id...\n");
  cptr=dcmVRName(9999);
  if(verbose>2) printf("  VR := %s\n", cptr);
  if(strcmp(cptr, "INVALID")!=0) return(2);

  if(verbose>1) printf("\ntry with valid VR id...\n");
  vr=DCM_VR_CS;
  cptr=dcmVRName(vr);
  if(verbose>2) printf("  VR := %s\n", cptr);
  if(strcmp(cptr, "CS")!=0) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmVRId(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  dcmvr vr;
  char buf[128], buf2[2];

  if(verbose>1) printf("\ntry with NULL input...\n");
  vr=dcmVRId(NULL);
  if(verbose>2) printf("  VR := %s\n", dcmVRName(vr));
  if(vr!=DCM_VR_INVALID) return(1);

  strcpy(buf, "");
  vr=dcmVRId(buf);
  if(verbose>2) printf("  VR := %s\n", dcmVRName(vr));
  if(vr!=DCM_VR_INVALID) return(2);

  if(verbose>1) printf("\ntry with stupid VR representation...\n");
  strcpy(buf, "__");
  vr=dcmVRId(buf);
  if(verbose>2) printf("  VR := %s\n", dcmVRName(vr));
  if(vr!=DCM_VR_INVALID) return(3);

  if(verbose>1) printf("\ntry to identify 'SQ'...\n");
  strcpy(buf, "SQ");
  vr=dcmVRId(buf);
  if(verbose>2) printf("  VR := %s\n", dcmVRName(vr));
  if(vr!=DCM_VR_SQ) return(4);

  if(verbose>1) printf("\nIt should not matter if string is longer...\n");
  strcpy(buf, "SQSSS");
  vr=dcmVRId(buf);
  if(verbose>2) printf("  VR := %s\n", dcmVRName(vr));
  if(vr!=DCM_VR_SQ) return(5);

  if(verbose>1) printf("\nlower case characters should not work...\n");
  strcpy(buf, "ui");
  vr=dcmVRId(buf);
  if(verbose>2) printf("  VR := %s\n", dcmVRName(vr));
  if(vr!=DCM_VR_INVALID) return(6);

  if(verbose>1) printf("\nIt should not matter if string is not null terminated...\n");
  buf2[0]='U'; buf2[1]='I';
  vr=dcmVRId(buf2);
  if(verbose>2) printf("  VR := %s\n", dcmVRName(vr));
  if(vr!=DCM_VR_UI) return(7);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmVRDescr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  dcmvr vr;
  char *cptr;

  if(verbose>1) printf("\ntry with 0 input...\n");
  cptr=dcmVRDescr(0);
  if(cptr==NULL) return(1);
  if(verbose>2) printf("  VR Description := %s\n", cptr);

  if(verbose>1) printf("\ntry with too high index...\n");
  cptr=dcmVRDescr(9999);
  if(cptr==NULL) return(2);
  if(verbose>2) printf("  VR Description := %s\n", cptr);

  if(verbose>1) printf("\ntry with valid VR id...\n");
  vr=DCM_VR_CS;
  cptr=dcmVRDescr(vr);
  if(verbose>2) printf("  VR Description := %s\n", cptr);
  if(strnlen(cptr, 10)<5) return(3);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmVRReserved(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  dcmvr vr;
  int ret;

  if(verbose>1) printf("\ntry with 0 input...\n");
  ret=dcmVRReserved(0);
  if(verbose>2) printf("  Reserved extra bytes := %d\n", ret);
  if(ret!=0) return(1);

  if(verbose>1) printf("\ntry with too high index...\n");
  ret=dcmVRReserved(9999);
  if(verbose>2) printf("  Reserved extra bytes := %d\n", ret);
  if(ret!=2) return(2);

  if(verbose>1) printf("\ntry with valid VR with extra reserved space...\n");
  vr=DCM_VR_OF;
  ret=dcmVRReserved(vr);
  if(verbose>2) printf("  Reserved extra bytes := %d\n", ret);
  if(ret!=2) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmVRVLength(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  dcmvr vr;
  int ret;

  vr=DCM_VR_INVALID;
  if(verbose>1) printf("\ntry with %s ...\n", dcmVRName(vr));
  ret=dcmVRVLength(vr);
  if(verbose>2) printf("  Max value length := %d\n", ret);
  if(ret!=0) return(1);

  if(verbose>1) printf("\ntry with too high index...\n");
  vr=9999;
  ret=dcmVRVLength(vr);
  if(verbose>2) printf("  Max value length := %d\n", ret);
  if(ret!=0) return(2);

  vr=DCM_VR_OF;
  if(verbose>1) printf("\ntry with %s ...\n", dcmVRName(vr));
  ret=dcmVRVLength(vr);
  if(verbose>2) printf("  Max value length := %d\n", ret);
  if(ret!=0) return(3);

  vr=DCM_VR_US;
  if(verbose>1) printf("\ntry with %s ...\n", dcmVRName(vr));
  ret=dcmVRVLength(vr);
  if(verbose>2) printf("  Max value length := %d\n", ret);
  if(ret!=2) return(4);

  vr=DCM_VR_SL;
  if(verbose>1) printf("\ntry with %s ...\n", dcmVRName(vr));
  ret=dcmVRVLength(vr);
  if(verbose>2) printf("  Max value length := %d\n", ret);
  if(ret!=4) return(5);

  vr=DCM_VR_UI;
  if(verbose>1) printf("\ntry with %s ...\n", dcmVRName(vr));
  ret=dcmVRVLength(vr);
  if(verbose>2) printf("  Max value length := %d\n", ret);
  if(ret!=64) return(6);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmDA2intl(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\nTry with NULL input...\n");
  if(dcmDA2intl(NULL, NULL)!=NULL) return(1); 
  if(verbose>1) printf("... good, did not crash\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  char s1[32], s2[32], *cptr;

  strcpy(s1, "20170508");
  cptr=dcmDA2intl(s1, s2);
  if(verbose>1) printf("'%s' -> '%s'\n", s1, s2);
  if(cptr==NULL || strcmp(cptr, "2017-05-08")) return(11);

  strcpy(s1, "2017.05.08");
  cptr=dcmDA2intl(s1, s2);
  if(verbose>1) printf("'%s' -> '%s'\n", s1, s2);
  if(cptr==NULL || strcmp(cptr, "2017-05-08")) return(12);

  if(verbose>1) printf("\nTry with invalid date...\n");
  strcpy(s1, "20171332");
  cptr=dcmDA2intl(s1, s2);
  if(cptr!=NULL) return(21);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmTM2intl(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\nTry with NULL input...\n");
  if(dcmTM2intl(NULL, NULL)!=NULL) return(1); 
  if(verbose>1) printf("... good, did not crash\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  char s1[32], s2[32], *cptr;

  strcpy(s1, "120956");
  cptr=dcmTM2intl(s1, s2);
  if(verbose>1) printf("'%s' -> '%s'\n", s1, s2);
  if(cptr==NULL || strcmp(cptr, "12:09:56")) return(11);

  strcpy(s1, "12.09.56");
  cptr=dcmTM2intl(s1, s2);
  if(verbose>1) printf("'%s' -> '%s'\n", s1, s2);
  if(cptr==NULL || strcmp(cptr, "12:09:56")) return(12);

  if(verbose>1) printf("\nTry with invalid date...\n");
  strcpy(s1, "120261");
  cptr=dcmTM2intl(s1, s2);
  if(cptr!=NULL) return(21);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_dcmDT2intl(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("\nTry with NULL input...\n");
  if(dcmDT2intl(NULL, NULL)!=NULL) return(1); 
  if(verbose>1) printf("... good, did not crash\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  char s1[32], s2[32], *cptr;

  strcpy(s1, "20170508120956.000000+0300");
  cptr=dcmDT2intl(s1, s2);
  if(verbose>1) printf("'%s' -> '%s'\n", s1, s2);
  if(cptr==NULL || strcmp(cptr, "2017-05-08 12:09:56")) return(11);

  if(verbose>1) printf("\nTry with invalid date...\n");
  strcpy(s1, "20171332120956.000000+0300");
  cptr=dcmDT2intl(s1, s2);
  if(cptr!=NULL) return(21);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
