/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
int test_endianness(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;

  ret=endianness();
  if(verbose>0) {
    printf("endianness: ");
    switch(ret) {
      case ENDIAN_BIG: printf("Big\n"); break;
      case ENDIAN_LITTLE: printf("Little\n"); break;
      case ENDIAN_BIG_WORD: printf("Middle (Honeywell 316 style)\n"); break;
      case ENDIAN_LITTLE_WORD: printf("Middle (PDP-11 style)\n"); break;
      case ENDIAN_UNKNOWN:
      default: printf("Unknown\n");
    }
  }
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_endianLittle(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int ret;

  ret=endianLittle();
  if(verbose>1) printf("endianLittle() := %d\n", ret);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_swap(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  swap(NULL, NULL, 0);
  if(verbose>1) printf("Good, did not segfault.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_swabip(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  swabip(NULL, 0);
  if(verbose>1) printf("Good, did not segfault.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_swawbip(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  swawbip(NULL, 0);
  if(verbose>1) printf("Good, did not segfault.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_swawip(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  swawip(NULL, 0);
  if(verbose>1) printf("Good, did not segfault.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_swap64ip(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  swap64ip(NULL, 0);
  if(verbose>1) printf("Good, did not segfault.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_swap32ip(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  swap32ip(NULL, 0);
  if(verbose>1) printf("Good, did not segfault.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_swap16ip(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  swap16ip(NULL, 0);
  if(verbose>1) printf("Good, did not segfault.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
