/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcfileutil.h"
/*****************************************************************************/

/*****************************************************************************/
int test_fileExist(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  char fname[FILENAME_MAX];
  FILE *fp;

  if(verbose>1) printf("\nTrying with NULL input...\n");
  ret=fileExist(NULL);
  if(ret==1) return(1);

  if(verbose>1) printf("\nTrying with non-existing file...\n");
  strcpy(fname, "nonexisting.txt");
  ret=fileExist(fname);
  if(ret==1) return(2);

  if(verbose>1) printf("\nTrying with existing file...\n");
  strcpy(fname, "existing.txt");
  fp=fopen(fname, "w"); fclose(fp);
  ret=fileExist(fname);
  if(ret!=1) return(3);
  remove(fname);

  if(verbose>1) printf("\nTrying with existing path...\n");
  strcpy(fname, "../test");
  ret=fileExist(fname);
  if(ret==1) return(4);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_pathFileNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned short int n;
  char fname[FILENAME_MAX];

  if(verbose>1) printf("\nTrying with NULL input...\n");
  n=pathFileNr(NULL);
  if(n!=0) return(1);

  if(verbose>1) printf("\nTrying with non-existing path...\n");
  strcpy(fname, "nonexisting.dir");
  n=pathFileNr(fname);
  if(n!=0) return(2);

  if(verbose>1) printf("\nTrying with existing path...\n");
  strcpy(fname, "..");
  n=pathFileNr(fname);
  if(n<2) return(3);
  if(verbose>2) printf(" -> n := %u\n", n);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_pathFileList(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned short int n;
  char fname[FILENAME_MAX];
  IFT ift; iftInit(&ift);

  if(verbose>1) printf("\nTrying with NULL input...\n");
  n=pathFileList(NULL, NULL);
  if(n!=0) return(1);

  if(verbose>1) printf("\nTrying with non-existing path...\n");
  strcpy(fname, "nonexisting.dir");
  n=pathFileList(fname, &ift);
  if(n!=0) return(2);

  if(verbose>1) printf("\nTrying with existing path...\n");
  strcpy(fname, "..");
  n=pathFileList(fname, &ift);
  if(n<2 || ift.keyNr<2) {iftFree(&ift); return(3);}
  if(verbose>2) printf(" -> n := %u\n", n);
  if(verbose>5) iftWrite(&ift, stdout, NULL);
  iftFree(&ift);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
