/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcfunc.h"
/*****************************************************************************/

/*****************************************************************************/
int test_mfEvalY(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with empty input \n");
  ret=mfEvalY(NULL, 0, NULL, 0, NULL, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(1);
  ret=mfEvalY("fengm2", 6, NULL, 3, NULL, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(2);

  {
    char *fid="level";
    if(verbose>1) printf("\n testing '%s' \n", fid);
    double p[]={1.0};
    int i, n=3;
    double x[]={-1.0, 1.0, 10.0};
    double y[n];
    double cy[]={1.0, 1.0, 1.0};
    ret=mfEvalY(fid, 1, p, n, x, y, verbose-2);
    if(ret!=0) return(11);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy[i], y[i]);
      if(!doubleMatch(cy[i], y[i], 1.0E-06)) return(12);
    }
    if(verbose>2) printf("\n ok \n");
  }

  {
    char *fid="step";
    if(verbose>1) printf("\n testing '%s' \n", fid);
    double p[]={0.0, 1.0, 10.0, 0.0, 20.0, 1.0, 30.0, 0.0};
    int i, n=5;
    double x[]={0.0, 1.0, 11.0, 29.0, 31.0};
    double y[n];
    double cy[]={1.0, 1.0, 0.0, 1.0, 0.0};
    ret=mfEvalY(fid, 8, p, n, x, y, verbose-2);
    if(ret!=0) return(13);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy[i], y[i]);
      if(!doubleMatch(cy[i], y[i], 1.0E-06)) return(14);
    }
    if(verbose>2) printf("\n ok \n");
  }

  {
    char *fid="fengm2";
    if(verbose>1) printf("\n testing '%s' with zero delay \n", fid);
    double p1[]={2.218984E+002, -6.676388E-001, 6.596488E+001, -4.376002E+000,
                 3.618718E+001, -3.969950E-002, 0.000000E+000};
    double p2[]={1.589523E+001, -2.329749E-001, 4.943504E+001, -1.622289E-002,
                 2.829102E+000, -1.215255E-015, 0.000000E+000};
    double p3[]={3.995632E-007, -1.182695E-001, 0.000000E+000, -4.993063E+002,
                 7.041230E+001, 0.000000E+000, 0.000000E+000};
    int i, n=4;
    double x[]={0.0, 1.0, 8.0, 40.0};
    double y[n];
    double cy1[]={0.0, 9.7028336837E+001, 3.4355288196E+001, 7.3944144818};
    double cy2[]={0.0, 2.2658146219E+001, 5.7862509089E+001, 2.8716802814E+001};
    double cy3[]={0.0, 7.8540290156, 4.3076097614E+001, 6.9791292589E+001};

    if(verbose>2) printf("\n f1\n");
    ret=mfEvalY("FENGM2", 6, p1, n, x, y, verbose-2);
    if(ret!=0) return(101);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-06)) return(102);
    }
    if(verbose>2) printf("\n f2\n");
    ret=mfEvalY("fengm2", 6, p2, n, x, y, verbose-2);
    if(ret!=0) return(103);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy2[i], y[i]);
      if(!doubleMatch(cy2[i], y[i], 1.0E-06)) return(104);
    }
    if(verbose>2) printf("\n f3\n");
    ret=mfEvalY("fengm2", 6, p3, n, x, y, verbose-2);
    if(ret!=0) return(105);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy3[i], y[i]);
      if(!doubleMatch(cy3[i], y[i], 1.0E-06)) return(106);
    }
    if(verbose>2) printf("\n using all parameters \n");
    ret=mfEvalY("FENGM2", 7, p3, n, x, y, verbose-2);
    if(ret!=0) return(107);
    for(i=0; i<n; i++) {
      if(!doubleMatch(cy3[i], y[i], 1.0E-06)) return(108);
    }
    if(verbose>2) printf("\n ok \n");
  }

  {
    char *fid="fengm2";
    if(verbose>1) printf("\n testing '%s' with delay=5 \n", fid);
    double p1[]={2.218984E+002, -6.676388E-001, 6.596488E+001, -4.376002E+000,
                 3.618718E+001, -3.969950E-002, 5.000000E+000};
    double p2[]={1.589523E+001, -2.329749E-001, 4.943504E+001, -1.622289E-002,
                 2.829102E+000, -1.215255E-015, 5.000000E+000};
    double p3[]={3.995632E-007, -1.182695E-001, 0.000000E+000, -4.993063E+002,
                 7.041230E+001, 0.000000E+000, 5.000000E+000};
    int i, n=4;
    double x[]={5.0, 6.0, 13.0, 45.0};
    double y[n];
    double cy1[]={0.0, 9.7028336837E+001, 3.4355288196E+001, 7.3944144818};
    double cy2[]={0.0, 2.2658146219E+001, 5.7862509089E+001, 2.8716802814E+001};
    double cy3[]={0.0, 7.8540290156, 4.3076097614E+001, 6.9791292589E+001};

    if(verbose>2) printf("\n f1\n");
    ret=mfEvalY("FENGM2", 7, p1, n, x, y, verbose-2);
    if(ret!=0) return(111);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-06)) return(112);
    }
    if(verbose>2) printf("\n f2\n");
    ret=mfEvalY("FENGM2", 7, p2, n, x, y, verbose-2);
    if(ret!=0) return(113);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy2[i], y[i]);
      if(!doubleMatch(cy2[i], y[i], 1.0E-06)) return(114);
    }
    if(verbose>2) printf("\n f3\n");
    ret=mfEvalY("FENGM2", 7, p3, n, x, y, verbose-2);
    if(ret!=0) return(115);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy3[i], y[i]);
      if(!doubleMatch(cy3[i], y[i], 1.0E-06)) return(116);
    }
    if(verbose>2) printf("\n ok \n");
  }


  {
    char *fid="FENGM2E";
    if(verbose>1) printf("\n testing '%s' with zero delay \n", fid);
    double p1[]={200., -0.8, 50, -0.2, 20., -0.05, 20., -0.005, 0.};
    int i, n=8;
    double x[]={0.1, 1., 2., 3., 5., 10., 20., 60.};
    double y[n];
    double cy1[]={24.2820415017103, 129.287561780661, 134.001667915828, 110.623136302864, 70.1434173493150, 38.5626994653914, 26.3705591411179, 15.8124129916093};

    if(verbose>2) printf("\n f1\n");
    ret=mfEvalY("FENGM2E", 8, p1, n, x, y, verbose-2);
    if(ret!=0) return(121);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(122);
    }
    if(verbose>2) printf("\n ok \n");
  }


  {
    char *fid="erlangpdf";

    if(verbose>1) printf("\n testing '%s' with N=2\n", fid);
    double p1[]={1.0, 0.5, 2.0};
    int i, n=5;
    double x[]={0.1, 1., 2., 3., 5.};
    double y[n];
    double cy1[]={2.3780736E-02, 1.5163266E-01, 1.8393972E-01, 1.6734762E-01, 1.0260625E-01};
    ret=mfEvalY("erlangpdf", 3, p1, n, x, y, verbose-2);
    if(ret!=0) return(131);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(132);
    }
    if(verbose>2) printf("\n ok \n");

    if(verbose>1) printf("\n testing '%s' with N=4\n", fid);
    double p2[]={1.0, 0.9, 4.0};
    double cy2[]={9.9938375E-05, 4.4458392E-02, 1.4460347E-01, 1.9842092E-01, 1.5184610E-01};
    ret=mfEvalY("erlangpdf", 3, p2, n, x, y, verbose-2);
    if(ret!=0) return(133);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy2[i], y[i]);
      if(!doubleMatch(cy2[i], y[i], 1.0E-05)) return(134);
    }
    if(verbose>2) printf("\n ok \n");

    if(verbose>1) printf("\n testing '%s' with N=1\n", fid);
    double p3[]={10.0, 0.5, 1.0};
    double cy3[]={4.7561471, 3.0326533, 1.8393972, 1.1156508, 4.1042499E-01};
    ret=mfEvalY("erlangpdf", 3, p3, n, x, y, verbose-2);
    if(ret!=0) return(135);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy3[i], y[i]);
      if(!doubleMatch(cy3[i], y[i], 1.0E-05)) return(136);
    }
    if(verbose>2) printf("\n ok \n");
  }

  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mfEvalInt(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with empty input \n");
  ret=mfEvalInt(NULL, 0, NULL, 0, NULL, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(1);
  ret=mfEvalInt("FENGM2", 6, NULL, 3, NULL, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(2);


  {
    char *fid="FENGM2";
    if(verbose>1) printf("\n testing '%s' with zero delay \n", fid);
    // correct results computed using SageMath
    double p1[]={2.218984E+002, -6.676388E-001, 6.596488E+001, -4.376002E+000,
                 3.618718E+001, -3.969950E-002, 0.000000E+000};
    double p2[]={1.589523E+001, -2.329749E-001, 4.943504E+001, -1.622289E-002,
                 2.829102E+000, -1.215255E-015, 0.000000E+000};
    double p3[]={0.,   -0.05, 70., -0.001, 0.,  -0.00005, 0.};
    int i, n=4;
    double x[]={0.0, 1.0, 8.0, 40.0};
    double y[n];
    double cy1[]={0.0, 4.7840305697E+001, 5.9352781709E+002, 1.0851554720E+003};
    double cy2[]={0.0, 1.2071416523E+001, 3.6688224358E+002, 1.6361877222E+003};
    double cy3[]={0.0, 1.68620596475248, 96.2140258556490, 1534.20865586864};

    if(verbose>2) printf("\n f1\n");
    ret=mfEvalInt("FENGM2", 6, p1, n, x, y, verbose-2);
    if(ret!=0) return(101);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-06)) return(102);
    }
    if(verbose>2) printf("\n f2\n");
    ret=mfEvalInt("FENGM2", 6, p2, n, x, y, verbose-2);
    if(ret!=0) return(103);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x[i], cy2[i], y[i]);
      if(!doubleMatch(cy2[i], y[i], 1.0E-06)) return(104);
    }
    if(verbose>2) printf("\n f3\n");
    ret=mfEvalInt("FENGM2", 6, p3, n, x, y, verbose-2);
    if(ret!=0) return(105);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x[i], cy3[i], y[i]);
      if(!doubleMatch(cy3[i], y[i], 1.0E-06)) return(106);
    }
    if(verbose>2) printf("\n using all parameters \n");
    ret=mfEvalInt("FENGM2", 7, p3, n, x, y, verbose-2);
    if(ret!=0) return(107);
    for(i=0; i<n; i++) {
      if(!doubleMatch(cy3[i], y[i], 1.0E-06)) return(108);
    }
    if(verbose>2) printf("\n ok \n");
  }


  {
    char *fid="FENGM2";
    if(verbose>1) printf("\n testing '%s' with delay=5 \n", fid);
    // correct results computed using SageMath
    double p1[]={2.218984E+002, -6.676388E-001, 6.596488E+001, -4.376002E+000,
                 3.618718E+001, -3.969950E-002, 5.000000E+000};
    double p2[]={1.589523E+001, -2.329749E-001, 4.943504E+001, -1.622289E-002,
                 2.829102E+000, -1.215255E-015, 5.000000E+000};
    double p3[]={0.,   -0.05, 70., -0.001, 0.,  -0.00005, 0.};
    int i, n=4;
    double x[]={5.0, 6.0, 13.0, 45.0};
    double y[n];
    double cy1[]={0.0, 4.7840305697E+001, 5.9352781709E+002, 1.0851554720E+003};
    double cy2[]={0.0, 1.2071416523E+001, 3.6688224358E+002, 1.6361877222E+003};
    double x3[]={0.0, 1.0, 8.0, 40.0};
    double cy3[]={0.0, 1.68620596475248, 96.2140258556490, 1534.20865586864};

    if(verbose>2) printf("\n f1\n");
    ret=mfEvalInt("FENGM2", 7, p1, n, x, y, verbose-2);
    if(ret!=0) return(201);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-06)) return(202);
    }
    if(verbose>2) printf("\n f2\n");
    ret=mfEvalInt("FENGM2", 7, p2, n, x, y, verbose-2);
    if(ret!=0) return(203);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x[i], cy2[i], y[i]);
      if(!doubleMatch(cy2[i], y[i], 1.0E-06)) return(204);
    }
    if(verbose>2) printf("\n f3\n");
    ret=mfEvalInt("FENGM2", 7, p3, n, x3, y, verbose-2);
    if(ret!=0) return(205);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x3[i], cy3[i], y[i]);
      if(!doubleMatch(cy3[i], y[i], 1.0E-06)) return(206);
    }
    if(verbose>2) printf("\n ok \n");
  }




  {
    char *fid="FENGM2E";
    if(verbose>1) printf("\n testing '%s' with zero delay \n", fid);
    double p1[]={200., -0.8, 50, -0.2, 20., -0.05, 20., -0.005, 0.};
    int i, n=8;
    double x[]={0.1, 1., 2., 3., 5., 10., 20., 60.};
    double y[n];
    double cy1[]={1.24366214256880, 82.5775913067400, 218.958123683776, 341.884086369279, 518.712501976583, 767.730468207601, 1078.91905648249, 1866.81075387290};

    if(verbose>2) printf("\n f1\n");
    ret=mfEvalInt("FENGM2E", 8, p1, n, x, y, verbose-2);
    if(ret!=0) return(301);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(302);
    }
    if(verbose>2) printf("\n ok \n");
  }




  {
    char *fid="erlangpdf";

    if(verbose>1) printf("\n testing '%s' with N=0\n", fid);
    double p1[]={2.0, 0.5, 0.0};
    int i, n=5;
    double x[]={0.1, 1., 2., 3., 5.};
    double y[n];
    double cy1[]={2.0, 2.0, 2.0, 2.0, 2.0};
    ret=mfEvalInt("erlangpdf", 3, p1, n, x, y, verbose-2);
    if(ret!=0) return(401);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(402);
    }
    if(verbose>2) printf("\n ok \n");

    if(verbose>1) printf("\n testing '%s' with N=1\n", fid);
    double p2[]={10.0, 0.9, 1.0};
    double cy2[]={8.6068815E-01, 5.9343034, 8.3470111, 9.3279449, 9.8889100};
    ret=mfEvalInt("erlangpdf", 3, p2, n, x, y, verbose-2);
    if(ret!=0) return(403);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy2[i], y[i]);
      if(!doubleMatch(cy2[i], y[i], 1.0E-05)) return(404);
    }
    if(verbose>2) printf("\n ok \n");

    if(verbose>1) printf("\n testing '%s' with N=2\n", fid);
    double p3[]={10.0, 0.5, 2.0};
    double cy3[]={1.2091043E-02, 9.0204010E-01, 2.6424112, 4.4217460, 7.1270250};
    ret=mfEvalInt("erlangpdf", 3, p3, n, x, y, verbose-2);
    if(ret!=0) return(405);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy3[i], y[i]);
      if(!doubleMatch(cy3[i], y[i], 1.0E-05)) return(406);
    }
    if(verbose>2) printf("\n ok \n");
  }

  {
    char *fid="erlangpdf";

    if(verbose>1) printf("\n testing '%s' with N=10\n", fid);
    double p4[]={10.0, 0.15, 10.0};
    int i, n=5;
    double x[]={15., 30., 50., 90., 150.};
    double y[n];
    double cy4[]={0.00120805, 0.17092733, 2.23592387, 8.64736005, 9.98896531};
    ret=mfEvalInt("erlangpdf", 3, p4, n, x, y, verbose-2);
    if(ret!=0) return(407);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy4[i], y[i]);
      if(!doubleMatch(cy4[i], y[i], 1.0E-05)) return(408);
    }
    if(verbose>2) printf("\n ok \n");
  }




  {
    char *fid="1exp";
    if(verbose>1) printf("\n testing '%s' \n", fid);
    double p1[]={100., -0.8};
    int i, n=3;
    double x[]={0.0, 10., 100.};
    double y[n];
    double cy1[]={0.0, 124.9580672, 125.};

    ret=mfEvalInt("1exp", 2, p1, n, x, y, verbose-2);
    if(ret!=0) return(501);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(502);
    }
    if(verbose>2) printf("\n ok \n");
  }
  {
    char *fid="4exp";
    if(verbose>1) printf("\n testing '%s' \n", fid);
    double p1[]={100., -0.8, 50, -0.2, 20., -0.05, 2., -0.001};
    int i, n=3;
    double x[]={0.0, 10., 100.};
    double y[n];
    double cy1[]={0.0, 518.412315, 962.6299846};

    ret=mfEvalInt("4exp", 8, p1, n, x, y, verbose-2);
    if(ret!=0) return(511);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(512);
    }
    if(verbose>2) printf("\n ok \n");

    p1[6]=p1[7]=0.0;
    cy1[1]=498.5119825;
    cy1[2]=772.3048207;
    ret=mfEvalInt("4exp", 8, p1, n, x, y, verbose-2);
    if(ret!=0) return(513);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(514);
    }
    if(verbose>2) printf("\n ok \n");

  }
  {
    char *fid="5exp";
    if(verbose>1) printf("\n testing '%s' \n", fid);
    double p1[]={100., -0.8, 50, -0.2, 20., -0.05, 2., -0.01, 0.1, 0.0};
    int i, n=3;
    double x[]={0.0, 10., 100.};
    double y[n];
    double cy1[]={0.0, 518.5444989, 908.7289325};

    ret=mfEvalInt("5exp", 10, p1, n, x, y, verbose-2);
    if(ret!=0) return(521);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(522);
    }
    if(verbose>2) printf("\n ok \n");
  }



  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mfEval2ndInt(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with empty input \n");
  ret=mfEval2ndInt(NULL, 0, NULL, 0, NULL, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(1);
  ret=mfEval2ndInt("FENGM2", 6, NULL, 3, NULL, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(2);


  {
    char *fid="FENGM2";
    if(verbose>1) printf("\n testing '%s' with zero delay \n", fid);
    // correct results computed using SageMath
    double p1[]={200., -0.6,  40., -0.5,   50., -0.1,     0.};
    double p2[]={20.,  -0.2,  50., -0.02,  3.,  -0.001,   0.};
    double p3[]={0.,   -0.05, 70., -0.001, 0.,  -0.00005, 0.};
    int i, n=4;
    double x[]={0.0, 1.0, 8.0, 40.0};
    double y[n];
    double cy1[]={0.0, 28.94598842, 3421.927405, 32751.94857};
    double cy2[]={0.0, 4.53455757, 1368.273908, 39267.38005};
    double cy3[]={0.0, 0.564450222076840,  265.077305253939, 23471.3527319974};

    if(verbose>2) printf("\n f1\n");
    ret=mfEval2ndInt("FENGM2", 6, p1, n, x, y, verbose-2);
    if(ret!=0) return(101);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-04)) ret++; 
    }
    if(ret) return(102);
    if(verbose>2) printf("\n f2\n");
    ret=mfEval2ndInt("FENGM2", 6, p2, n, x, y, verbose-2);
    if(ret!=0) return(103);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x[i], cy2[i], y[i]);
      if(!doubleMatch(cy2[i], y[i], 1.0E-04)) ret++;
    }
    if(ret) return(104);
    if(verbose>2) printf("\n f3\n");
    ret=mfEval2ndInt("FENGM2", 6, p3, n, x, y, verbose-2);
    if(ret!=0) return(105);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %.10E \n", x[i], cy3[i], y[i]);
      if(!doubleMatch(cy3[i], y[i], 1.0E-04)) ret++;
    }
    if(ret) return(106);
    if(verbose>2) printf("\n using all parameters \n");
    ret=mfEval2ndInt("FENGM2", 7, p3, n, x, y, verbose-2);
    if(ret!=0) return(107);
    for(i=0; i<n; i++) {
      if(!doubleMatch(cy3[i], y[i], 1.0E-04)) ret++;
    }
    if(ret) return(108);
    if(verbose>2) printf("\n ok \n");
  }



  {
    char *fid="FENGM2E";
    if(verbose>1) printf("\n testing '%s' with zero delay \n", fid);
    double p1[]={200., -0.8, 50, -0.2, 20., -0.05, 20., -0.005, 0.};
    int i, n=8;
    double x[]={0.1, 1., 2., 3., 5., 10., 20., 60.};
    double y[n];
    double cy1[]={0.0419537390667756, 30.8738604233450, 181.366681753751, 463.769309002961, 1337.91183062858, 4615.59220877624, 13945.2402821879, 74162.2557725828};

    if(verbose>2) printf("\n f1\n");
    ret=mfEval2ndInt("FENGM2E", 8, p1, n, x, y, verbose-2);
    if(ret!=0) return(111);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g :  %g vs %g \n", x[i], cy1[i], y[i]);
      if(!doubleMatch(cy1[i], y[i], 1.0E-05)) return(112);
    }
    if(verbose>2) printf("\n ok \n");
  }


  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mfEvalFrameY(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with empty input \n");
  ret=mfEvalFrameY(NULL, 0, NULL, 0, NULL, NULL, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(1);
  ret=mfEvalFrameY("FENGM2", 6, NULL, 3, NULL, NULL, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(2);


  {
    char *fid="FENGM2";
    if(verbose>1) printf("\n testing '%s' with zero delay \n", fid);
    // correct results computed using SageMath
    double p[]={200., -0.8, 50, -0.2, 20., -0.005, 0.};
    int i, n=8;
    double x1[]={0, 1, 2, 3, 5, 10, 15, 40};
    double x2[]={1, 2, 3, 4, 8, 15, 30, 60};
    double y[n];
    double cy[]={76.8361370040944, 124.009540944198, 108.053650158772, 83.0400377631102, 40.9654082421014, 23.2441037645523, 18.6662361076170, 15.5866229594536};

    ret=mfEvalFrameY("FENGM2", 6, p, n, x1, x2, y, verbose-2);
    if(ret!=0) return(101);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g-%g :  %g vs %g \n", x1[i], x2[i], cy[i], y[i]);
      if(!doubleMatch(cy[i], y[i], 1.0E-05)) ret++; 
    }
    if(ret) return(102);
    if(verbose>2) printf("\n ok \n");
  }


  {
    char *fid="FENGM2E";
    if(verbose>1) printf("\n testing '%s' with zero delay \n", fid);
    double p[]={200., -0.8, 50, -0.2, 20., -0.05, 20., -0.005, 0.};
    int i, n=8;
    double x1[]={0, 1, 2, 3, 5, 10, 15, 40};
    double x2[]={1, 2, 3, 4, 8, 15, 30, 60};
    double y[n];
    double cy[]={82.5775913067400, 136.380532377035, 122.925962685503, 98.5820333691632, 55.2907225000740, 33.9755857302042, 25.3125296697949, 17.2975872568286};

    ret=mfEvalFrameY("FENGM2E", 8, p, n, x1, x2, y, verbose-2);
    if(ret!=0) return(111);
    for(i=0; i<n; i++) {
      if(verbose>3) printf("  %g-%g :  %g vs %g \n", x1[i], x2[i], cy[i], y[i]);
      if(!doubleMatch(cy[i], y[i], 1.0E-05)) return(112);
    }
    if(verbose>2) printf("\n ok \n");
  }


  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_mfEvalIntToInf(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\n testing with empty input \n");
  ret=mfEvalIntToInf(NULL, 0, NULL, 0.0, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(1);
  ret=mfEvalIntToInf("1exp", 2, NULL, 3.0, NULL, verbose-2);
  if(verbose>2) printf(" good, did not crash \n");
  if(ret==0) return(2);


  {
    char *fid="1exp";
    if(verbose>1) printf("\n testing '%s' \n", fid);
    double p1[]={100., -0.8};
    double y;
    double x=0.0;
    double cy=125.;

    ret=mfEvalIntToInf("1exp", 2, p1, x, &y, verbose-2);
    if(ret!=0) return(101);
    if(verbose>3) printf("  %g :  %g vs %g \n", x, cy, y);
    if(!doubleMatch(cy, y, 1.0E-05)) return(102);
    if(verbose>2) printf("\n ok \n");

    x=10.0;
    cy=0.041932828;

    ret=mfEvalIntToInf("1exp", 2, p1, x, &y, verbose-2);
    if(ret!=0) return(103);
    if(verbose>3) printf("  %g :  %g vs %g \n", x, cy, y);
    if(!doubleMatch(cy, y, 1.0E-05)) return(104);
    if(verbose>2) printf("\n ok \n");
  }

  {
    char *fid="5exp";
    if(verbose>1) printf("\n testing '%s' \n", fid);
    double p1[]={100., -0.8, 50., -0.2, 20., -0.05, 2., -0.01, 1., -0.001};
    double y;
    double x=0.0;
    double cy=1975.;

    ret=mfEvalIntToInf("5exp", 10, p1, x, &y, verbose-2);
    if(ret!=0) return(111);
    if(verbose>3) printf("  %g :  %g vs %g \n", x, cy, y);
    if(!doubleMatch(cy, y, 1.0E-05)) return(112);
    if(verbose>2) printf("\n ok \n");

    x=10.0;
    cy=1447.505335;

    ret=mfEvalIntToInf("5exp", 10, p1, x, &y, verbose-2);
    if(ret!=0) return(113);
    if(verbose>3) printf("  %g :  %g vs %g \n", x, cy, y);
    if(!doubleMatch(cy, y, 1.0E-05)) return(114);
    if(verbose>2) printf("\n ok \n");
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
