/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcimage.h"
/*****************************************************************************/

/*****************************************************************************/
int test_imgInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  imgInit(NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  IMG img;
  imgInit(&img);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(verbose>1) imgContents(&img, stdout);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  imgFree(NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  IMG img;
  imgInit(&img);
  imgFree(&img);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(verbose>1) imgContents(&img, stdout);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgAllocate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret=imgAllocate(NULL, 0, 0, 0, 0, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret!=TPCERROR_FAIL) return(1);

  IMG img; imgInit(&img);

  ret=imgAllocate(&img, 0, 0, 0, 0, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(verbose>1) imgContents(&img, stdout);
  imgFree(&img);
  if(ret!=TPCERROR_FAIL) return(2);

  ret=imgAllocate(&img, 1, 1, 1, 1, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(verbose>1) imgContents(&img, stdout);
  imgFree(&img);
  if(ret!=TPCERROR_OK) return(2);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgHasData(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(imgHasData(NULL)!=0) return(1);

  IMG img; imgInit(&img);
  if(imgHasData(&img)!=0) return(2);

  imgAllocate(&img, 0, 0, 0, 0, NULL);
  if(imgHasData(&img)!=0) return(3);

  img.dimz=img.dimx=img.dimy=img.dimt=1;
  if(imgHasData(&img)!=0) return(4);

  imgAllocate(&img, 3, 10, 10, 2, NULL);
  if(imgHasData(&img)!=1) {imgFree(&img); return(5);}
  if(img.dimz!=3 || img.dimy!=10 || img.dimx!=10 || img.dimt!=2) {imgFree(&img); return(6);}
  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgHasTimes(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(imgHasTimes(NULL)!=0) return(1);

  IMG img; imgInit(&img);
  if(imgHasTimes(&img)!=0) return(2);

  imgAllocate(&img, 3, 10, 10, 2, NULL);
  if(imgHasTimes(&img)!=0) {imgFree(&img); return(3);}
  imgFree(&img);

  create_img(&img, 3, 10, 10, 2);
  if(imgHasTimes(&img)!=1) {imgFree(&img); return(4);}
  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgHasCounts(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(imgHasCounts(NULL)!=0) return(1);

  IMG img; imgInit(&img);
  if(imgHasCounts(&img)!=0) return(2);

  imgAllocate(&img, 3, 10, 10, 2, NULL);
  
  for(unsigned short int i=0; i<img.dimt; i++) img.prompts[i]=img.randoms[i]=0.0;
  if(imgHasCounts(&img)!=0) {imgFree(&img); return(11);}

  for(unsigned short int i=0; i<img.dimt; i++) img.prompts[i]=(float)(1000*(i+1));
  if(imgHasCounts(&img)!=1) {imgFree(&img); return(12);}

  for(unsigned short int i=0; i<img.dimt; i++) img.randoms[i]=(float)(100*(i+1));
  if(imgHasCounts(&img)!=3) {imgFree(&img); return(13);}

  for(unsigned short int i=0; i<img.dimt; i++) img.prompts[i]=0.0;
  if(imgHasCounts(&img)!=2) {imgFree(&img); return(14);}

  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgHasWeights(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(imgHasWeights(NULL)) return(1);

  IMG img; imgInit(&img);
  if(imgHasWeights(&img)) return(2);

  imgAllocate(&img, 3, 10, 10, 2, NULL);
  
  if(imgHasWeights(&img)) {imgFree(&img); return(11);}

  img.weighting=WEIGHTING_UNKNOWN;
  if(imgHasWeights(&img)) {imgFree(&img); return(12);}
  img.weighting=WEIGHTING_OFF;
  if(imgHasWeights(&img)) {imgFree(&img); return(13);}

  img.weighting=WEIGHTING_ON_GENERAL;
  if(!imgHasWeights(&img)) {imgFree(&img); return(14);}
  img.weighting=WEIGHTING_ON_FD;
  if(!imgHasWeights(&img)) {imgFree(&img); return(15);}

  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgNaNs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(imgNaNs(NULL, 0)!=0) return(1);
  if(imgNaNs(NULL, 1)!=0) return(2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  IMG img; imgInit(&img);
  if(imgNaNs(&img, 0)!=0) return(3);
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  imgAllocate(&img, 3, 10, 10, 2, NULL);
  if(imgNaNs(&img, 0)!=0) {imgFree(&img); return(11);}
  img.m[1][1][1][1]=nanf("");
  img.m[2][2][2][1]=nanf("");
  if(imgNaNs(&img, 0)!=2) {imgFree(&img); return(12);}
  if(imgNaNs(&img, 1)!=2) {imgFree(&img); return(13);}
  if(imgNaNs(&img, 1)!=0) {imgFree(&img); return(14);}

  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgMinMax(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(imgMinMax(NULL, NULL, NULL)!=TPCERROR_FAIL) return(1);

  IMG img; imgInit(&img);

  if(verbose>1) {printf("empty image\n"); fflush(stdout);}
  if(imgMinMax(&img, NULL, NULL)!=TPCERROR_FAIL) return(2);

  if(verbose>1) {printf("allocated image\n"); fflush(stdout);}
  imgAllocate(&img, 3, 10, 10, 2, NULL);
  if(imgMinMax(&img, NULL, NULL)!=TPCERROR_OK) {imgFree(&img); return(11);}

  float mi, ma;
  if(imgMinMax(&img, &mi, &ma)!=TPCERROR_OK) {imgFree(&img); return(12);}
  if(mi!=0 || ma!=0) {imgFree(&img); return(13);}
  imgFree(&img);

  if(verbose>1) {printf("test image\n"); fflush(stdout);}
  create_img(&img, 3, 10, 10, 2);
  if(imgMinMax(&img, &mi, &ma)!=TPCERROR_OK) {imgFree(&img); return(21);}
  if(verbose>2) printf("  min:=%g\n  max:=%g\n", mi, ma);
  if(imgMinMax(&img, NULL, NULL)!=TPCERROR_OK) {imgFree(&img); return(22);}

  if(verbose>1) {printf("works when first pixel is NaN\n"); fflush(stdout);}
  img.p[0]=nan("");
  if(imgMinMax(&img, &mi, &ma)!=TPCERROR_OK) {imgFree(&img); return(23);}
  if(verbose>2) printf("  min:=%g\n  max:=%g\n", mi, ma);
  if(imgMinMax(&img, NULL, NULL)!=TPCERROR_OK) {imgFree(&img); return(24);}

  if(verbose>1) {printf("fails if all values are NaN\n"); fflush(stdout);}
  for(unsigned int i=0; i<img.dimz*img.dimy*img.dimx*img.dimt; i++) img.p[i]=nan("");
  if(imgMinMax(&img, &mi, &ma)==TPCERROR_OK) {imgFree(&img); return(31);}
  if(verbose>2) printf("  min:=%g\n  max:=%g\n", mi, ma);
  if(verbose>1) {printf("  ... even if output is not requested\n"); fflush(stdout);}
  if(imgMinMax(&img, NULL, NULL)==TPCERROR_OK) {imgFree(&img); return(32);}

  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgXRange(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(imgXRange(NULL, NULL, NULL)!=TPCERROR_FAIL) return(1);
  double xmin, xmax;
  xmin=xmax=100.0;
  if(imgXRange(NULL, &xmin, &xmax)!=TPCERROR_FAIL) return(2);
  if(!isnan(xmin) || !isnan(xmax)) return(3);

  IMG img; imgInit(&img);

  if(verbose>1) {printf("empty image\n"); fflush(stdout);}
  xmin=xmax=100.0;
  if(imgXRange(&img, &xmin, &xmax)!=TPCERROR_FAIL) return(11);
  if(verbose>2) printf("  xmin:=%g\n  xmax:=%g\n", xmin, xmax);
  if(!isnan(xmin) || !isnan(xmax)) {imgFree(&img); return(12);}

  if(verbose>1) {printf("allocated image\n"); fflush(stdout);}
  xmin=xmax=100.0;
  imgAllocate(&img, 3, 10, 10, 2, NULL);
  if(imgXRange(&img, &xmin, &xmax)!=TPCERROR_OK) {imgFree(&img); return(21);}
  if(verbose>2) printf("  xmin:=%g\n  xmax:=%g\n", xmin, xmax);
  imgFree(&img);
  if(xmin!=0.0 || xmax!=0.0) {imgFree(&img); return(22);}

  if(verbose>1) {printf("test image\n"); fflush(stdout);}
  create_img(&img, 3, 10, 10, 4);
  if(imgXRange(&img, &xmin, &xmax)!=TPCERROR_OK) {imgFree(&img); return(31);}
  if(verbose>2) printf("  xmin:=%g\n  xmax:=%g\n", xmin, xmax);
  if(xmin!=img.x1[0] || xmax!=img.x2[img.dimt-1]) {imgFree(&img); return(32);}
  if(imgXRange(&img, NULL, NULL)!=TPCERROR_OK) {imgFree(&img); return(33);}
  img.x1[0]=img.x2[img.dimt-1]=nan("");
  if(imgXRange(&img, &xmin, &xmax)!=TPCERROR_OK) {imgFree(&img); return(34);}
  if(verbose>2) printf("  xmin:=%g\n  xmax:=%g\n", xmin, xmax);
  if(xmin!=img.x1[1] || xmax!=img.x2[img.dimt-2]) {imgFree(&img); return(35);}

  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
/** Create test IMG data for testing purposes. */
int create_img(
  /** Pointer to initialized image structure; old contents are deleted.
      @pre Initialize structure using imgInit() before this. */
  IMG *img,
  /** Nr of image planes to allocate. */
  const unsigned int dimz,
  /** Nr of image rows to allocate. */
  const unsigned int dimy,
  /** Nr of image columns to allocate. */
  const unsigned int dimx,
  /** Nr of image time frames (samples) to allocate. */
  const unsigned int dimt
) {
  if(img==NULL || dimz<1 || dimy<1 || dimx<1 || dimt<1) return(TPCERROR_FAIL);

  imgFree(img);
  int ret=imgAllocate(img, dimz, dimy, dimx, dimt, NULL);
  if(ret!=TPCERROR_OK) return(ret);

  img->content=IMG_CONTENT_IMAGE;
  img->modality=IMG_MODALITY_PET;
  img->format=img->oformat=IMG_FORMAT_UNKNOWN;
  img->sizex=img->sizey=3.0; img->sizez=4.0;
  img->gapx=img->gapy=img->gapz=0.0;
  img->decayCorrection=DECAY_CORRECTED;
  img->isot=ISOTOPE_C_11;
  img->weighting=WEIGHTING_UNKNOWN;
  img->cunit=UNIT_BQ_PER_ML; img->tunit=UNIT_SEC;

  for(unsigned int i=0; i<dimt; i++) {
    if(i==0) img->x1[i]=0.0; else img->x1[i]=img->x2[i-1];
    img->x2[i]=(i+1)*60.0;
    img->x[i]=0.5*(img->x1[i]+img->x2[i]);
  }
  float f=-1.0;
  for(unsigned int zi=0; zi<dimz; zi++) {
    f+=(float)(3*zi);
    for(unsigned int yi=0; yi<dimy; yi++) {
      f+=(float)(2*yi);
      for(unsigned int xi=0; xi<dimx; xi++) {
        f+=(float)(xi);
        if(f>10000.0) f=-100.0; // prevent error when floats are scaled to short ints
        for(unsigned int ti=0; ti<dimt; ti++) {
          img->m[zi][yi][xi][ti]=f+(float)ti;
        }
      }
    }
  }

  strcpy(img->scanStart, "2021-11-19 15:27:44");

  return(TPCERROR_OK);
}
/*****************************************************************************/

/*****************************************************************************/
