/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcimage.h"
/*****************************************************************************/

/*****************************************************************************/
int test_imgCompareMatrixSize(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("testing with NULL input\n");
  ret=imgCompareMatrixSize(NULL, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==0) return(1);

  /* Make test data with different matrix size */
  IMG img1; imgInit(&img1);
  if(create_img(&img1, 4, 8, 8, 1)!=TPCERROR_OK) return(10);
  IMG img2; imgInit(&img2);
  if(create_img(&img2, 4, 6, 6, 1)!=TPCERROR_OK) {imgFree(&img1); return(20);}

  if(imgCompareMatrixSize(&img1, &img2)==0) {imgFree(&img1); imgFree(&img2); return(21);}
  if(imgCompareMatrixSize(&img1, &img1)!=0) {imgFree(&img1); imgFree(&img2); return(22);}

  /* Make test data with the same matrix size but different frame number */
  imgFree(&img2);
  if(create_img(&img2, 4, 8, 8, 2)!=TPCERROR_OK) {imgFree(&img1); return(30);}
  if(imgCompareMatrixSize(&img1, &img2)!=0) {imgFree(&img1); imgFree(&img2); return(31);}

  imgFree(&img1); imgFree(&img2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgCompareUnit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  ret=imgCompareUnit(NULL, NULL, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==0) return(1);

  /* Make test data with a single plane and frame */
  IMG img; imgInit(&img);
  if(verbose>1) printf("\n making test image data.\n");
  if(create_img(&img, 1, 32, 32, 1)!=TPCERROR_OK) return(10);
  ret=imgCompareUnit(&img, &img, NULL);
  if(ret!=0) {imgFree(&img); return(11);}

  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgCompareConc(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  ret=imgCompareConc(NULL, NULL, 0.0, 0.0, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==0) return(1);

  /* Make test data with a single plane and frame */
  IMG img; imgInit(&img);
  if(verbose>1) printf("\n making test image data.\n");
  if(create_img(&img, 1, 32, 32, 1)!=TPCERROR_OK) return(10);
  ret=imgCompareConc(&img, &img, 0.0, 0.0, NULL);
  if(ret!=0) {imgFree(&img); return(11);}

  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgCompareTimes(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  ret=imgCompareTimes(NULL, NULL, 0.0, 0.0, NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret==0) return(1);

  /* Make test data with a single plane and frame */
  IMG img; imgInit(&img);
  if(verbose>1) printf("\n making test image data.\n");
  if(create_img(&img, 1, 32, 32, 1)!=TPCERROR_OK) return(10);
  ret=imgCompareTimes(&img, &img, 0.0, 0.0, NULL);
  if(ret!=0) {imgFree(&img); return(11);}

  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
