/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcimage.h"
/*****************************************************************************/

/*****************************************************************************/
int test_imgFormatDescr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;
  cptr=imgFormatDescr(-1); if(cptr!=NULL) return 1;
  cptr=imgFormatDescr(IMG_FORMAT_UNKNOWN); if(strcasecmp(cptr, "Unknown")) return 2;
  cptr=imgFormatDescr(IMG_FORMAT_DICOM); if(strcasecmp(cptr, "DICOM")) return 3;
  cptr=imgFormatDescr(9999); if(cptr!=NULL) return 4;
  if(verbose>1) {
    int i=0; printf("IMG file formats:\n");
    while((cptr=imgFormatDescr(i))!=NULL) {printf("  %s\n", cptr); i++;}
  }
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgDefaultExtension(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;
  cptr=imgDefaultExtension(-1); if(cptr!=NULL) return 1;
  cptr=imgDefaultExtension(IMG_FORMAT_UNKNOWN); if(strcasecmp(cptr, "")) return 2;
  cptr=imgDefaultExtension(IMG_FORMAT_E7); if(strcasecmp(cptr, ".v")) return 3;
  cptr=imgDefaultExtension(9999); if(cptr!=NULL) return 4;
  if(verbose>1) {
    int i=0; printf("IMG file extensions:\n");
    while((cptr=imgDefaultExtension(i))!=NULL) {printf("  %s\n", cptr); i++;}
  }
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgRead(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret=imgRead(NULL, "", NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret!=TPCERROR_FAIL) return(1);

  IMG img; imgInit(&img);

  ret=imgRead(&img, "", NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(verbose>1) imgContents(&img, stdout);
  imgFree(&img);
  if(ret!=TPCERROR_FAIL) return(2);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgWrite(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret=imgWrite(NULL, "", NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  if(ret!=TPCERROR_FAIL) return(1);

  IMG img; imgInit(&img);

  ret=imgWrite(&img, "", NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  imgFree(&img); if(ret!=TPCERROR_FAIL) return(2);

  /* Make test data with a single plane and frame, no header */
  if(verbose>1) printf("\n making test image data.\n");
  if(create_img(&img, 1, 32, 32, 1)!=TPCERROR_OK) return(10);
  if(verbose>2) imgContents(&img, stdout);

  /* Write it as DICOM, by giving only folder name */
  if(verbose>1) printf("\n writing dicom folder.\n");
  ret=imgWrite(&img, "wdicom1/", status);
  if(ret!=TPCERROR_OK) {imgFree(&img); return(11);}

  /* Write it as ECAT7 */
  if(verbose>1) printf("\n writing ECAT 7 image.\n");
  img.oformat=IMG_FORMAT_UNKNOWN;
  ret=imgWrite(&img, "wecat7.v", status);
  if(ret!=TPCERROR_OK) {imgFree(&img); return(21);}


  imgFree(&img);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgFormatFromFName(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  imgformat f;

  if(verbose>1) printf("\n testing with empty name\n");
  f=imgFormatFromFName(NULL, NULL);
  if(f!=IMG_FORMAT_UNKNOWN) return(1);
  f=imgFormatFromFName("", NULL);
  if(f!=IMG_FORMAT_UNKNOWN) return(2);
  
  if(verbose>1) printf("\n testing with path name\n");
  f=imgFormatFromFName("../test", NULL);
  if(f!=IMG_FORMAT_DICOM) return(11);
  f=imgFormatFromFName("../test/", NULL);
  if(f!=IMG_FORMAT_DICOM) return(12);
  f=imgFormatFromFName(".", NULL);
  if(f!=IMG_FORMAT_DICOM) return(13);
  
  if(verbose>1) printf("\n testing with name without extension\n");
  f=imgFormatFromFName("image", NULL);
  if(f!=IMG_FORMAT_UNKNOWN) return(21);
  f=imgFormatFromFName("../test/image", NULL);
  if(f!=IMG_FORMAT_UNKNOWN) return(22);

  if(verbose>1) printf("\n testing with known extensions\n");
  f=imgFormatFromFName("image.scn", NULL);
  if(f!=IMG_FORMAT_E63) return(31);
  f=imgFormatFromFName("image.v", NULL);
  if(f!=IMG_FORMAT_E7) return(32);
  f=imgFormatFromFName("image.nii", NULL);
  if(f!=IMG_FORMAT_NIFTI_1S) return(33);

  if(verbose>1) printf("\n testing with other extensions\n");
  f=imgFormatFromFName("data.tac", NULL);
  if(f!=IMG_FORMAT_UNKNOWN) return(41);
  f=imgFormatFromFName("frames.sif", NULL);
  if(f!=IMG_FORMAT_UNKNOWN) return(42);
  f=imgFormatFromFName("image.hdr", NULL);
  if(f!=IMG_FORMAT_UNKNOWN) return(43);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_imgFormatIdentify(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  imgformat f;

  if(verbose>1) printf("\n testing with empty name\n");
  f=imgFormatIdentify(NULL);
  if(f!=IMG_FORMAT_UNKNOWN) return(1);
  f=imgFormatIdentify("");
  if(f!=IMG_FORMAT_UNKNOWN) return(2);
  
  if(verbose>1) printf("\n testing with valid format name\n");
  f=imgFormatIdentify("DICOM");
  if(f!=IMG_FORMAT_DICOM) return(11);
  f=imgFormatIdentify("FLAT");
  if(f!=IMG_FORMAT_FLAT) return(12);

  if(verbose>1) printf("\n testing with non-standard format name\n");
  f=imgFormatIdentify("DCM");
  if(f!=IMG_FORMAT_DICOM) return(21);
  f=imgFormatIdentify("ANA");
  if(f!=IMG_FORMAT_ANA_L) return(22);
  f=imgFormatIdentify("NII");
  if(f!=IMG_FORMAT_NIFTI_1S) return(23);
  f=imgFormatIdentify("NIFTI");
  if(f!=IMG_FORMAT_NIFTI_1S) return(24);

  if(verbose>1) printf("\n testing with invalid format names\n");
  f=imgFormatIdentify("PMOD");
  if(f!=IMG_FORMAT_UNKNOWN) return(41);
  f=imgFormatIdentify("SIF");
  if(f!=IMG_FORMAT_UNKNOWN) return(42);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
