/******************************************************************************
 * This file is not compiled into the library, but it contains main()
 * which is compiled to an executable, used to test the library functions. 
 *****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/
#include "tpcisotope.h"
#include "test_tpcisotope.h"
/*****************************************************************************/

/*****************************************************************************/
static char *info[] = {
  "Usage: @P [options]",
  " ",
  "Options:",
  " -stdoptions", // List standard options like --help, -v, etc
  " -t, --test",
  "     Run all tests for library functions.",
  0};
/*****************************************************************************/

/*****************************************************************************/
/** Run unit tests to the library functions
 *  @author Vesa Oikonen
 *  @return 0 if all tests pass, otherwise >0.
 * */
int main(
  /** Nr of arguments */
  int argc,
  /** Pointer to arrays of argument string */
  char *argv[ ]
) {
  int i, ret, help=0, version=0, verbose=1, error=0, test=0;
  char *cptr;

  if(argc==1) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  for(i=1; i<argc; i++) {
    if(tpcProcessStdOptions(argv[i], &help, &version, &verbose)==0) continue;
    cptr=argv[i]; if(*cptr=='-') cptr++; if(*cptr=='-') cptr++;
    if(strncasecmp(cptr, "TEST", 1)==0) {
      test=1; continue;
    } else {
      error++; break;
    }
  }
  if(error>0) {
    fprintf(stderr, "Error: specify --help for usage.\n");
    return(1);
  }
  /* Print help or version? */
  if(help) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  if(version) {tpcPrintBuild(argv[0], stdout); return(0);}

  if(test==0) return(0);

  if(verbose>0) printf("running tests for library functions...\n");
  TPCSTATUS status; statusInit(&status); status.verbose=verbose;
  statusSet(&status, __func__, __FILE__, __LINE__, 0);

  if(verbose>0) printf("running tests for library functions...\n");
  i=10;
  /* elements */
  i++; if((ret=test_elementName(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_elementSymbol(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if((ret=test_elementIdentify(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  /* isotope */
  i++; if(test_isotopeHalflife(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  i++; if(test_isotopeBranching(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  i++; if(test_isotopeName(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  i++; if(test_isotopeIdentifyHalflife(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  i++; if(test_isotopeIdentify(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  /* decay */
  i++; if((ret=test_decayDescr(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }
  i++; if(test_lambdaFromHalflife(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  i++; if(test_lambdaFromIsotope(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  i++; if(test_decayCorrectionFactorFromLambda(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  i++; if(test_decayCorrectionFactorFromIsotope(verbose)!=0) {fprintf(stderr, "failed.\n"); return(i);}
  /* ranoise */
  i++; if((ret=test_noiseSD4Frame(&status))!=0) {
    fprintf(stderr, "failed (%d).\n", ret);
    statusPrint(stderr, &status); statusFree(&status);
    return(i);
  }

  if(verbose>0) printf("\nAll tests passed.\n\n");
  statusFree(&status);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
