/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcisotope.h"
/*****************************************************************************/

/*****************************************************************************/
int test_elementName(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned short int z;
  char *cptr;

  z=0; if(verbose>1) printf("Z := %u\n", z);
  cptr=elementName(z);
  if(verbose>2) printf("  -> element := %s\n", cptr);
  if(strcasecmp(cptr, "unknown")!=0) return(1);

  z=9999; if(verbose>1) printf("Z := %u\n", z);
  cptr=elementName(z);
  if(verbose>2) printf("  -> element := %s\n", cptr);
  if(strcasecmp(cptr, "unknown")!=0) return(2);

  z=6; if(verbose>1) printf("Z := %d\n", z);
  cptr=elementName(z);
  if(verbose>2) printf("  -> element := %s\n", cptr);
  if(strcasecmp(cptr, "Carbon")!=0) return(3);
  
  z=118; if(verbose>1) printf("Z := %d\n", z);
  cptr=elementName(z);
  if(verbose>2) printf("  -> element := %s\n", cptr);
  if(strcasecmp(cptr, "Oganesson")!=0) return(4);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_elementSymbol(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned short int z;
  char *cptr;

  z=0; if(verbose>1) printf("Z := %u\n", z);
  cptr=elementSymbol(z);
  if(verbose>2) printf("  -> element := %s\n", cptr);
  if(strcmp(cptr, "Unknown")!=0) return(1);

  z=9999; if(verbose>1) printf("Z := %u\n", z);
  cptr=elementSymbol(z);
  if(verbose>2) printf("  -> element := %s\n", cptr);
  if(strcmp(cptr, "Unknown")!=0) return(2);

  z=6; if(verbose>1) printf("Z := %d\n", z);
  cptr=elementSymbol(z);
  if(verbose>2) printf("  -> element := %s\n", cptr);
  if(strcmp(cptr, "C")!=0) return(3);
  
  z=118; if(verbose>1) printf("Z := %d\n", z);
  cptr=elementSymbol(z);
  if(verbose>2) printf("  -> element := %s\n", cptr);
  if(strcmp(cptr, "Og")!=0) return(4);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_elementIdentify(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned short int z;
  char *cptr, buf[32];

  cptr=NULL; if(verbose>1) printf("test string := NULL\n");
  z=elementIdentify(cptr);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=0) return(1);

  strcpy(buf, ""); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=0) return(2);

  strcpy(buf, "Meh"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=0) return(3);


  strcpy(buf, "Carbon"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(11);

  strcpy(buf, "carbon"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(12);

  strcpy(buf, "C"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(13);

  strcpy(buf, "c"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(14);

  strcpy(buf, "11C"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(15);

  strcpy(buf, "C-11"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(16);

  strcpy(buf, "^11^C"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(17);

  strcpy(buf, "^11^Carbon"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(18);

  strcpy(buf, "(^11^Carbon)"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=6) return(19);


  strcpy(buf, "Sodium"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(21);

  strcpy(buf, "sodium"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(22);

  strcpy(buf, "Na"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(23);

  strcpy(buf, "na"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(24);

  strcpy(buf, "22Na"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(25);

  strcpy(buf, "Na-22"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(26);

  strcpy(buf, "^22^Na"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(27);

  strcpy(buf, "^22^Sodium"); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(28);

  strcpy(buf, "    ^22^Sodium    "); if(verbose>1) printf("test string := '%s'\n", buf);
  z=elementIdentify(buf);
  if(verbose>2) printf("  -> Z:=%u  element := %s\n", z, elementName(z));
  if(z!=11) return(29);


  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
