/** @file tpcli.h
    @brief Header file for libtpcli.
    @details Header file for library libtpcli.
    @author Vesa Oikonen
    @copyright (c) Turku PET Centre
 */
#ifndef _TPCLI_H_
#define _TPCLI_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
/*****************************************************************************/

/*****************************************************************************/
/* interpolate */
extern int liInterpolate(
  double *x, double *y, const int nr,
  double *newx, double *newy, double *newyi, double *newyii, const int newnr,
  const int se, const int ee, const int verbose
);
extern int liInterpolateForPET(
  double *x, double *y, const int nr,
  double *newx1, double *newx2, double *newy, double *newyi, double *newyii, 
  const int newnr, const int se, const int ee, const int verbose
);
extern double liFirstStepSize(double *x, const int nr);
/*extern int liFrameMidValue(
  double *x1, double *x2, double *y, const size_t nr, double *newy,
  const int verbose
);*/
extern unsigned int simSamples(
  double initStep, double maxStep, double endTime, int mode, double *x
);
/*****************************************************************************/
/* integrate */
extern int liIntegrate(
  double *x, double *y, const int nr,
  double *yi, const int se, const int verbose
);
extern int liIntegratePET(
  double *x1, double *x2, double *y, int nr,
  double *ie, double *iie, const int verbose
);
extern int liIntegrateFE(
  double *x1, double *x2, double *y, int nr,
  double *ie, double *iie, const int verbose
);
extern int liIntegrateHalfFrame(
  double *x1, double *x2, double *y, const size_t nr, double *fhi,
  const int verbose
);
/*****************************************************************************/

/*****************************************************************************/
#endif /* _TPCLI_H */
