/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpclinopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_rootsCubic(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  double a, b, c, x1, x2, x3, cx1, cx2, cx3;
  int ret;

  /* Invalid input */
  a=1.0; b=nan(""); c=-2.0; cx1=nan(""); cx2=nan(""); cx3=nan("");
  ret=rootsCubic(a, b, c, &x1, &x2, &x3);
  if(verbose>1) printf("rootsCubic(%g, %g, %g) gives roots %g, %g, %g\n", a, b, c, x1, x2, x3);
  if(ret!=0) return(10);
  if(!doubleMatch(cx1, x1, 1.0E-20)) return(11);
  if(!doubleMatch(cx2, x2, 1.0E-20)) return(12);
  if(!doubleMatch(cx3, x3, 1.0E-20)) return(13);

  a=1.0; b=2.0; c=-2.0; cx1=nan(""); cx2=nan(""); cx3=nan("");
  ret=rootsCubic(a, b, c, &x1, &x2, NULL);
  if(verbose>1) printf("rootsCubic(%g, %g, %g) gives roots %g, %g, %g\n", a, b, c, x1, x2, x3);
  if(ret!=0) return(20);
  if(!doubleMatch(cx1, x1, 1.0E-20)) return(21);
  if(!doubleMatch(cx2, x2, 1.0E-20)) return(22);
  if(!doubleMatch(cx3, x3, 1.0E-20)) return(23);

  /* Zero input */
  a=0.0; b=0.0; c=0.0; cx1=nan(""); cx2=nan(""); cx3=nan("");
  ret=rootsCubic(a, b, c, &x1, &x2, &x3);
  if(verbose>1) printf("rootsCubic(%g, %g, %g) gives roots %g, %g, %g\n", a, b, c, x1, x2, x3);
  if(ret!=0) return(100);
  if(!doubleMatch(cx1, x1, 1.0E-20)) return(101);
  if(!doubleMatch(cx2, x2, 1.0E-20)) return(102);
  if(!doubleMatch(cx3, x3, 1.0E-20)) return(103);

  /* Equation with 3 real roots */
  a=-2.0; b=-5.0; c=6.0; cx1=-2.0; cx2=1.0; cx3=3.0;
  ret=rootsCubic(a, b, c, &x1, &x2, &x3);
  if(verbose>1) printf("rootsCubic(%g, %g, %g) gives roots %g, %g, %g\n", a, b, c, x1, x2, x3);
  if(ret!=3) return(110);
  if(!doubleMatch(cx1, x1, 1.0E-20)) return(111);
  if(!doubleMatch(cx2, x2, 1.0E-20)) return(112);
  if(!doubleMatch(cx3, x3, 1.0E-15)) return(113);

  /* Equation with 1 real root */
  a=-3.0; b=4.0; c=-2.0; cx1=1.0; cx2=nan(""); cx3=nan("");
  ret=rootsCubic(a, b, c, &x1, &x2, &x3);
  if(verbose>1) printf("rootsCubic(%g, %g, %g) gives roots %g, %g, %g\n", a, b, c, x1, x2, x3);
  if(ret!=1) return(120);
  if(!doubleMatch(cx1, x1, 1.0E-15)) return(121);
  if(!doubleMatch(cx2, x2, 1.0E-15)) return(122);
  if(!doubleMatch(cx3, x3, 1.0E-15)) return(123);

  /* Equation with one real roots (line) */
  a=0.0; b=1.0; c=0.0; cx1=0.0; cx2=nan(""); cx3=nan("");
  ret=rootsCubic(a, b, c, &x1, &x2, &x3);
  if(verbose>1) printf("rootsCubic(%g, %g, %g) gives roots %g, %g, %g\n", a, b, c, x1, x2, x3);
  if(ret!=1) return(130);
  if(!doubleMatch(cx1, x1, 1.0E-15)) return(131);
  if(!doubleMatch(cx2, x2, 1.0E-15)) return(132);
  if(!doubleMatch(cx3, x3, 1.0E-15)) return(133);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_rootsQuadratic(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  double a, b, c, x1, x2, cx1, cx2;
  int ret;

  /* Invalid input */
  a=nan(""); b=-2.0; c=-3.0; cx1=nan(""); cx2=nan("");
  ret=rootsQuadratic(a, b, c, &x1, &x2);
  if(verbose>1) printf("rootsQuadratic(%g, %g, %g) gives roots %g, %g\n", a, b, c, x1, x2);
  if(ret!=0) return(10);
  if(!doubleMatch(cx1, x1, 1.0E-20)) return(11);
  if(!doubleMatch(cx2, x2, 1.0E-20)) return(12);

  a=0.0; b=-2.0; c=-3.0; cx1=nan(""); cx2=nan("");
  ret=rootsQuadratic(a, b, c, &x1, NULL);
  if(verbose>1) printf("rootsQuadratic(%g, %g, %g) gives roots %g, %g\n", a, b, c, x1, x2);
  if(ret!=0) return(20);
  if(!doubleMatch(cx1, x1, 1.0E-20)) return(21);
  if(!doubleMatch(cx2, x2, 1.0E-20)) return(22);

  /* Zero input */
  a=0.0; b=0.0; c=0.0; cx1=nan(""); cx2=nan("");
  ret=rootsQuadratic(a, b, c, &x1, &x2);
  if(verbose>1) printf("rootsQuadratic(%g, %g, %g) gives roots %g, %g\n", a, b, c, x1, x2);
  if(ret!=0) return(100);
  if(!doubleMatch(cx1, x1, 1.0E-20)) return(101);
  if(!doubleMatch(cx2, x2, 1.0E-20)) return(102);

  /* Equation with 2 real roots */
  a=1.0; b=-2.0; c=-3.0; cx1=-1.0; cx2=3.0;
  ret=rootsQuadratic(a, b, c, &x1, &x2);
  if(verbose>1) printf("rootsQuadratic(%g, %g, %g) gives roots %g, %g\n", a, b, c, x1, x2);
  if(ret!=2) return(110);
  if(!doubleMatch(cx1, x1, 1.0E-20)) return(111);
  if(!doubleMatch(cx2, x2, 1.0E-20)) return(112);

  /* Equation with 1 individual real root (double roots) */
  a=1.0; b=-10.0; c=25.0; cx1=5.0; cx2=nan("");
  ret=rootsQuadratic(a, b, c, &x1, &x2);
  if(verbose>1) printf("rootsQuadratic(%g, %g, %g) gives roots %g, %g\n", a, b, c, x1, x2);
  if(ret!=1) return(120);
  if(!doubleMatch(cx1, x1, 1.0E-15)) return(121);
  if(!doubleMatch(cx2, x2, 1.0E-15)) return(122);

  /* Equation with no real roots */
  a=-3.0; b=2.0; c=-1.0; cx1=nan(""); cx2=nan("");
  ret=rootsQuadratic(a, b, c, &x1, &x2);
  if(verbose>1) printf("rootsQuadratic(%g, %g, %g) gives roots %g, %g\n", a, b, c, x1, x2);
  if(ret!=0) return(130);
  if(!doubleMatch(cx1, x1, 1.0E-15)) return(131);
  if(!doubleMatch(cx2, x2, 1.0E-15)) return(132);

  /* Equation with no real roots (horizontal line) */
  a=0.0; b=0.0; c=1.0; cx1=nan(""); cx2=nan("");
  ret=rootsQuadratic(a, b, c, &x1, &x2);
  if(verbose>1) printf("rootsQuadratic(%g, %g, %g) gives roots %g, %g\n", a, b, c, x1, x2);
  if(ret!=0) return(140);
  if(!doubleMatch(cx1, x1, 1.0E-15)) return(141);
  if(!doubleMatch(cx2, x2, 1.0E-15)) return(142);

  /* Equation with one real roots (line) */
  a=0.0; b=1.0; c=0.0; cx1=0.0; cx2=nan("");
  ret=rootsQuadratic(a, b, c, &x1, &x2);
  if(verbose>1) printf("rootsQuadratic(%g, %g, %g) gives roots %g, %g\n", a, b, c, x1, x2);
  if(ret!=1) return(150);
  if(!doubleMatch(cx1, x1, 1.0E-15)) return(151);
  if(!doubleMatch(cx2, x2, 1.0E-15)) return(152);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
