/** @file tpcmicropet.h
    @brief Header file for libtpcmicropet.
    @details 
     Function are not intended to support all microPET files or file properties, 
     but only those that have been found necessary in Turku PET Centre. 

     Procedures in this file are not dependent on IMG struct. 

    @author Vesa Oikonen
 */
#ifndef _TPCMICROPET_H_
#define _TPCMICROPET_H_
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcift.h"
#include "tpcfileutil.h"
/*****************************************************************************/

/*****************************************************************************/
/* micropetio */
extern int micropetHeaderRead(const char *hdrfile, IFT *header, TPCSTATUS *status);
extern int micropetExists(
  const char *filename, char *hdrfile, char *imgfile, IFT *header, TPCSTATUS *status
);
/*****************************************************************************/

/*****************************************************************************/
#endif /* TPCMICROPET */
