/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcmodels.h"
/*****************************************************************************/

/*****************************************************************************/
int test_aicSS(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  double aic, ss;
  int n, k;

  if(verbose>1) printf("testing with zero input\n");
  ss=0.0; n=k=0; aic=aicSS(ss, n, k);
  if(verbose>2) printf("aicSS(%g, %d, %d) := %g\n", ss, n, k, aic);
  if(!isnan(aic)) {
    statusSet(status, __func__, __FILE__, __LINE__, 1);
    return(1);
  }

  if(verbose>1) printf("testing with negative input\n");
  ss=0.0; n=k=-1; aic=aicSS(ss, n, k);
  if(verbose>2) printf("aicSS(%g, %d, %d) := %g\n", ss, n, k, aic);
  if(!isnan(aic)) {
    statusSet(status, __func__, __FILE__, __LINE__, 1);
    return(2);
  }
  ss=-1.0; n=k=5; aic=aicSS(ss, n, k);
  if(verbose>2) printf("aicSS(%g, %d, %d) := %g\n", ss, n, k, aic);
  if(!isnan(aic)) {
    statusSet(status, __func__, __FILE__, __LINE__, 1);
    return(3);
  }

  if(verbose>1) printf("testing with n-k=1\n");
  ss=100.0; n=10; k=9; aic=aicSS(ss, n, k);
  if(verbose>2) printf("aicSS(%g, %d, %d) := %g\n", ss, n, k, aic);
  if(!isnan(aic)) {
    statusSet(status, __func__, __FILE__, __LINE__, 1);
    return(4);
  }

  if(verbose>1) printf("testing with valid input\n");

  ss=100.0; n=20; k=4; aic=aicSS(ss, n, k);
  if(verbose>2) printf("aicSS(%g, %d, %d) := %g\n", ss, n, k, aic);
  if(!doubleMatch(aic, 42.85542, 0.00001)) {
    statusSet(status, __func__, __FILE__, __LINE__, 1);
    return(10);
  }
  ss=100.0; n=20; k=5; aic=aicSS(ss, n, k);
  if(verbose>2) printf("aicSS(%g, %d, %d) := %g\n", ss, n, k, aic);
  if(!doubleMatch(aic, 46.47447, 0.00001)) {
    statusSet(status, __func__, __FILE__, __LINE__, 1);
    return(11);
  }
  ss=105.0; n=21; k=4; aic=aicSS(ss, n, k);
  if(verbose>2) printf("aicSS(%g, %d, %d) := %g\n", ss, n, k, aic);
  if(!doubleMatch(aic, 44.298196, 0.00001)) {
    statusSet(status, __func__, __FILE__, __LINE__, 1);
    return(12);
  }
  ss=0.100; n=20; k=4; aic=aicSS(ss, n, k);
  if(verbose>2) printf("aicSS(%g, %d, %d) := %g\n", ss, n, k, aic);
  if(!doubleMatch(aic, -95.29968, 0.00001)) {
    statusSet(status, __func__, __FILE__, __LINE__, 1);
    return(13);
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parFreeNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  double b1[10], b2[10];
  unsigned int n, k;

  if(verbose>1) printf("testing with zero input\n");
  n=0; k=parFreeNr(n, b1, b2);
  if(k!=0) {statusSet(status, __func__, __FILE__, __LINE__, 1); return(1);}

  if(verbose>1) printf("testing with 1 parameter\n");
  n=1; for(unsigned int i=0; i<n; i++) {b1[i]=0.0; b2[i]=0.0;}
  k=parFreeNr(n, b1, b2);
  if(k!=0) {statusSet(status, __func__, __FILE__, __LINE__, 1); return(10);}
  n=1; for(unsigned int i=0; i<n; i++) {b1[i]=0.0; b2[i]=1.0;}
  k=parFreeNr(n, b1, b2);
  if(k!=1) {statusSet(status, __func__, __FILE__, __LINE__, 1); return(11);}

  if(verbose>1) printf("testing with 10 parameter\n");
  n=10; for(unsigned int i=0; i<n; i++) {b1[i]=0.0; b2[i]=0.0;}
  k=parFreeNr(n, b1, b2);
  if(k!=0) {statusSet(status, __func__, __FILE__, __LINE__, 1); return(20);}
  n=10; for(unsigned int i=0; i<n; i++) {b1[i]=0.0; b2[i]=1.0;}
  k=parFreeNr(n, b1, b2);
  if(k!=n) {statusSet(status, __func__, __FILE__, __LINE__, 1); return(21);}
  b2[5]=-1.0;
  k=parFreeNr(n, b1, b2);
  if(k!=n-1) {statusSet(status, __func__, __FILE__, __LINE__, 1); return(22);}


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
