/** @file niftiname.c
 *  @brief Procedures for NIfTI file names.
 */
/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcnifti.h"
/*****************************************************************************/

/*****************************************************************************/
/** Remove any extensions from NIfTI file name, leaving only base file name.
    Possible path is kept.
 */
void niftiBasename(
  /** Full name of file. */
  char *filename
) {
  if(filename==NULL) return;
  char basename[FILENAME_MAX];
  strncpyCleanSpaces(basename, filename, FILENAME_MAX);
  strcpy(filename, "");
  char *cptr=filenameGetExtension(basename);
  if(cptr!=NULL) {
    if(strcasecmp(cptr, ".hdr")==0) *cptr=(char)0;
    else if(strcasecmp(cptr, ".nii")==0) *cptr=(char)0;
    else if(strcasecmp(cptr, ".img")==0) *cptr=(char)0;
    else if(strcasecmp(cptr, ".sif")==0) *cptr=(char)0;
    else if(strcasecmp(cptr, ".")==0) *cptr=(char)0;
  }
  /* Remove also double extensions, e.g. from data.img.hdr */
  cptr=filenameGetExtension(basename);
  if(cptr!=NULL) {
    if(strcasecmp(cptr, ".nii")==0) *cptr=(char)0;
    else if(strcasecmp(cptr, ".img")==0) *cptr=(char)0;
    else if(strcasecmp(cptr, ".")==0) *cptr=(char)0;
  }
  strcpy(filename, basename);
  return;
}
/*****************************************************************************/

/*****************************************************************************/
