/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcnlopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_nloptMPSO(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>5) {
    char logfile[256];
    sprintf(logfile, "%s.log", __func__);
    status->fp=fopen(logfile, "w");
  } else status->fp=stdout;

  int ret, parNr;
  NLOPT nlo; nloptInit(&nlo);
  double e;

  if(verbose>1) fprintf(status->fp, "\n Calling function with empty input\n");
  ret=nloptMPSO(&nlo, 0, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, status);
  if(ret==TPCERROR_OK) return(1);
  if(verbose>2) fprintf(status->fp, "  -> error returned, which is good\n");


  if(verbose>1) {
    fprintf(status->fp, "\n --------------------------------------------------- \n");
    fprintf(status->fp, "\n Rosenbrock's valley with N=2, with no initial guess \n");
    fflush(status->fp);
  }
  parNr=2;
  ret=nloptAllocate(&nlo, parNr);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(11);}
  /* set parameter limits */
  nlo.xlower[0]=0.0;  nlo.xupper[0]=100.0;  nlo.xtol[0]=0.001;
  nlo.xlower[1]=0.1;  nlo.xupper[1]=50.0;   nlo.xtol[1]=0.001;
  /* set object function */
  nlo._fun=nloptDejong2;
  /* Optimize */
  nlo.maxFunCalls=50000;
  //srand(10); // to get same sequence of random numbers each time
  ret=nloptMPSO(&nlo, 1500, 0, 15, 0.333, 1.0, 1.6, 1.0, 0.002, 0.025, 0, status);
  if(verbose>2) fprintf(status->fp, "  -> ret := %d\n", ret);
  if(verbose>3) fprintf(status->fp, "  -> function_calls := %d\n", nlo.funCalls);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error in %s.\n", __func__);
    statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_FAIL);
    if(status->fp!=NULL && status->fp!=stdout && status->fp!=stderr) fclose(status->fp);
    status->fp=stdout;
    nloptFree(&nlo); return(12);
  }
  if(verbose>2) for(int i=0; i<parNr; i++) fprintf(status->fp, "  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-1.0);
    if(e>5.0E-03) {
      ret++; if(verbose>2) fprintf(status->fp, "  |x[%d]-true|=%g\n", i, e);
    }
  }
  if(ret>0) {
    fprintf(stderr, "%s did not converge to correct minimum.\n", __func__);
    statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_FAIL);
    if(status->fp!=NULL && status->fp!=stdout && status->fp!=stderr) fclose(status->fp);
    status->fp=stdout;
    nloptFree(&nlo); return(13);
  }
  nloptFree(&nlo);


  if(verbose>1) {
    fprintf(status->fp, "\n --------------------------------------------------- \n");
    fprintf(status->fp, "\n Rosenbrock's valley with N=6, with good initial guess \n");
    fflush(status->fp);
  }
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parNr=6;
  ret=nloptAllocate(&nlo, parNr);
  if(ret!=TPCERROR_OK) {nloptFree(&nlo); return(21);}
  /* set initial parameters */
  nlo.xfull[0]=0.91;
  nlo.xfull[1]=1.11;
  nlo.xfull[2]=0.95;
  nlo.xfull[3]=1.05;
  nlo.xfull[4]=0.99;
  nlo.xfull[5]=1.15;
  for(int i=0; i<6; i++) {
    nlo.xlower[i]=-100.0; nlo.xupper[i]=100.0; 
    nlo.xtol[i]=1.0E-05; nlo.xdelta[i]=1.0E-02;
  }
  /* set object function */
  nlo._fun=nloptDejong2;
  /* Optimize */
  nlo.maxFunCalls=50000;
  ret=nloptMPSO(&nlo, 1500, 0, 25, 0.333, 1.0, 1.6, 0.4, 0.005, 0.25, 1, status);
  if(verbose>2) fprintf(status->fp, "  -> ret := %d\n", ret);
  if(verbose>3) fprintf(status->fp, "  -> function_calls := %d\n", nlo.funCalls);
  if(ret!=TPCERROR_OK) {
    fprintf(stderr, "Error in %s.\n", __func__);
    statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_FAIL);
    if(status->fp!=NULL && status->fp!=stdout && status->fp!=stderr) fclose(status->fp);
    status->fp=stdout;
    nloptFree(&nlo); return(22);
  }
  if(verbose>2) for(int i=0; i<parNr; i++) fprintf(status->fp, "  x[%d] := %g\n", i, nlo.xfull[i]);
  /* Check optimized parameters */
  ret=0;
  for(int i=0; i<parNr; i++) {
    e=fabs(nlo.xfull[i]-1.0);
    if(e>5.0E-03) {
      ret++; if(verbose>2) fprintf(status->fp, "  |x[%d]-true|=%g\n", i, e); fflush(status->fp);
    }
  }
  if(ret>0) {
    fprintf(stderr, "%s did not converge to correct minimum.\n", __func__);
    statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_FAIL);
    if(status->fp!=NULL && status->fp!=stdout && status->fp!=stderr) fclose(status->fp);
    status->fp=stdout;
    nloptFree(&nlo); return(23);
  }
  nloptFree(&nlo);




  if(verbose>1) {
    fprintf(status->fp, "\n --------------------------------------------------- \n");
    fprintf(status->fp, "\n Test bi-exponential curve fitting \n");
    fflush(status->fp);
  }
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  {
    NLOPT_DATA data; nloptdataInit(&data);
    data.n=20;
    double buf[4*data.n]; data.x=buf; data.y=buf+data.n; data.w=buf+2*data.n; data.sy=buf+3*data.n;
    int parNr=4; double p[parNr]; p[0]=80.0; p[1]=0.2; p[2]=20.0; p[3]=0.02;
    for(unsigned int i=0; i<data.n; i++) {
      data.x[i]=(double)(1+i); 
      data.y[i]=p[0]*exp(-p[1]*data.x[i]) + p[2]*exp(-p[3]*data.x[i]);
      data.w[i]=1.0;
    }

    NLOPT nlo; nloptInit(&nlo);
    if(nloptAllocate(&nlo, parNr)!=TPCERROR_OK) {nloptFree(&nlo); return(100);}

    if(verbose>1) {
      fprintf(status->fp, "\n Level: easy; limits force into single optimum \n");
      fflush(status->fp);
    }
    /* set initial parameters */
    nlo.xfull[0]=nan("");  nlo.xlower[0]=60.0;  nlo.xupper[0]=100.0; nlo.xtol[0]=0.01;
    nlo.xfull[1]=nan("");  nlo.xlower[1]=0.1;  nlo.xupper[1]=1.0;   nlo.xtol[1]=0.001;
    nlo.xfull[2]=nan("");  nlo.xlower[2]=5.0;  nlo.xupper[2]=40.0; nlo.xtol[2]=0.01;
    nlo.xfull[3]=nan("");  nlo.xlower[3]=0.0;  nlo.xupper[3]=0.1;   nlo.xtol[3]=0.001;
/*    nlo.xfull[0]=80.0;
    nlo.xfull[1]=0.2;
    nlo.xfull[2]=20.0;
    nlo.xfull[3]=0.01; */

    nlo._fun=nloptBiexp; nlo.fundata=&data; nlo.maxFunCalls=100000;
    if(verbose>100) {data.verbose=verbose-100; data.fp=stdout;}
    if(verbose>4) {
      fprintf(status->fp, "  correct_wss := %g\n", nlo._fun(parNr, p, nlo.fundata));
      fprintf(status->fp, "  initial_point_wss := %g\n", nlo._fun(parNr, nlo.xfull, nlo.fundata));
      fflush(status->fp);
    }
    ret=nloptMPSO(&nlo, 2000, 4, 16, 0.333, 1.0, 1.45, 0.2, 0.0, 0.0, 1, status);
    if(verbose>2) fprintf(status->fp, "  -> ret := %d\n", ret);
    if(verbose>3) fprintf(status->fp, "  -> function_calls := %d\n", nlo.funCalls);
    if(ret!=TPCERROR_OK) {
      if(status->fp!=NULL && status->fp!=stdout && status->fp!=stderr) fclose(status->fp);
      status->fp=stdout; nloptFree(&nlo); return(101);
    }
    if(verbose>2) for(int i=0; i<parNr; i++) fprintf(status->fp, "  x[%d] := %e\n", i, nlo.xfull[i]);
    /* Check optimized parameters */
    ret=0;
    if(nlo.xfull[0]>nlo.xfull[2]) {
      for(int i=0; i<parNr; i++) {
        e=fabs(nlo.xfull[i]-p[i]);
        if(e>nlo.xtol[i]) {
          ret++; 
          if(verbose>2) {fprintf(status->fp, "  |x-true|=%e\n", e); fflush(status->fp);}
        }
      }
    } else {
      int i;
      for(i=0; i<2; i++) {
        e=fabs(nlo.xfull[i]-p[i+2]);
        if(e>nlo.xtol[i]) {
          ret++; 
          if(verbose>2) {fprintf(status->fp, "  |x-true|=%e\n", e); fflush(status->fp);}
        }
      }
      for(; i<parNr; i++) {
        e=fabs(nlo.xfull[i]-p[i-2]);
        if(e>nlo.xtol[i]) {
          ret++; 
          if(verbose>2) {fprintf(status->fp, "  |x-true|=%e\n", e); fflush(status->fp);}
        }
      }
    }
    if(ret>0) {
      fprintf(stderr, "%s did not converge to correct minimum.\n", __func__);
      statusSet(status, __func__, __FILE__, __LINE__, TPCERROR_FAIL);
      if(status->fp!=NULL && status->fp!=stdout && status->fp!=stderr) fclose(status->fp);
      status->fp=stdout;
      nloptFree(&nlo); return(102);
    }

    nloptFree(&nlo);
  }



  if(status->fp!=NULL && status->fp!=stdout && status->fp!=stderr) fclose(status->fp);
  status->fp=stdout;

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
