/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcstatist.h"
#include "test_tpcnlopt.h"
/*****************************************************************************/

/*****************************************************************************/
int test_nloptRandomPoint(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i, ret;
  double p[100], low[100], up[100];

  if(verbose>1) printf("\ncalling function with empty input\n");
  ret=nloptRandomPoint(NULL, NULL, NULL, 10, NULL);
  if(ret==0) return(1);
  if(verbose>2) printf("  -> error returned, which is good\n");
  ret=nloptRandomPoint(p, low, up, 0, NULL);
  if(ret!=0) return(2);
  if(verbose>2) printf("  -> error not returned, which is good\n");

  if(verbose>1) printf("\nnormal input\n");
  i=0; low[i]=0.0; up[i]=10.0;
  i=1; low[i]=0.0; up[i]=0.0;
  i=2; low[i]=10.0; up[i]=10.0;
  i=3; low[i]=-10.0; up[i]=0.0;
  i=4; low[i]=1.0E-06; up[i]=2.0E-06;
  ret=nloptRandomPoint(p, low, up, 5, NULL);
  if(ret!=0) return(10);
  for(i=0; i<5; i++) if(p[i]<low[i] || p[i]>up[i]) return(11);
  if(verbose>2) printf("  -> ok\n");

  if(verbose>1) printf("\n same with MERTWI\n");
  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());
  ret=nloptRandomPoint(p, low, up, 5, &mt);
  if(ret!=0) return(20);
  for(i=0; i<5; i++) if(p[i]<low[i] || p[i]>up[i]) return(21);
  if(verbose>2) printf("  -> ok\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_nloptGaussianPoint(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int pn=100;
  double p[100], mean[100], sd[100], low[100], up[100];

  if(verbose>1) printf("\ncalling function with empty input\n");
  if(nloptGaussianPoint(NULL, NULL, NULL, NULL, NULL, 10, NULL) == 0) return(1);
  if(verbose>2) printf("  -> error returned, which is good\n");
  if(nloptGaussianPoint(p, mean, sd, low, up, 0, NULL) != 0) return(2);
  if(verbose>2) printf("  -> error not returned, which is good\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) printf("\nTesting the distribution\n");
  double meanp, sdp;
  unsigned int n;
  for(unsigned int i=0; i<pn; i++) {
    mean[i]=100.0;
    sd[i]=5.0;
    low[i]=-1000.0;
    up[i]=1000.0;
  }
  if(nloptGaussianPoint(p, mean, sd, NULL, NULL, pn, NULL)!=0) return(10);
  if(statMeanSD(p, pn, &meanp, &sdp, &n)!=0) return(11);
  if(n!=pn) return(12);
  if(verbose>2) printf("  mean=%g sd=%g\n", meanp, sdp);
  if(!doubleMatch(100.0, meanp, 2.5)) return(13);
  if(!doubleMatch(5.0, sdp, 2.5)) return(14);

  for(unsigned int i=0; i<pn; i++) {
    mean[i]=-10.0;
    sd[i]=20.0;
    low[i]=-1000.0;
    up[i]=1000.0;
  }
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, NULL)!=0) return(20);
  if(statMeanSD(p, pn, &meanp, &sdp, &n)!=0) return(21);
  if(n!=pn) return(22);
  if(verbose>2) printf("  mean=%g sd=%g\n", meanp, sdp);
  if(!doubleMatch(-10.0, meanp, 7.5)) return(23);
  if(!doubleMatch(20.0, sdp, 7.5)) return(24);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) printf("\nTesting the limits\n");
  double minp, maxp;
  for(unsigned int i=0; i<pn; i++) {
    mean[i]=100.0;
    sd[i]=5.0;
    low[i]=98.0;
    up[i]=102.0;
  }
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, NULL)!=0) return(30);
  if(doubleRange(p, pn, &minp, &maxp)!=pn) return(31);
  if(verbose>2) printf("  min=%g max=%g\n", minp, maxp);
  if(!doubleMatch(98.0, minp, 0.5)) return(32);
  if(!doubleMatch(102.0, maxp, 0.5)) return(33);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) printf("\nTesting the lists\n");
  pn=2;
  mean[0]=100.0; sd[0]=10.0; low[0]=99.0; up[0]=101.0;
  mean[1]=0.0; sd[1]=10.0; low[1]=-10.0; up[1]=10.0;
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, NULL)!=0) return(40);
  if(p[0]<low[0] || p[0]>up[0]) return(41);
  if(p[1]<low[1] || p[1]>up[1]) return(42);
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, NULL)!=0) return(43);
  if(p[0]<low[0] || p[0]>up[0]) return(44);
  if(p[1]<low[1] || p[1]>up[1]) return(45);
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, NULL)!=0) return(46);
  if(p[0]<low[0] || p[0]>up[0]) return(47);
  if(p[1]<low[1] || p[1]>up[1]) return(48);

  statusSet(status, __func__, __FILE__, __LINE__, 0);



  if(verbose>1) printf("\n The same with MERTWI\n");

  MERTWI mt; mertwiInit(&mt); mertwiInitWithSeed64(&mt, mertwiSeed64());

  if(verbose>1) printf("\nTesting the distribution\n");
  pn=100;
  for(unsigned int i=0; i<pn; i++) {
    mean[i]=100.0;
    sd[i]=5.0;
    low[i]=-1000.0;
    up[i]=1000.0;
  }
  if(nloptGaussianPoint(p, mean, sd, NULL, NULL, pn, &mt)!=0) return(110);
  if(statMeanSD(p, pn, &meanp, &sdp, &n)!=0) return(111);
  if(n!=pn) return(12);
  if(verbose>2) printf("  mean=%g sd=%g\n", meanp, sdp);
  if(!doubleMatch(100.0, meanp, 2.5)) return(113);
  if(!doubleMatch(5.0, sdp, 2.5)) return(114);

  for(unsigned int i=0; i<pn; i++) {
    mean[i]=-10.0;
    sd[i]=20.0;
    low[i]=-1000.0;
    up[i]=1000.0;
  }
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, &mt)!=0) return(120);
  if(statMeanSD(p, pn, &meanp, &sdp, &n)!=0) return(121);
  if(n!=pn) return(122);
  if(verbose>2) printf("  mean=%g sd=%g\n", meanp, sdp);
  if(!doubleMatch(-10.0, meanp, 7.5)) return(123);
  if(!doubleMatch(20.0, sdp, 7.5)) return(124);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) printf("\nTesting the limits\n");
  for(unsigned int i=0; i<pn; i++) {
    mean[i]=100.0;
    sd[i]=5.0;
    low[i]=98.0;
    up[i]=102.0;
  }
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, &mt)!=0) return(130);
  if(doubleRange(p, pn, &minp, &maxp)!=pn) return(131);
  if(verbose>2) printf("  min=%g max=%g\n", minp, maxp);
  if(!doubleMatch(98.0, minp, 0.5)) return(132);
  if(!doubleMatch(102.0, maxp, 0.5)) return(133);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) printf("\nTesting the lists\n");
  pn=2;
  mean[0]=100.0; sd[0]=10.0; low[0]=99.0; up[0]=101.0;
  mean[1]=0.0; sd[1]=10.0; low[1]=-10.0; up[1]=10.0;
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, &mt)!=0) return(140);
  if(p[0]<low[0] || p[0]>up[0]) return(141);
  if(p[1]<low[1] || p[1]>up[1]) return(142);
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, &mt)!=0) return(143);
  if(p[0]<low[0] || p[0]>up[0]) return(144);
  if(p[1]<low[1] || p[1]>up[1]) return(145);
  if(nloptGaussianPoint(p, mean, sd, low, up, pn, &mt)!=0) return(146);
  if(p[0]<low[0] || p[0]>up[0]) return(147);
  if(p[1]<low[1] || p[1]>up[1]) return(148);


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
