/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  parInit(NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  PAR par;
  parInit(&par);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parrInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  parrInit(NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  PARR parr;
  parrInit(&parr);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parnInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  parnInit(NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  PARN parn;
  parnInit(&parn);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  parFree(NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  PAR par;
  parInit(&par); parFree(&par);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parrFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  parrFree(NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  PARR parr;
  parrInit(&parr); parrFree(&parr);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parrAllocate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  PARR parr;
  parrInit(&parr);
  ret=parrAllocate(&parr, 0);
  if(ret!=TPCERROR_OK) return 1;
  ret=parrAllocate(&parr, 10);
  if(ret!=TPCERROR_OK) {parrFree(&parr); return 2;}
  parrFree(&parr);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parAllocate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  PAR par;
  parInit(&par);
  ret=parAllocate(&par, 0, 0);
  if(ret!=TPCERROR_OK) return 1;
  ret=parAllocate(&par, 1, 0);
  if(ret==TPCERROR_OK) return 2;
  ret=parAllocate(&par, 5, 10);
  if(ret!=TPCERROR_OK) {parFree(&par); return 3;}
  if(par._parNr!=5 || par._tacNr!=10) {parFree(&par); return 4;}
  parFree(&par);
  if(verbose>1) printf("did not segfault, that is good.\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  parFree(&par);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parAllocateMore(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  PAR par; parInit(&par);
  if(verbose>1) printf("testing with empty data\n");
  ret=parAllocateMore(&par, 0, 0); if(ret==TPCERROR_OK) return 1;
  ret=parAllocateMore(&par, 1, 0); if(ret==TPCERROR_OK) return 2;

  if(verbose>1) printf("reallocating not necessary\n");
  ret=parAllocate(&par, 2, 5); if(ret!=TPCERROR_OK) {parFree(&par); return 3;}
  if(par._parNr!=2 || par._tacNr!=5) {parFree(&par); return 4;}
  ret=parAllocateMore(&par, 0, 0); 
  if(ret!=TPCERROR_OK) {parFree(&par); return 5;}
  ret=parAllocateMore(&par, 2, 5);
  if(ret!=TPCERROR_OK) {parFree(&par); return 6;}
  if(par._parNr!=2 || par._tacNr!=5) {parFree(&par); return 7;}

  if(verbose>1) printf("reallocating not necessary, not even now\n");
  par.parNr=1; par.tacNr=2;
  ret=parAllocateMore(&par, 1, 3);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  if(par._parNr!=2 || par._tacNr!=5) {parFree(&par); return 12;}
  if(par.parNr!=1 || par.tacNr!=2) {parFree(&par); return 13;}

  if(verbose>1) printf("reallocating is necessary\n");
  par.parNr=2; par.tacNr=5;
  ret=parAllocateMore(&par, 2, 5);
  if(ret!=TPCERROR_OK) {parFree(&par); return 21;}
  if(par._parNr!=4 || par._tacNr!=10) {parFree(&par); return 22;}
  if(verbose>1) printf("memory can be freed\n");
  parFree(&par);
  if(verbose>1) printf("did not segfault, that is good.\n");

  if(verbose>1) printf("struct can be reused\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 31;}
  parFree(&par);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parEnsureNames(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("testing with NULL pointer.\n");
  parEnsureNames((PAR*)NULL);
  if(verbose>2) printf("no crash, that is good.\n");

  int ret;
  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  ret=parAllocate(&par, 0, 0); if(ret!=TPCERROR_OK) return 2;
  parEnsureNames(&par);
  if(verbose>2) printf("no crash, that is good.\n");
  parFree(&par);

  if(verbose>1) printf("trying with some data\n");
  ret=parAllocate(&par, 3, 2); if(ret!=TPCERROR_OK) return 3;
  par.tacNr=par._tacNr; par.parNr=par._parNr;
  parEnsureNames(&par);
  if(strcmp(par.r[0].name, "1")!=0) {parFree(&par); return 4;}
  if(strcmp(par.r[1].name, "2")!=0) {parFree(&par); return 5;}
  if(verbose>2) printf("ok\n");

  strcpy(par.r[0].name, ".");
  parEnsureNames(&par);
  if(strcmp(par.r[0].name, "1")!=0) {parFree(&par); return 6;}
  if(strcmp(par.r[1].name, "2")!=0) {parFree(&par); return 7;}

  strcpy(par.n[1].name, "");
  parEnsureNames(&par);
  if(strcmp(par.n[1].name, "P2")!=0) {parFree(&par); return 11;}

  parFree(&par);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parIsWSS(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=parIsWSS((PAR*)NULL);
  if(ret!=0) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  ret=parIsWSS((PAR*)NULL);
  if(ret!=0) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  ret=parIsWSS(&par);
  if(ret==0) {parFree(&par); return 12;}

  if(verbose>1) printf("trying with test data\n");
  for(int i=0; i<par.tacNr; i++) par.r[i].wss=nan("");
  ret=parIsWSS(&par);
  if(ret!=0) {parFree(&par); return 21;}

  parFree(&par);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parIsFitRange(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=parIsFitRange((PAR*)NULL);
  if(ret!=0) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  ret=parIsFitRange((PAR*)NULL);
  if(ret!=0) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  ret=parIsFitRange(&par);
  if(ret!=1) {parFree(&par); return 12;}

  if(verbose>1) printf("trying with test data\n");
  for(int i=0; i<par.tacNr; i++) par.r[i].start=par.r[i].end=nan("");
  ret=parIsFitRange(&par);
  if(ret!=0) {parFree(&par); return 21;}

  if(verbose>1) printf("trying with test data\n");
  for(int i=0; i<par.tacNr; i++) {par.r[i].start=0.02; par.r[i].end=90.5;}
  par.r[1].end=82.5;
  ret=parIsFitRange(&par);
  if(ret!=2) {parFree(&par); return 31;}

  if(verbose>1) printf("trying with test data\n");
  for(int i=0; i<par.tacNr; i++) {par.r[i].start=0.02; par.r[i].end=90.5;}
  par.r[1].end=nan("");
  ret=parIsFitRange(&par);
  if(ret!=2) {parFree(&par); return 32;}

  parFree(&par);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parIsModel(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=parIsModel((PAR*)NULL);
  if(ret!=0) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  ret=parIsModel((PAR*)NULL);
  if(ret!=0) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  ret=parIsModel(&par);
  if(ret!=0) {parFree(&par); return 12;}

  if(verbose>1) printf("trying with test data\n");
  for(int i=0; i<par.tacNr; i++) par.r[i].model=303;
  ret=parIsModel(&par);
  if(ret!=1) {parFree(&par); return 21;}

  if(verbose>1) printf("trying with test data\n");
  par.r[1].model=302;
  ret=parIsModel(&par);
  if(ret!=2) {parFree(&par); return 22;}

  parFree(&par);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parSDWithPar(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=parSDWithPar((PAR*)NULL, 0);
  if(ret!=0) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  ret=parSDWithPar((PAR*)NULL, 0);
  if(ret!=0) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}

  if(verbose>200) for(int pi=0; pi<par.parNr; pi++)
    for(int ri=0; ri<par.tacNr; ri++)
      printf("pi=%d ri=%d sd=%g\n", pi, ri, par.r[ri].sd[pi]);

  ret=parSDWithPar(&par, 0);
  if(ret!=0) {parFree(&par); return 12;}
  ret=parSDWithPar(&par, 1);
  if(ret==0) {parFree(&par); return 13;}
  ret=parSDWithPar(&par, 2);
  if(ret==0) {parFree(&par); return 14;}
  ret=parSDWithPar(&par, 3);
  if(ret==0) {parFree(&par); return 15;}
  ret=parSDWithPar(&par, 4);
  if(ret!=0) {parFree(&par); return 16;}

  parFree(&par);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parCLWithPar(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=parCLWithPar((PAR*)NULL, 0);
  if(ret!=0) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  ret=parCLWithPar((PAR*)NULL, 0);
  if(ret!=0) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}

  if(verbose>200) for(int pi=0; pi<par.parNr; pi++)
    for(int ri=0; ri<par.tacNr; ri++)
      printf("pi=%d ri=%d cl1=%g cl2=%g\n", pi, ri,
             par.r[ri].cl1[pi], par.r[ri].cl2[pi]);

  ret=parCLWithPar(&par, 0);
  if(ret==0) {parFree(&par); return 12;}
  ret=parCLWithPar(&par, 1);
  if(ret!=0) {parFree(&par); return 13;}
  ret=parCLWithPar(&par, 2);
  if(ret==0) {parFree(&par); return 14;}
  ret=parCLWithPar(&par, 3);
  if(ret==0) {parFree(&par); return 15;}
  ret=parCLWithPar(&par, 4);
  if(ret!=0) {parFree(&par); return 16;}

  parFree(&par);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parIsFitNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=parIsFitNr((PAR*)NULL);
  if(ret!=0) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  ret=parIsFitNr((PAR*)NULL);
  if(ret!=0) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  ret=parIsFitNr(&par);
  if(ret!=1) {parFree(&par); return 12;}

  if(verbose>1) printf("trying with test data\n");
  par.r[1].fitNr=1;
  ret=parIsFitNr(&par);
  if(ret!=2) {parFree(&par); return 21;}

  if(verbose>1) printf("trying with test data\n");
  for(int i=0; i<par.tacNr; i++) par.r[i].fitNr=0;
  ret=parIsFitNr(&par);
  if(ret!=0) {parFree(&par); return 22;}

  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parIsDataNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=parIsDataNr((PAR*)NULL);
  if(ret!=0) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  ret=parIsDataNr((PAR*)NULL);
  if(ret!=0) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  ret=parIsDataNr(&par);
  if(ret!=1) {parFree(&par); return 12;}

  if(verbose>1) printf("trying with test data\n");
  par.r[1].dataNr=100;
  ret=parIsDataNr(&par);
  if(ret!=2) {parFree(&par); return 21;}

  if(verbose>1) printf("trying with test data\n");
  for(int i=0; i<par.tacNr; i++) par.r[i].dataNr=0;
  ret=parIsDataNr(&par);
  if(ret!=0) {parFree(&par); return 22;}

  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parIsOptcrit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;
  int ret;

  if(verbose>1) printf("testing with NULL pointer.\n");
  cptr=parIsOptcrit((PAR*)NULL);
  if(cptr!=NULL) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  cptr=parIsOptcrit((PAR*)NULL);
  if(cptr) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par); if(ret!=TPCERROR_OK) {parFree(&par); return 11;}

  cptr=parIsOptcrit(&par);
  if(cptr!=NULL) {parFree(&par); return 12;}

  iftPut(&par.h, "optimality_criterion", "OLS", 0, NULL);
  cptr=parIsOptcrit(&par);
  if(strcasecmp(cptr, "OLS")) {parFree(&par); return 13;}

  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parIsStudyNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  char *cptr;
  int ret;

  if(verbose>1) printf("testing with NULL pointer.\n");
  cptr=parIsStudyNr((PAR*)NULL);
  if(cptr!=NULL) return 1;
  if(verbose>2) printf("no crash, that is good.\n");

  PAR par; parInit(&par);

  if(verbose>1) printf("trying with zero data\n");
  cptr=parIsStudyNr((PAR*)NULL);
  if(cptr) {parFree(&par); return 2;}

  if(verbose>1) printf("trying with test data\n");
  ret=create_par(&par); if(ret!=TPCERROR_OK) {parFree(&par); return 11;}

  cptr=parIsStudyNr(&par);
  if(strcasecmp(cptr, "test0001")) {parFree(&par); return 12;}

  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parSetStudyNr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  PAR par; parInit(&par);
  char *cptr, s1[MAX_STUDYNR_LEN+1];

  if(verbose>1) printf("set studynr in empty header\n");
  strcpy(s1, "abc123");
  ret=parSetStudyNr(&par, s1);
  if(ret!=TPCERROR_OK) {parFree(&par); return 11;}
  cptr=parIsStudyNr(&par);
  if(strcmp(s1, cptr)!=0) {parFree(&par); return 12;}

  if(verbose>1) printf("delete studynr\n");
  strcpy(s1, "");
  ret=parSetStudyNr(&par, s1);
  if(ret!=TPCERROR_OK) {parFree(&par); return 21;}
  cptr=parIsStudyNr(&par);
  if(cptr!=NULL) {parFree(&par); return 22;}

  parFree(&par);

  if(verbose>1) printf("creating test data\n");
  ret=create_par(&par); if(ret!=TPCERROR_OK) {parFree(&par); return 31;}

  if(verbose>1) printf("replace existing studynr\n");
  strcpy(s1, "huhhuh");
  ret=parSetStudyNr(&par, s1);
  if(ret!=TPCERROR_OK) {parFree(&par); return 32;}
  cptr=parIsStudyNr(&par);
  if(strcmp(s1, cptr)!=0) {parFree(&par); return 33;}
  
  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parDeletePar(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  PAR par; parInit(&par);

  if(verbose>1) printf("trying with empty data\n");
  ret=parDeletePar(NULL, 0); if(ret==TPCERROR_OK) return(1);
  ret=parDeletePar(&par, 0); if(ret==TPCERROR_OK) return(2);

  ret=create_par(&par); if(ret!=TPCERROR_OK) {parFree(&par); return 10;}

  if(verbose>1) printf("trying with test data but invalid par index\n");
  ret=parDeletePar(&par, -1); if(ret==TPCERROR_OK) {parFree(&par); return(21);}
  ret=parDeletePar(&par, 9999); if(ret==TPCERROR_OK) {parFree(&par); return(22);}

  PAR par2; parInit(&par2);
  ret=create_par(&par2); 
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return 11;}

  if(verbose>1) printf("delete the first parameter\n");
  ret=parDeletePar(&par, 0); 
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(31);}
  if(par.parNr!=par2.parNr-1) {parFree(&par); parFree(&par2); return(32);}
  if(strcmp(par.n[1].name, par2.n[2].name)) {
    parFree(&par); parFree(&par2); return(33);}
  if(par.r[0].p[0]!=par2.r[0].p[1]) {
    parFree(&par); parFree(&par2); return(34);}
  if(par.r[1].p[1]!=par2.r[1].p[2]) {
    parFree(&par); parFree(&par2); return(35);}

  parFree(&par); parFree(&par2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parDeleteTAC(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  PAR par; parInit(&par);

  if(verbose>1) printf("trying with empty data\n");
  ret=parDeleteTAC(NULL, 0); if(ret==TPCERROR_OK) return(1);
  ret=parDeleteTAC(&par, 0); if(ret==TPCERROR_OK) return(2);

  ret=create_par(&par); if(ret!=TPCERROR_OK) {parFree(&par); return 10;}

  if(verbose>1) printf("trying with test data but invalid index\n");
  ret=parDeleteTAC(&par, -1); if(ret==TPCERROR_OK) {parFree(&par); return(21);}
  ret=parDeleteTAC(&par, 9999); if(ret==TPCERROR_OK) {parFree(&par); return(22);}

  PAR par2; parInit(&par2);
  ret=create_par(&par2); 
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return 11;}

  if(verbose>1) printf("delete the first TAC\n");
  ret=parDeleteTAC(&par, 0);
  if(ret!=TPCERROR_OK) {parFree(&par); parFree(&par2); return(31);}
  if(par.tacNr!=par2.tacNr-1) {parFree(&par); parFree(&par2); return(32);}
  if(strcmp(par.r[0].name, par2.r[1].name)) {
    parFree(&par); parFree(&par2); return(33);}
  if(par.r[0].p[0]!=par2.r[1].p[0]) {
    parFree(&par); parFree(&par2); return(34);}
  if(par.r[1].p[1]!=par2.r[2].p[1]) {
    parFree(&par); parFree(&par2); return(35);}

  parFree(&par); parFree(&par2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
/** Create basic test PAR data */
int create_par(
  PAR *par
) {
  int ret, pi, ri;
  
  /* Allocate memory */
  ret=parAllocate(par, 5, 3); if(ret!=TPCERROR_OK) return ret;
  par->tacNr=3; par->parNr=5;
  /* Set header fields */
  iftPut(&par->h, "studynr", "test0001", 1, NULL);
  iftPut(&par->h, "analysis_time", "2013-11-28 20:49:12", 1, NULL);
  iftPut(&par->h, "program", "libtpcpar (c) 2014", 1, NULL);
  iftPut(&par->h, "datafile","C:\\My Documents\\PETData\\imaginary.dat",1,NULL);
  iftPut(&par->h, "weighting", "no", 1, NULL);
  iftPut(&par->h, "unit", unitName(UNIT_KBQ_PER_ML), 1, NULL);
  iftPut(&par->h, "timeunit", unitName(UNIT_MIN), 1, NULL);
  /* Set parameter names */
  pi=0; strcpy(par->n[pi].name, "K1"); par->n[pi].unit=UNIT_ML_PER_ML_MIN;
  pi++; strcpy(par->n[pi].name, "K1/k2"); par->n[pi].unit=UNIT_UNITLESS;
  pi++; strcpy(par->n[pi].name, "k3"); par->n[pi].unit=UNIT_PER_MIN;
  pi++; strcpy(par->n[pi].name, "k4"); par->n[pi].unit=UNIT_PER_MIN;
  pi++; strcpy(par->n[pi].name, "Vb"); par->n[pi].unit=UNIT_PERCENTAGE;
  /* Set region names */
  for(ri=0; ri<par->tacNr; ri++) sprintf(par->r[ri].name, "roi%d", 1+ri);
  /* Set regional fit options */
  for(ri=0; ri<par->tacNr; ri++) {
    par->r[ri].fitNr=4;
    par->r[ri].dataNr=23;
    par->r[ri].start=0.0;
    par->r[ri].end=45.0;
    if(ri==0) par->r[ri].wss=8.7654E+002;
    else par->r[ri].wss=1.1*par->r[ri-1].wss;
  }
  /* Set parameter values */
  ri=0; 
  pi=0; par->r[ri].p[pi]=0.3;
  pi++; par->r[ri].p[pi]=0.5;
  pi++; par->r[ri].p[pi]=0.1;
  pi++; par->r[ri].p[pi]=0.005;
  pi++; par->r[ri].p[pi]=5.0;
  for(ri=1; ri<par->tacNr; ri++)
    for(pi=0; pi<par->parNr; pi++)
      par->r[ri].p[pi]=1.1*par->r[ri-1].p[pi];
  /* Set SDs and CLs for certain parameters */
  for(pi=0; pi<par->parNr-1; pi++) {
    for(ri=0; ri<par->tacNr; ri++) {
      if(pi>0) par->r[ri].sd[pi]=0.2*par->r[ri].p[pi];
      if(pi==0) {
        par->r[ri].cl1[pi]=0.9*par->r[ri].p[pi];
        par->r[ri].cl2[pi]=1.3*par->r[ri].p[pi];
      }
      if(pi==2 || pi==3) {
        par->r[ri].cl1[pi]=par->r[ri].p[pi]-par->r[ri].sd[pi];
        par->r[ri].cl2[pi]=par->r[ri].p[pi]+par->r[ri].sd[pi];
      }
    }
  }
  /* Set limits and tolerance for certain parameters */
  par->n[1].lim1=0.01;
  par->n[1].lim2=10.0;
  par->n[1].tol=0.001;
  par->n[2].lim1=0.0;
  par->n[2].lim2=5.0;
  par->n[3].tol=0.0001;
  
  return TPCERROR_OK;
}
/*****************************************************************************/

/*****************************************************************************/
/** Create IFT-PAR test data */
int create_par_ift(
  PAR *par
) {
  int ret, pi, ri;
  
  /* Allocate memory */
  ret=parAllocate(par, 2, 2); if(ret!=TPCERROR_OK) return ret;
  par->tacNr=2; par->parNr=2;
  /* Set header fields */
  iftPut(&par->h, "studynr", "test0002", 1, NULL);
  /* Set parameter names */
  pi=0; strcpy(par->n[pi].name, "Par1"); par->n[pi].unit=UNIT_PER_MIN;
  pi++; strcpy(par->n[pi].name, "Par2"); par->n[pi].unit=UNIT_UNITLESS;
  /* Set region names */
  for(ri=0; ri<par->tacNr; ri++) sprintf(par->r[ri].name, "roi%d", 1+ri);
  /* Set regional fit options */
  for(ri=0; ri<par->tacNr; ri++) {
    par->r[ri].fitNr=4;
    par->r[ri].dataNr=23;
    par->r[ri].start=30.0;
    par->r[ri].end=60.0;
    par->r[ri].wss=1000.0;
  }
  /* Set parameter values */
  ri=0; pi=0; par->r[ri].p[pi]=1;
  ri=0; pi=1; par->r[ri].p[pi]=2;
  ri=1; pi=0; par->r[ri].p[pi]=3;
  ri=1; pi=1; par->r[ri].p[pi]=4;
  
  return TPCERROR_OK;
}
/*****************************************************************************/

/*****************************************************************************/
#if(0)
/** Create PETPAR data for testing FIT struct */
int create_par_for_fit(
  PETPAR *par
) {
  int ret, pi, ri;
  
  /* Allocate memory */
  ret=parAllocate(par, 3); if(ret!=TACIO_OK) return ret;
  par->voiNr=3;
  /* Set header fields */
  par->time=time(NULL);
  strcpy(par->program, "libtpctacio");
  strcpy(par->datafile, "C:\\PETData\\imaginary.dat");
  par->weighting=WEIGHTING_UNKNOWN;
  par->cunit=CUNIT_KBQ_PER_ML;
  par->tunit=TUNIT_MIN;
  /* Set parameter names */
  par->parNr=4;
  for(pi=0; pi<par->parNr; pi++) sprintf(par->parname[pi], "p%d", pi+1);
  /* Set region names */
  for(ri=0; ri<par->voiNr; ri++) sprintf(par->voi[ri].id.name, "roi%d", 1+ri);
  /* Set regional fit options */
  for(ri=0; ri<par->voiNr; ri++) {
    par->voi[ri].dataNr=23;
    par->voi[ri].parNr=par->parNr;
    par->voi[ri].start=0.0;
    par->voi[ri].end=45.0;
    if(ri==0) par->voi[ri].wss=8.7654E+002;
    else par->voi[ri].wss=1.1*par->voi[ri-1].wss;
    /* Function id must be set */
    par->voi[ri].function=302;
  }
  /* Set parameter values */
  ri=0; 
  pi=0; par->voi[ri].p[pi]=0.3;
  pi++; par->voi[ri].p[pi]=0.5;
  pi++; par->voi[ri].p[pi]=0.1;
  pi++; par->voi[ri].p[pi]=0.005;
  for(ri=1; ri<par->voiNr; ri++)
    for(pi=0; pi<par->parNr; pi++)
      par->voi[ri].p[pi]=1.1*par->voi[ri-1].p[pi];
  
  return TACIO_OK;
}
/*****************************************************************************/

/*****************************************************************************/
/** Create PETPAR data for testing RES struct */
int create_par_for_res(
  PETPAR *par
) {
  int ret, pi, ri;
  
  /* Allocate memory */
  ret=parAllocate(par, 3); if(ret!=TACIO_OK) return ret;
  par->voiNr=3;
  par->parNr=5;
  /* Set header fields */
  strcpy(par->program, "libtpctacio");
  par->time=time(NULL);
  strcpy(par->studynr, "test0003");
  strcpy(par->datafile, "C:\\PETData\\imaginary.dat");
  strcpy(par->plasmafile, "C:\\PETData\\imaginary_ap.dat");
  strcpy(par->bloodfile, "C:\\PETData\\imaginary_ab.dat");
  par->weighting=WEIGHTING_ON;
  par->lc=1.0;
  par->Vb=5.0;
  /* Set parameter names */
  par->parNr=5;
  pi=0; strcpy(par->parname[pi], "K1"); par->parunit[pi]=CUNIT_ML_PER_ML_PER_MIN;
  pi++; strcpy(par->parname[pi], "K1/k2"); par->parunit[pi]=CUNIT_UNITLESS;
  pi++; strcpy(par->parname[pi], "k3"); par->parunit[pi]=CUNIT_PER_MIN;
  pi++; strcpy(par->parname[pi], "k4"); par->parunit[pi]=CUNIT_PER_MIN;
  pi++; strcpy(par->parname[pi], "Vb"); par->parunit[pi]=CUNIT_PERCENTAGE;
  /* Set region names */
  for(ri=0; ri<par->voiNr; ri++) sprintf(par->voi[ri].id.name, "roi%d", 1+ri);
  /* Set regional fit options */
  for(ri=0; ri<par->voiNr; ri++) {
    par->voi[ri].parNr=4;
    par->voi[ri].dataNr=23;
    par->voi[ri].start=0.0;
    par->voi[ri].end=45.0;
    if(ri==0) par->voi[ri].wss=8.7654E+002;
    else par->voi[ri].wss=1.1*par->voi[ri-1].wss;
  }
  /* Set parameter values */
  ri=0; 
  pi=0; par->voi[ri].p[pi]=0.3;
  pi++; par->voi[ri].p[pi]=0.5;
  pi++; par->voi[ri].p[pi]=0.1;
  pi++; par->voi[ri].p[pi]=0.005;
  pi++; par->voi[ri].p[pi]=5.0;
  for(ri=1; ri<par->voiNr; ri++)
    for(pi=0; pi<par->parNr; pi++)
      par->voi[ri].p[pi]=1.1*par->voi[ri-1].p[pi];
  /* Set SDs and CLs for certain parameters */
  for(pi=0; pi<par->parNr-1; pi++) {
    for(ri=0; ri<par->voiNr; ri++) {
      if(pi>0) par->voi[ri].sd[pi]=0.2*par->voi[ri].p[pi];
      if(pi==0) {
        par->voi[ri].cl1[pi]=0.9*par->voi[ri].p[pi];
        par->voi[ri].cl2[pi]=1.3*par->voi[ri].p[pi];
      }
      if(pi==2 || pi==3) {
        par->voi[ri].cl1[pi]=par->voi[ri].p[pi]-par->voi[ri].sd[pi];
        par->voi[ri].cl2[pi]=par->voi[ri].p[pi]+par->voi[ri].sd[pi];
      }
    }
  }
  
  return TACIO_OK;
}
#endif
/*****************************************************************************/

/*****************************************************************************/
