/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parPrintType(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i, ret;
  PAR par; parInit(&par);

  if(verbose>1) printf("test with NULL data\n");
  ret=parPrintType(NULL, 0); if(ret>=0) return(1);
  if(verbose>1) printf("test with empty data\n");
  ret=parPrintType(NULL, 0); if(ret>=0) return(2);

  if(verbose>1) printf("creating test data\n");
  if(create_par(&par)) {parFree(&par); return(10);}
  
  if(verbose>2) printf("testing the column types\n");
  if(verbose>3) parWriteCSV(&par, stdout, PAR_FORMAT_TSV_UK, 0, NULL);
  i=0; ret=parPrintType(&par, i);
  if(verbose>2) printf("%s\t%d\n", par.n[i].name, ret);
  if(ret!=1) {parFree(&par); return(21);}
  i++; ret=parPrintType(&par, i);
  if(verbose>2) printf("%s\t%d\n", par.n[i].name, ret);
  if(ret!=1) {parFree(&par); return(22);}
  i++; ret=parPrintType(&par, i);
  if(verbose>2) printf("%s\t%d\n", par.n[i].name, ret);
  if(ret!=1) {parFree(&par); return(23);}
  
  if(verbose>2) printf("testing the exp and int column types\n");
  for(i=0; i<par.tacNr; i++) {
    par.r[i].p[0]=(double)(i-1);
    par.r[i].p[1]*=1.0E+08;
    par.r[i].p[2]*=-1.0;
  }
  if(verbose>3) parWriteCSV(&par, stdout, PAR_FORMAT_TSV_UK, 0, NULL);
  i=0; ret=parPrintType(&par, i);
  if(verbose>2) printf("%s\t%d\n", par.n[i].name, ret);
  if(ret!=0) {parFree(&par); return(31);}
  i++; ret=parPrintType(&par, i);
  if(verbose>2) printf("%s\t%d\n", par.n[i].name, ret);
  if(ret!=2) {parFree(&par); return(32);}
  i++; ret=parPrintType(&par, i);
  if(verbose>2) printf("%s\t%d\n", par.n[i].name, ret);
  if(ret!=1) {parFree(&par); return(33);}

  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parWriteRES(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  PAR par; parInit(&par);
  char *fname="parWriteRES.res";
  FILE *fp;

  if(verbose>1) printf("test with NULL data\n");
  ret=parWriteRES(NULL, stdout, NULL); if(ret==0) return(1);
  if(verbose>1) printf("test with empty data\n");
  ret=parWriteRES(&par, stdout, NULL); if(ret==0) return(2);

  if(verbose>1) printf("creating test data\n");
  if(create_par(&par)) {parFree(&par); return(10);}

  if(verbose>1) printf("saving test data in '%s'\n", fname);
  fp=fopen(fname, "w"); if(fp==NULL) {parFree(&par); return(11);}
  ret=parWriteRES(&par, fp, status); fclose(fp); 
  if(ret!=0) {
    fprintf(stdout, "Error: %s\n", errorMsg(ret));
    parFree(&par); return(12);
  }

  /* What was written is tested in test_parReadRES() */

  parFree(&par);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parReadRES(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("  tested in parRead()\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
