/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcpar.h"
/*****************************************************************************/

/*****************************************************************************/
int test_parSelectTACs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  PAR par; parInit(&par);
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parSelectTACs(NULL, NULL, 0, status);
  if(n>0) {parFree(&par); return 1;}
  n=parSelectTACs(&par, NULL, 0, status);
  if(n>0) {parFree(&par); return 2;}
  n=parSelectTACs(&par, "meh", 0, status);
  if(n>0) {parFree(&par); return 3;}

  if(verbose>1) printf("create test data\n");
  ret=create_par(&par); if(ret!=0) {parFree(&par); return 9;}
  if(verbose>3) {
    for(int i=0; i<par.tacNr; i++) printf("  %d: '%s'\n", 1+i, par.r[i].name);
  }

  /* Select all */
  n=parSelectTACs(&par, NULL, 0, status);
  if(n!=par.tacNr) {parFree(&par); return 11;}
  if(n!=parSelectedTACs(&par)) {parFree(&par); return 12;}
  /* Deselect all */
  n=parSelectTACs(&par, "meh", 1, status);
  if(n!=0) {parFree(&par); return 13;}
  if(parSelectedTACs(&par)!=0) {parFree(&par); return 14;}
  
  /* Empty string should not select anything when names exist */
  n=parSelectTACs(&par, "", 0, status);
  if(n!=0) {parFree(&par); return 15;}

  /* Select one at a time */
  n=parSelectTACs(&par, "ROI3", 0, status);
  if(n!=1) {parFree(&par); return 21;}
  n=parSelectTACs(&par, "roi2", 0, status);
  if(n!=1) {parFree(&par); return 22;}
  if(parSelectedTACs(&par)!=2) {parFree(&par); return 23;}
  n=parSelectTACs(&par, "roi1", 0, status);
  if(n!=1) {parFree(&par); return 24;}
  if(parSelectedTACs(&par)!=3) {parFree(&par); return 25;}

  /* Select one, deselecting others */
  n=parSelectTACs(&par, "Roi2", 1, status);
  if(n!=1) {parFree(&par); return 31;}
  if(parSelectedTACs(&par)!=1) {parFree(&par); return 32;}

  /* Deselect all */
  n=parSelectTACs(&par, "meh", 1, status);
  if(parSelectedTACs(&par)!=0) {parFree(&par); return 41;}
  /* Empty one of names */
  strcpy(par.r[1].name, "");
  /* Now that one can be selected with "" */
  n=parSelectTACs(&par, "", 1, status);
  if(n!=1) {parFree(&par); return 42;}
  if(parSelectedTACs(&par)!=1) {parFree(&par); return 43;}

  /* Test with tac numbers */
  /* Deselect all */
  n=parSelectTACs(&par, "meh", 1, status);
  if(n!=0) {parFree(&par); return 51;}
  if(parSelectedTACs(&par)!=0) {parFree(&par); return 52;}
  /* Rename rois to not contain numbers */
  for(int ri=0; ri<par.tacNr; ri++) strcpy(par.r[ri].name, "name");
  /* Select 2nd TAC */
  n=parSelectTACs(&par, "'2'", 1, status);
  if(n!=1) {parFree(&par); return 53;}
  if(par.r[1].sw==0)  {parFree(&par); return 54;}
  /* Select 1st TAC */
  n=parSelectTACs(&par, "1", 1, status);
  if(n!=1) {parFree(&par); return 55;}
  if(par.r[0].sw==0)  {parFree(&par); return 56;}
  if(parSelectedTACs(&par)!=1) {parFree(&par); return 57;}
  /* Select 1st and 2nd TAC */
  n=parSelectTACs(&par, "1-2", 1, status);
  if(n!=2) {parFree(&par); return 58;}
  if(par.r[0].sw==0 || par.r[1].sw==0)  {parFree(&par); return 59;}
  if(parSelectedTACs(&par)!=2) {parFree(&par); return 60;}
  /* Select 3rd (last) TAC */
  n=parSelectTACs(&par, "3", 1, status);
  if(n!=1) {parFree(&par); return 61;}
  if(par.r[2].sw==0)  {parFree(&par); return 62;}
  if(parSelectedTACs(&par)!=1) {parFree(&par); return 63;}
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parSelectedTACs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("tested with test_parSelectTACs()\n");
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parSelectParameters(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  PAR par; parInit(&par);
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=parSelectParameters(NULL, NULL, 0, status);
  if(n>0) {parFree(&par); return 1;}
  n=parSelectParameters(&par, NULL, 0, status);
  if(n>0) {parFree(&par); return 2;}
  n=parSelectParameters(&par, "Meh", 0, status);
  if(n>0) {parFree(&par); return 3;}

  if(verbose>1) printf("create test data\n");
  ret=create_par(&par); if(ret!=0) {parFree(&par); return 9;}
  if(verbose>3) {
    for(int i=0; i<par.parNr; i++) printf("  %d: '%s'\n", 1+i, par.n[i].name);
  }

  /* Select all */
  n=parSelectParameters(&par, NULL, 0, status);
  if(n!=par.parNr) {parFree(&par); return 11;}
  if(n!=parSelectedParameters(&par)) {parFree(&par); return 12;}
  /* Deselect all */
  n=parSelectParameters(&par, "Meh", 1, status);
  if(n!=0) {parFree(&par); return 13;}
  if(parSelectedParameters(&par)!=0) {parFree(&par); return 14;}
  
  /* Empty string should not select anything when names exist */
  n=parSelectParameters(&par, "", 0, status);
  if(n!=0) {parFree(&par); return 15;}

  /* Select one at a time */
  n=parSelectParameters(&par, "Vb", 0, status);
  if(n!=1) {parFree(&par); return 21;}
  n=parSelectParameters(&par, "k4", 0, status);
  if(n!=1) {parFree(&par); return 22;}
  if(parSelectedParameters(&par)!=2) {parFree(&par); return 23;}
  n=parSelectParameters(&par, "k3", 0, status);
  if(n!=1) {parFree(&par); return 24;}
  n=parSelectParameters(&par, "K1", 0, status);
  if(n!=1) {parFree(&par); return 25;}
  if(parSelectedParameters(&par)!=4) {parFree(&par); return 26;}
  n=parSelectParameters(&par, "K1/k2", 0, status);
  if(n!=1) {parFree(&par); return 27;}
  if(parSelectedParameters(&par)!=5) {parFree(&par); return 28;}

  /* Select one, deselecting others */
  n=parSelectParameters(&par, "k3", 1, status);
  if(n!=1) {parFree(&par); return 31;}
  if(parSelectedParameters(&par)!=1) {parFree(&par); return 32;}

  /* Deselect all */
  n=parSelectParameters(&par, "Meh", 1, status);
  if(parSelectedParameters(&par)!=0) {parFree(&par); return 41;}
  /* Empty one of names */
  strcpy(par.n[1].name, "");
  /* Now that one can be selected with "" */
  n=parSelectParameters(&par, "", 1, status);
  if(n!=1) {parFree(&par); return 42;}
  if(parSelectedParameters(&par)!=1) {parFree(&par); return 43;}

  /* Test with parameter numbers */
  /* Deselect all */
  n=parSelectParameters(&par, "Meh", 1, status);
  if(n!=0) {parFree(&par); return 51;}
  if(parSelectedParameters(&par)!=0) {parFree(&par); return 52;}
  /* Rename rois to not contain numbers */
  for(int pi=0; pi<par.parNr; pi++) strcpy(par.n[pi].name, "name");
  /* Select 2nd parameter */
  n=parSelectParameters(&par, "'2'", 1, status);
  if(n!=1) {parFree(&par); return 53;}
  if(par.n[1].sw==0)  {parFree(&par); return 54;}
  /* Select 1st parameter */
  n=parSelectParameters(&par, "1", 1, status);
  if(n!=1) {parFree(&par); return 55;}
  if(par.n[0].sw==0)  {parFree(&par); return 56;}
  if(parSelectedParameters(&par)!=1) {parFree(&par); return 57;}
  /* Select 1st and 2nd parameter */
  n=parSelectParameters(&par, "1-2", 1, status);
  if(n!=2) {parFree(&par); return 58;}
  if(par.n[0].sw==0 || par.n[1].sw==0) {parFree(&par); return 59;}
  if(parSelectedParameters(&par)!=2) {parFree(&par); return 60;}
  /* Select 5th (last) parameter */
  n=parSelectParameters(&par, "5", 1, status);
  if(n!=1) {parFree(&par); return 61;}
  if(par.n[4].sw==0)  {parFree(&par); return 62;}
  if(parSelectedParameters(&par)!=1) {parFree(&par); return 63;}

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  parFree(&par);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parSelectedParameters(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  if(verbose>1) printf("tested with test_parSelectParameters()\n");
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parFindParameter(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int i;
  PAR par; parInit(&par);

  if(verbose>1) printf("should not crash with empty input\n");
  i=parFindParameter(NULL, NULL); if(i>=0) {parFree(&par); return 1;}
  i=parFindParameter(&par, NULL); if(i>=0) {parFree(&par); return 2;}
  i=parFindParameter(&par, "meh"); if(i>=0) {parFree(&par); return 3;}
  i=parFindParameter(&par, ""); if(i>=0) {parFree(&par); return 4;}

  if(verbose>1) printf("creating test data\n");
  if(create_par(&par)!=0) {parFree(&par); return 9;}
  if(verbose>3) {
    for(int i=0; i<par.parNr; i++) printf("  %d: '%s'\n", 1+i, par.n[i].name);
  }

  if(verbose>1) printf("should not crash with empty string\n");
  i=parFindParameter(&par, NULL); if(i>=0) {parFree(&par); return 11;}
  i=parFindParameter(&par, ""); if(i>=0) {parFree(&par); return 12;}

  char buf[64];

  strcpy(buf, "nonono");
  i=parFindParameter(&par, buf); if(verbose>1) printf("'%s' -> %d\n", buf, i);
  if(i>=0) {parFree(&par); return 21;}
  strcpy(buf, par.n[0].name);
  i=parFindParameter(&par, buf); if(verbose>1) printf("'%s' -> %d\n", buf, i);
  if(i!=0) {parFree(&par); return 22;}
  strcpy(buf, par.n[par.parNr-1].name);
  i=parFindParameter(&par, buf); if(verbose>1) printf("'%s' -> %d\n", buf, i);
  if(i!=par.parNr-1) {parFree(&par); return 23;}
  sprintf(buf, "%s'", par.n[0].name);
  i=parFindParameter(&par, buf); if(verbose>1) printf("'%s' -> %d\n", buf, i);
  if(i>=0) {parFree(&par); return 24;}
  sprintf(buf, "'%s'", par.n[0].name);
  i=parFindParameter(&par, buf); if(verbose>1) printf("'%s' -> %d\n", buf, i);
  if(i>=0) {parFree(&par); return 25;}

  strcpy(buf, "K3");
  i=parFindParameter(&par, buf); if(verbose>1) printf("'%s' -> %d\n", buf, i);
  if(i!=2) {parFree(&par); return 31;}

  if(verbose>1) printf("should be able to find empty name\n");
  strcpy(par.n[2].name, "");
  strcpy(buf, "");
  i=parFindParameter(&par, buf); if(verbose>1) printf("'%s' -> %d\n", buf, i);
  if(i!=2) {parFree(&par); return 41;}

  parFree(&par);
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parGetParameter(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  PAR par; parInit(&par);

  if(verbose>1) printf("should not crash with empty input\n");
  if(!isnan(parGetParameter(NULL, NULL, 0))) {parFree(&par); return 1;}
  if(!isnan(parGetParameter(&par, NULL, 0))) {parFree(&par); return 2;}
  if(!isnan(parGetParameter(&par, "meh", 0))) {parFree(&par); return 3;}
  if(!isnan(parGetParameter(&par, "", 0))) {parFree(&par); return 4;}

  if(verbose>1) printf("creating test data\n");
  if(create_par(&par)!=0) {parFree(&par); return 9;}
  if(verbose>3) {
    for(int i=0; i<par.parNr; i++) printf("  %d: '%s'\n", 1+i, par.n[i].name);
  }

  if(verbose>1) printf("should not crash with empty string\n");
  if(!isnan(parGetParameter(&par, NULL, 0))) {parFree(&par); return 11;}
  if(!isnan(parGetParameter(&par, "", 0))) {parFree(&par); return 12;}

  char buf[64];
  double v;

  strcpy(buf, "nonono");
  v=parGetParameter(&par, buf, 0); if(verbose>1) printf("'%s' -> %g\n", buf, v);
  if(!isnan(v)) {parFree(&par); return 21;}
  strcpy(buf, par.n[0].name);
  v=parGetParameter(&par, buf, 0); if(verbose>1) printf("'%s' -> %g\n", buf, v);
  if(v!=par.r[0].p[0]) {parFree(&par); return 22;}
  strcpy(buf, par.n[par.parNr-1].name);
  v=parGetParameter(&par, buf, 0); if(verbose>1) printf("'%s' -> %g\n", buf, v);
  if(v!=par.r[0].p[par.parNr-1]) {parFree(&par); return 23;}

  sprintf(buf, "%s'", par.n[0].name);
  v=parGetParameter(&par, buf, 0); if(verbose>1) printf("'%s' -> %g\n", buf, v);
  if(!isnan(v)) {parFree(&par); return 24;}
  sprintf(buf, "'%s'", par.n[0].name);
  v=parGetParameter(&par, buf, 0); if(verbose>1) printf("'%s' -> %g\n", buf, v);
  if(!isnan(v)) {parFree(&par); return 25;}


  strcpy(buf, "K3");
  v=parGetParameter(&par, buf, 1); if(verbose>1) printf("'%s' -> %g\n", buf, v);
  if(v!=par.r[1].p[2]) {parFree(&par); return 31;}

  if(verbose>1) printf("should be able to find empty name\n");
  strcpy(par.n[2].name, "");
  strcpy(buf, "");
  v=parGetParameter(&par, buf, 1); if(verbose>1) printf("'%s' -> %g\n", buf, v);
  if(v!=par.r[1].p[2]) {parFree(&par); return 41;}
  strcpy(par.n[2].name, "k3");

  if(verbose>1) printf("should return NaN if tac index is stupid\n");
  if(!isnan(parGetParameter(&par, "k3", -1))) {parFree(&par); return 51;}
  if(!isnan(parGetParameter(&par, "k3", par.parNr))) {parFree(&par); return 52;}

  parFree(&par);

  fflush(stderr);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parGetParameterUnit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  PAR par; parInit(&par);

  if(verbose>1) printf("should not crash with empty input\n");
  if(parGetParameterUnit(NULL, NULL)!=UNIT_UNKNOWN) {parFree(&par); return 1;}
  if(parGetParameterUnit(&par, NULL)!=UNIT_UNKNOWN) {parFree(&par); return 2;}
  if(parGetParameterUnit(&par, "meh")!=UNIT_UNKNOWN) {parFree(&par); return 3;}
  if(parGetParameterUnit(&par, "")!=UNIT_UNKNOWN) {parFree(&par); return 4;}

  if(verbose>1) printf("creating test data\n");
  if(create_par(&par)!=0) {parFree(&par); return 9;}
  if(1 || verbose>3) {
    for(int i=0; i<par.parNr; i++)
      printf("  %d: '%s' %s\n", 1+i, par.n[i].name, unitName(par.n[i].unit));
    fflush(stdout);
  }

  if(verbose>1) printf("should not crash with empty string\n");
  if(parGetParameterUnit(&par, NULL)!=UNIT_UNKNOWN) {parFree(&par); return 11;}
  if(parGetParameterUnit(&par, "")!=UNIT_UNKNOWN) {parFree(&par); return 12;}

  char buf[64];
  int u;

  strcpy(buf, "nonono");
  u=parGetParameterUnit(&par, buf); if(verbose>1) printf("'%s' -> %s\n", buf, unitName(u));
  if(u!=UNIT_UNKNOWN) {parFree(&par); return 21;}
  strcpy(buf, par.n[0].name);
  u=parGetParameterUnit(&par, buf); if(verbose>1) printf("'%s' -> %s\n", buf, unitName(u));
  if(u!=par.n[0].unit) {parFree(&par); return 22;}
  strcpy(buf, par.n[par.parNr-1].name);
  u=parGetParameterUnit(&par, buf); if(verbose>1) printf("'%s' -> %s\n", buf, unitName(u));
  if(u!=par.n[par.parNr-1].unit) {parFree(&par); return 23;}

  sprintf(buf, "%s'", par.n[0].name);
  u=parGetParameterUnit(&par, buf); if(verbose>1) printf("'%s' -> %s\n", buf, unitName(u));
  if(u!=UNIT_UNKNOWN) {parFree(&par); return 24;}
  sprintf(buf, "'%s'", par.n[0].name);
  u=parGetParameterUnit(&par, buf); if(verbose>1) printf("'%s' -> %s\n", buf, unitName(u));
  if(u!=UNIT_UNKNOWN) {parFree(&par); return 25;}


  strcpy(buf, "K3");
  u=parGetParameterUnit(&par, buf); if(verbose>1) printf("'%s' -> %s\n", buf, unitName(u));
  if(u!=par.n[2].unit) {parFree(&par); return 31;}

  if(verbose>1) printf("should be able to find empty name\n");
  strcpy(par.n[2].name, "");
  strcpy(buf, "");
  u=parGetParameterUnit(&par, buf); if(verbose>1) printf("'%s' -> %s\n", buf, unitName(u));
  if(u!=par.n[2].unit) {parFree(&par); return 41;}
  strcpy(par.n[2].name, "k3");

  parFree(&par);

  fflush(stderr);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parValueRange(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("should not crash with empty input\n");
  parValueRange(NULL, 0, NULL, NULL);

  if(verbose>1) printf("creating test data\n");
  PAR par; parInit(&par);
  if(create_par(&par)!=0) {parFree(&par); return 9;}

  int ret;

  if(verbose>1) printf("finding parameter ranges\n");
  double pmin, pmax;
  ret=0;
  for(int i=0; i<par.parNr; i++) {
    parValueRange(&par, i, &pmin, &pmax);
    if(verbose>3) printf("  %s: %g - %g\n", par.n[i].name, pmin, pmax);
    if(pmin>pmax) ret++;
  }
  if(ret>0) {parFree(&par); return 11;}

  parFree(&par);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
