/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcstatist.h"
#include "test_tpcrand.h"
/*****************************************************************************/

/*****************************************************************************/
int test_haltonElement(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(haltonElement(0, 0, NULL)==0) return(1);

  {
  int dim=1;
  double r[dim];
  if(verbose>2) printf("\n\tElement\tValues\n");
  for(int i=0; i<10; i++) {
    if(haltonElement(i, dim, r)!=0) return(10);
    if(verbose>2) {
      printf("\t%d", 1+i);
      for(int j=0; j<dim; j++) printf("\t%g", r[j]);
      printf("\n");
    }
  }
  }

  {
  int dim=3;
  double r[dim];
  double c[10][3] = { // correct results
    {0.50000000, 0.33333333, 0.20000000},
    {0.25000000, 0.66666667, 0.40000000},
    {0.75000000, 0.11111111, 0.60000000},
    {0.12500000, 0.44444444, 0.80000000},
    {0.62500000, 0.77777778, 0.04000000},
    {0.37500000, 0.22222222, 0.24000000},
    {0.87500000, 0.55555556, 0.44000000},
    {0.06250000, 0.88888889, 0.64000000},
    {0.56250000, 0.03703704, 0.84000000},
    {0.31250000, 0.37037037, 0.08000000}};
  if(verbose>2) printf("\n\tElement\tValues\n");
  for(int i=0; i<10; i++) {
    if(haltonElement(i, dim, r)!=0) return(10);
    if(verbose>2) {
      printf("\t%d", 1+i);
      for(int j=0; j<dim; j++) printf("\t%g", r[j]);
      printf("\n");
    }
    for(int j=0; j<dim; j++)
      if(!doubleMatch(c[i][j], r[j], 1.0E-08)) return(11);
  }
  }


  if(verbose>1) printf("ok\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_haltonPrime(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int iMax=haltonPrime(-1);
  if(iMax!=1600) return(1);

  if(haltonPrime(1+iMax)!=0) return(2);
  if(haltonPrime(iMax)!=13499) return(3);
  if(haltonPrime(0)!=1) return(4);

  if(verbose>1) printf("ok\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
