/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpcstatist.h"
/*****************************************************************************/

/*****************************************************************************/
int test_statSortInt(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, n;
  
  if(verbose>1) printf("empty data:\n");
  statSortInt(NULL, 0, 0);
  if(verbose>1) printf("did not segfault, that is good.\n");
  statSortInt(NULL, 10, 1);
  if(verbose>1) printf("did not segfault, that is good.\n");
  
  {
    n=20;
    int data[n];
    
    if(verbose>1) printf("all data is zeroes:\n");
    for(i=0; i<n; i++) data[i]=0;
    statSortInt(data, n, 0);
    for(i=0; i<n; i++) if(data[i]!=0) return 11;
  }

  {
    n=13;
    int data[n];
    for(i=0; i<n; i++) data[i]=(int)i-5;
    if(verbose>3) {
      printf("data: %d", data[0]);
      for(i=1; i<n; i++) printf(", %d", data[i]);
      printf("\n");
    }
    
    if(verbose>1) printf("sort in descending order:\n");
    statSortInt(data, n, 1);
    if(verbose>3) {
      printf("-> %d", data[0]);
      for(i=1; i<n; i++) printf(", %d", data[i]);
      printf("\n");
    }
    if(data[0]<data[n-1]) return 21;

    if(verbose>1) printf("sort in ascending order:\n");
    statSortInt(data, n, 0);
    if(verbose>3) {
      printf("-> %d", data[0]);
      for(i=1; i<n; i++) printf(", %d", data[i]);
      printf("\n");
    }
    if(data[0]>data[n-1]) return 22;
    for(i=0; i<n; i++) if(data[i]!=(int)i-5) return 23;
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_statSortUnsigned(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, n;
  
  if(verbose>1) printf("empty data:\n");
  statSortUnsigned(NULL, 0, 0);
  if(verbose>1) printf("did not segfault, that is good.\n");
  statSortUnsigned(NULL, 10, 1);
  if(verbose>1) printf("did not segfault, that is good.\n");
  
  {
    n=20;
    unsigned int data[n];
    
    if(verbose>1) printf("all data is zeroes:\n");
    for(i=0; i<n; i++) data[i]=0;
    statSortUnsigned(data, n, 0);
    for(i=0; i<n; i++) if(data[i]!=0) return 11;
  }

  {
    n=13;
    unsigned int data[n];
    for(i=0; i<n; i++) data[i]=i+5;
    if(verbose>3) {
      printf("data: %d", data[0]);
      for(i=1; i<n; i++) printf(", %d", data[i]);
      printf("\n");
    }
    
    if(verbose>1) printf("sort in descending order:\n");
    statSortUnsigned(data, n, 1);
    if(verbose>3) {
      printf("-> %d", data[0]);
      for(i=1; i<n; i++) printf(", %d", data[i]);
      printf("\n");
    }
    if(data[0]<data[n-1]) return 21;

    if(verbose>1) printf("sort in ascending order:\n");
    statSortUnsigned(data, n, 0);
    if(verbose>3) {
      printf("-> %d", data[0]);
      for(i=1; i<n; i++) printf(", %d", data[i]);
      printf("\n");
    }
    if(data[0]>data[n-1]) return 22;
    for(i=0; i<n; i++) if(data[i]!=i+5) return 23;
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_statSortDouble(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  unsigned int i, n;
  
  if(verbose>1) printf("empty data:\n");
  statSortDouble(NULL, 0, 0);
  if(verbose>1) printf("did not segfault, that is good.\n");
  statSortDouble(NULL, 10, 1);
  if(verbose>1) printf("did not segfault, that is good.\n");
  
  {
    n=20;
    double data[n];
    
    if(verbose>1) printf("all data is zeroes:\n");
    for(i=0; i<n; i++) data[i]=0.0;
    statSortDouble(data, n, 0);
    for(i=0; i<n; i++) if(data[i]!=0.0) return 11;
  }

  {
    n=13;
    double data[n];
    for(i=0; i<n; i++) data[i]=(double)i-3.21;
    if(verbose>3) {
      printf("data: %g", data[0]);
      for(i=1; i<n; i++) printf(", %g", data[i]);
      printf("\n");
    }
    
    if(verbose>1) printf("sort in descending order:\n");
    statSortDouble(data, n, 1);
    if(verbose>3) {
      printf("-> %g", data[0]);
      for(i=1; i<n; i++) printf(", %g", data[i]);
      printf("\n");
    }
    if(data[0]<data[n-1]) return 21;

    if(verbose>1) printf("sort in ascending order:\n");
    statSortDouble(data, n, 0);
    if(verbose>3) {
      printf("-> %g", data[0]);
      for(i=1; i<n; i++) printf(", %g", data[i]);
      printf("\n");
    }
    if(data[0]>data[n-1]) return 22;
    for(i=0; i<n; i++) 
      if(!doubleMatch(data[i], (double)i-3.21, 1.0E-12)) return 23;
  }

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
