/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacRead4DM(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\ncalling function with stupid input\n");
  ret=tacRead4DM(NULL, NULL, NULL);
  if(ret!=TPCERROR_FAIL) return(1);

  TAC tac; tacInit(&tac);
  ret=tacRead4DM(&tac, NULL, NULL);
  if(ret!=TPCERROR_NO_DATA) return(2);

  CSV csv; csvInit(&csv);
  ret=tacRead4DM(&tac, &csv, NULL);
  if(ret!=TPCERROR_NO_DATA) return(3);

  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) printf("\nCreating CSV data for testing; no region name\n");
  ret=csvPutString(&csv, "PatientName", 0);
  if(ret==0) ret=csvPutString(&csv, "\"John Doe\"", 0);
  if(ret==0) ret=csvPutString(&csv, "Patient MRN", 1);
  if(ret==0) ret=csvPutString(&csv, "001234", 0);
  if(ret==0) ret=csvPutString(&csv, "Date of Acquisition", 1);
  if(ret==0) ret=csvPutString(&csv, "20230213", 0);
  if(ret==0) ret=csvPutString(&csv, "Radionuclide Name", 1);
  if(ret==0) ret=csvPutString(&csv, "O-15", 0);
  if(ret==0) ret=csvPutString(&csv, "Number of Frames", 1);
  if(ret==0) ret=csvPutString(&csv, "3", 0);
  if(ret==0) ret=csvPutString(&csv, "Frame Durations (s)", 1);
  if(ret==0) ret=csvPutString(&csv, "5", 0);
  if(ret==0) ret=csvPutString(&csv, "5", 0);
  if(ret==0) ret=csvPutString(&csv, "10", 0);
  if(ret==0) ret=csvPutString(&csv, "Frame Start Times (s)", 1);
  if(ret==0) ret=csvPutString(&csv, "0", 0);
  if(ret==0) ret=csvPutString(&csv, "5", 0);
  if(ret==0) ret=csvPutString(&csv, "10", 0);
  if(ret==0) ret=csvPutString(&csv, "TAC FA Blood LV (Bq/ml)", 1);
  if(ret==0) ret=csvPutString(&csv, "", 0);
  if(ret==0) ret=csvPutString(&csv, "TAC FA Blood RV", 1);
  if(ret==0) ret=csvPutString(&csv, "", 0);
  if(ret==0) ret=csvPutString(&csv, "TAC FA Tissue Global", 1);
  if(ret==0) ret=csvPutString(&csv, "", 0);
  if(ret==0) ret=csvPutString(&csv, "TAC ROI Blood LV", 1);
  if(ret==0) ret=csvPutString(&csv, "0", 0);
  if(ret==0) ret=csvPutString(&csv, "100000", 0);
  if(ret==0) ret=csvPutString(&csv, "50000", 0);
  if(ret==0) ret=csvPutString(&csv, "TAC ROI Blood RV", 1);
  if(ret==0) ret=csvPutString(&csv, "0", 0);
  if(ret==0) ret=csvPutString(&csv, "0", 0);
  if(ret==0) ret=csvPutString(&csv, "0", 0);
  if(ret==0) ret=csvPutString(&csv, "TAC ROI Tissue Global", 1);
  if(ret==0) ret=csvPutString(&csv, "0", 0);
  if(ret==0) ret=csvPutString(&csv, "10000", 0);
  if(ret==0) ret=csvPutString(&csv, "6000", 0);
  if(ret) {csvFree(&csv); tacFree(&tac); return(11);}

  if(verbose>5) csvWrite(&csv, 0, stdout, NULL);
  statusSet(status, __func__, __FILE__, __LINE__, 0);

  if(verbose>1) printf("\ntrying to read the CSV contents\n");
  ret=tacRead4DM(&tac, &csv, NULL);
  if(ret!=TPCERROR_OK) {csvFree(&csv); tacFree(&tac); return(12);}
  if(verbose>5) tacWrite(&tac, stdout, TAC_FORMAT_CSV_UK, 1, NULL);
  if(tac.tacNr!=2 || tac.sampleNr!=3) {csvFree(&csv); tacFree(&tac); return(13);}
  if(!doubleMatch(tac.c[0].y[1], 100000., 0.1)) {
    csvFree(&csv); tacFree(&tac); return(14);}
  if(!doubleMatch(tac.c[1].y[2], 6000., 0.1)) {
    csvFree(&csv); tacFree(&tac); return(15);}
  if(strcmp(tac.c[0].name, "Blood LV")!=0) {
    csvFree(&csv); tacFree(&tac); return(16);}
  if(strcmp(tac.c[1].name, "Tissue Global")!=0) {
    csvFree(&csv); tacFree(&tac); return(17);}

  csvFree(&csv); tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
