/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacWriteDFT(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  FILE *fp;
  TAC tac; tacInit(&tac);
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 1;
  
  if(verbose>1) printf("writing test data without extra header\n");
  char fname1[]="test1.dft";
  fp=fopen(fname1, "w");
  if(fp==NULL) {tacFree(&tac); return 2;}
  statusSet(status, __func__, __FILE__, __LINE__, verbose-2);
  ret=tacWriteDFT(&tac, fp, 0, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 3;}

  /*for(int fi=0; fi<tac.sampleNr; fi++)
    for(int ri=0; ri<tac.tacNr; ri++)
      printf("%d %d %g\n", fi, ri, tac.c[ri].y[fi]);*/

  if(verbose>1) printf("writing test data with extra header\n");
  char fname2[]="test2.dft";
  fp=fopen(fname2, "w");
  if(fp==NULL) {tacFree(&tac); return 12;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteDFT(&tac, fp, 1, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 13;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacNameSplit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int n;
  char rname[64], subname[3][7];

  /* Does not crash with NULL pointer */
  n=tacNameSplit(NULL, NULL, NULL, NULL, 6);
  if(n!=0) return 1;

  /* Returns the correct nr (0-3) of subnames */

  strcpy(rname, "");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=0) return 10;
  if(strcmp(subname[0], "")!=0) return 10;
  if(strcmp(subname[1], "")!=0) return 10;
  if(strcmp(subname[2], "")!=0) return 10;

  strcpy(rname, "put");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=1) return 11;
  if(strcmp(subname[0], "put")!=0) return 11;
  if(strcmp(subname[1], "")!=0) return 11;
  if(strcmp(subname[2], "")!=0) return 11;

  strcpy(rname, "put sin");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=2) return 12;
  if(strcmp(subname[0], "put")!=0) return 12;
  if(strcmp(subname[1], "sin")!=0) return 12;
  if(strcmp(subname[2], "")!=0) return 12;

  strcpy(rname, "put sin pl4");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=3) return 13;
  if(strcmp(subname[0], "put")!=0) return 13;
  if(strcmp(subname[1], "sin")!=0) return 13;
  if(strcmp(subname[2], "pl4")!=0) return 13;

  strcpy(rname, "putamen sin pl4");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=3) return 14;
  if(strcmp(subname[0], "putame")!=0) return 14;
  if(strcmp(subname[1], "sin")!=0) return 14;
  if(strcmp(subname[2], "pl4")!=0) return 14;

  strcpy(rname, "putamen . .");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=2) return 15;
  if(strcmp(subname[0], "putame")!=0) return 15;
  if(strcmp(subname[1], "n")!=0) return 15;
  if(strcmp(subname[2], "")!=0) return 15;

  strcpy(rname, "putamen_sin_pl78");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=3) return 16;
  if(strcmp(subname[0], "putame")!=0) return 16;
  if(strcmp(subname[1], "sin")!=0) return 16;
  if(strcmp(subname[2], "pl78")!=0) return 16;

  strcpy(rname, "putamen__");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=2) return 17;
  if(strcmp(subname[0], "putame")!=0) return 17;
  if(strcmp(subname[1], "n")!=0) return 17;
  if(strcmp(subname[2], "")!=0) return 17;

  strcpy(rname, "__mean");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=3) return 18;
  if(strcmp(subname[0], "")!=0) return 18;
  if(strcmp(subname[1], "")!=0) return 18;
  if(strcmp(subname[2], "mean")!=0) return 18;

  strcpy(rname, "_dx_mean");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=3) return 19;
  if(strcmp(subname[0], "")!=0) return 19;
  if(strcmp(subname[1], "dx")!=0) return 19;
  if(strcmp(subname[2], "mean")!=0) return 19;

  strcpy(rname, "put__mean");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=3) return 20;
  if(strcmp(subname[0], "put")!=0) return 20;
  if(strcmp(subname[1], "")!=0) return 20;
  if(strcmp(subname[2], "mean")!=0) return 20;

  strcpy(rname, "putamen__mean");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=3) return 21;
  if(strcmp(subname[0], "putame")!=0) return 21;
  if(strcmp(subname[1], "n")!=0) return 21;
  if(strcmp(subname[2], "mean")!=0) return 21;

  strcpy(rname, "put_toolong");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=3) return 22;
  if(strcmp(subname[0], "put")!=0) return 22;
  if(strcmp(subname[1], "toolon")!=0) return 22;
  if(strcmp(subname[2], "g")!=0) return 22;

  strcpy(rname, "putamen_sin");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, subname[0], subname[1], subname[2], 6);
  if(verbose>2) printf("  -> n := %d '%s' '%s' '%s'\n",
                       n, subname[0], subname[1], subname[2]);
  if(n!=2) return 23;
  if(strcmp(subname[0], "putame")!=0) return 23;
  if(strcmp(subname[1], "sin")!=0) return 23;
  if(strcmp(subname[2], "")!=0) return 23;

  /* Should work is places for subnames is not given */

  strcpy(rname, "putamen_sin");
  if(verbose>1) printf("rname := '%s'\n", rname);
  n=tacNameSplit(rname, NULL, NULL, NULL, 6);
  if(verbose>2) printf("  -> n := %d\n", n);
  if(n!=2) return 31;

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadDFT(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(verbose>0) printf("tests included in testing of tacRead()\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
