/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadHRRTHC(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  FILE *fp;
  char *fname="test1.hc";

  if(verbose>1) printf("\n writing %s for testing\n", fname);
  fp=fopen(fname, "w"); if(fp==NULL) return(1);
  fprintf(fp, "Singles,Randoms,Prompts,Time(ms)\n");
  fprintf(fp, "3380578,196330,196601,621\n");
  fprintf(fp, "5560241,299451,302486,1941\n");
  fclose(fp);

  if(verbose>1) printf("\n using tacRead() to read the file\n");
  TAC tac; tacInit(&tac);
  if(tacRead(&tac, fname, status)!=TPCERROR_OK) {tacFree(&tac); return(2);}

  if(verbose>1) printf("\n checking the contents of the data\n");
  if(tac.tacNr!=3) {tacFree(&tac); return(3);}
  if(tac.sampleNr!=2) {tacFree(&tac); return(4);}
  if(!doubleMatch(tac.x[1], 1941, 0.1)) {tacFree(&tac); return(5);}
  if(!doubleMatch(tac.c[2].y[0], 196601, 0.1)) {tacFree(&tac); return(6);}
  tacFree(&tac);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadHRPLUSHC(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  FILE *fp;
  char *fname="test1.r";

  if(verbose>1) printf("\n writing %s for testing\n", fname);
  fp=fopen(fname, "w"); if(fp==NULL) return(1);
  fprintf(fp, "time\tprompt\tdelayed\tp_rate\td_rate\tdtime\tframe\tsingles\n");
  fprintf(fp, "1466\t12398\t11189\t8828\t7985\t4\t1\t1647190\n");
  fprintf(fp, "3466\t35896\t33368\t11749\t11089\t5\t1\t2047144\n");
  fclose(fp);

  if(verbose>1) printf("\n using tacRead() to read the file\n");
  TAC tac; tacInit(&tac);
  if(tacRead(&tac, fname, status)!=TPCERROR_OK) {tacFree(&tac); return(2);}

  if(verbose>1) printf("\n checking the contents of the data\n");
  if(tac.tacNr!=7) {tacFree(&tac); return(3);}
  if(tac.sampleNr!=2) {tacFree(&tac); return(4);}
  if(!doubleMatch(tac.x[1], 3466, 0.1)) {tacFree(&tac); return(5);}
  if(!doubleMatch(tac.c[6].y[0], 1647190, 0.1)) {tacFree(&tac); return(6);}
  tacFree(&tac);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
