#!/bin/bash
#: Title      : test_llsqe3
#: Date       : 2021-12-10
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../llsqe3$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"
if [ ! -f fdg.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Actual FDG TACs. \n"
printf " Expected result: Reasonable fit obtained. \n\n"

rm -f output100.par output100lp.par output100.tac output100.svg

$PROGRAM -fit=output100.tac -lp=output100lp.par -svg=output100.svg fdg.tac output100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=40,60 fdg.tac test1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=40,60 output100.tac test2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacdel --silent test1.tac Liver
tacdel --silent test2.tac Liver
tacmatch -abs=1000 -rel=12 test1.tac test2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

