#!/bin/bash
#: Title      : test_addvers
#: Date       : 2018-02-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../addvers$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Valid version and file name given on command-line. \n"
printf " Expected result: File renamed correctly. \n"

touch testfile.dat
rm -f testfile_1_2_3.dat

$PROGRAM 1.2.3 testfile.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f testfile_1_2_3.dat ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f testfile.dat ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: File name already contains version. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt

$PROGRAM 1.2.3 testfile_1_2_3.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "file name already contains version number."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Valid version inside file and file name given on command-line. \n"
printf " Expected result: File renamed correctly. \n"

printf "version := 2.3.4\n" > version.txt
touch testfile.dat
rm -f testfile_1_2_3.dat testfile_2_3_4.dat

$PROGRAM version.txt testfile.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f testfile_2_3_4.dat ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f testfile.dat ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
