#!/bin/bash
#: Title      : test_parcoll
#: Date       : 2018-06-07
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../parcoll$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


printf "\n make test data \n"


if [ ! -f test1.csv ] || [ ! -f test1.res ] || [ ! -f test1.fit ] || [ ! -f test1.ift ]; then
  printf "parameters,p1,p2\n" > test1.csv
  printf "put_dx,1.0,2.0\n"  >> test1.csv
  printf "cau_dx,2.0,3.0\n"  >> test1.csv
  printf "put_sin,3.0,4.0\n" >> test1.csv
  printf "cau_sin,4.0,5.0\n" >> test1.csv
  parformat -f=RES test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=FIT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=IFT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f test2.csv ] || [ ! -f test2.res ] || [ ! -f test2.fit ] || [ ! -f test2.ift ]; then
  printf "parameters,p1,p2\n" > test2.csv
  printf "put_dx,1.1,2.1\n"  >> test2.csv
  printf "cau_dx,2.1,3.1\n"  >> test2.csv
  printf "put_sin,3.1,4.1\n" >> test2.csv
  printf "cau_sin,4.1,5.1\n" >> test2.csv
  parformat -f=RES test2.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=FIT test2.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=IFT test2.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f test3.csv ] || [ ! -f test3.res ] || [ ! -f test3.fit ] || [ ! -f test3.ift ]; then
  printf "parameters,p1,p2\n" > test3.csv
  printf "put_dx,1.2,2.2\n"  >> test3.csv
  printf "cau_dx,2.2,3.2\n"  >> test3.csv
  printf "put_sin,3.2,4.2\n" >> test3.csv
  printf "cau_sin,4.2,5.2\n" >> test3.csv
  parformat -f=RES test3.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=FIT test3.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=IFT test3.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f correct1.csv ]; then
  printf "parameters,p1,p2\n" > correct1.csv
  printf "test1 put_dx,1.0,2.0\n"  >> correct1.csv
  printf "test1 cau_dx,2.0,3.0\n"  >> correct1.csv
  printf "test1 put_sin,3.0,4.0\n" >> correct1.csv
  printf "test1 cau_sin,4.0,5.0\n" >> correct1.csv
  printf "test2 put_dx,1.1,2.1\n"  >> correct1.csv
  printf "test2 cau_dx,2.1,3.1\n"  >> correct1.csv
  printf "test2 put_sin,3.1,4.1\n" >> correct1.csv
  printf "test2 cau_sin,4.1,5.1\n" >> correct1.csv
  printf "test3 put_dx,1.2,2.2\n"  >> correct1.csv
  printf "test3 cau_dx,2.2,3.2\n"  >> correct1.csv
  printf "test3 put_sin,3.2,4.2\n" >> correct1.csv
  printf "test3 cau_sin,4.2,5.2\n" >> correct1.csv
fi
if [ ! -f correct2.csv ]; then
  printf "parameters,p2\n" > correct2.csv
  printf "test1,4.0\n" >> correct2.csv
  printf "test2,4.1\n" >> correct2.csv
  printf "test3,4.2\n" >> correct2.csv
fi
if [ ! -f correct3.csv ]; then
  printf "parameters,p2\n" > correct3.csv
  printf "test1 put_dx,2.0\n"  >> correct3.csv
  printf "test1 put_sin,4.0\n" >> correct3.csv
  printf "test2 put_dx,2.1\n"  >> correct3.csv
  printf "test2 put_sin,4.1\n" >> correct3.csv
  printf "test3 put_dx,2.2\n"  >> correct3.csv
  printf "test3 put_sin,4.2\n" >> correct3.csv
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Collect all results. \n"
printf " Test case 2: CSV format. \n"
printf " Expected result: parameters are saved in a new file. \n\n"

rm -f output.csv output.res output.fit output.ift

$PROGRAM  output.csv test?.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -tacnames=y -parnames=y -abs=0.0001 correct1.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Collect all results. \n"
printf " Test case 2: RES format. \n"
printf " Expected result: parameters are saved in a new file. \n\n"

$PROGRAM output.res test?.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -tacnames=n -parnames=y -abs=0.0001 correct1.csv output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case 1: Collect all results. \n"
printf " Test case 2: FIT format. \n"
printf " Expected result: parameters are saved in a new file. \n\n"

$PROGRAM output.fit test?.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -tacnames=n -parnames=y -abs=0.0001 correct1.csv output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case 1: Collect all results. \n"
printf " Test case 2: IFT format. \n"
printf " Expected result: parameters are saved in a new file. \n\n"

$PROGRAM output.ift test?.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -tacnames=y -parnames=y -abs=0.0001 correct1.csv output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Select one TAC and one parameter. \n"
printf " Expected result: correct parameters are saved in a new file. \n\n"

rm -f output.csv

$PROGRAM --silent -par=p2 -tac=put_sin output.csv test?.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch --silent -tacnames=n -parnames=y -abs=0.0001 correct2.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Select two TACs and one parameter. \n"
printf " Expected result: correct parameters are saved in a new file. \n\n"

rm -f output.csv

$PROGRAM --silent -par=p2 -tac=put output.csv test?.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch --silent -tacnames=n -parnames=y -abs=0.0001 correct3.csv output.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case: Specify file format with extension. \n"
printf " Expected result: correct parameters are saved in a new file. \n\n"

rm -f output.xml

$PROGRAM --silent -par=p2 -tac=put output.xml test?.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.xml ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

