TPCCLIB v2 documentation                                             {#mainpage}
========================

Folder v2 contains rewritten versions of the C libraries and CLI applications,
developed in [Turku PET Centre](http://www.turkupetcentre.fi/) from year 1991.

Each library function and application has at least a minimal test procedure
included in the [CMake/CTest](http://www.cmake.org) cross-platform build environment.

Currently the v2 library contains only part of the functionalities of the 
[v1 library](../v1/index.html), and therefore contains only few applications.

## Libraries in v2 ##

- libtpcabss tpcabss.h): Automatic blood sampling system data processing and IO.
- libtpcbfm (tpcbfm.h): Basis functions calculations.
- libtpcbootstrap (tpcbootstrap.h): Bootstrap functions (not functional yet).
- libtpccm (tpccm.h): Compartmental models.
- libtpccsv (tpccsv.h): CSV file processing and IO.
- libtpcdcm (tpcdcm.h): DICOM functions (not yet for production use).
- libtpcecat (tpcecat.h): ECAT functions (not functional yet).
- libtpcextensions (tpcextensions.h): Miscellaneous routines, including #unit, #tpcerror, #tactype, and #weights.
- libtpcfcmc (tpcfcmc.h): Fuzzy C means clustering algorithm.
- libtpcfileutil (tpcfileutil.h): File and directory functions that require C POSIX library components.
- libtpcfunc (tpcfunc.h): Mathematical functions.
- libtpcift (tpcift.h): Interfile-type (IFT) header data processing and IO.
- libtpcimage (tpcimage.h): Image data structure (IMG) functions (not functional yet).
- libtpcisotope (tpcisotope.h): Elements, isotopes and half-lives.
- libtpcli (tpcli.h): Linear interpolation and integration of TAC.
- libtpclinopt (tpclinopt.h): Linear optimization.
- libtpcmicropet (tpcmicropet.h): microPET image functions (not functional yet).
- libtpcmodels (tpcmodels.h): Model and function #mf codes and descriptions for other libraries.
- libtpcnifti (tpcnifti.h): NIfTI functions (not functional yet).
- libtpcnlopt (tpcnlopt.h): Nonlinear optimization.
- libtpcpar (tpcpar.h): Model fitting parameter file and data (PAR) processing and IO.
- libtpcrand (tpcrand.h): Simple random number generation.
- libtpcstatist (tpcstatist.h): Simple statistics.
- libtpctac (tpctac.h): Regional and input TAC processing and IO.
- libtpctacmod (tpctacmod.h): Regional and input TAC processing for modelling and fitting.


[Back to TPCCLIB](../index.html).

