#!/bin/bash
#: Title      : test_hist2svg
#: Date       : 2023-03-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../hist2svg$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n Making data for testing \n"


if [ ! -f test.tac ] || [ ! -f test2.tac ] || [ ! -f test.dat ]; then
  printf "start\tend\tH1\n" > test.tac
  printf "0\t10\t20\n"     >> test.tac
  printf "10\t20\t80\n"    >> test.tac
  printf "20\t30\t40\n"    >> test.tac

  printf "start\tend\tH1\tH2\n" > test2.tac
  printf "0\t10\t20\t100\n"    >> test2.tac
  printf "10\t20\t80\t0\n"     >> test2.tac
  printf "20\t30\t40\t50\n"    >> test2.tac

  printf "1\t0\n" > test.dat
  printf "2\t0\n" >> test.dat
  printf "3\t0\n" >> test.dat
  printf "4\t0\n" >> test.dat
  printf "5\t0\n" >> test.dat
  printf "6\t5\n" >> test.dat
  printf "7\t8\n" >> test.dat
  printf "8\t0\n" >> test.dat
  printf "9\t0\n" >> test.dat
  printf "10\t0\n" >> test.dat
  printf "11\t0\n" >> test.dat
  printf "12\t0\n" >> test.dat
  printf "13\t0\n" >> test.dat
  printf "14\t0\n" >> test.dat
  printf "15\t0\n" >> test.dat
  printf "16\t0\n" >> test.dat
  printf "17\t0\n" >> test.dat
  printf "18\t0\n" >> test.dat
  printf "19\t0\n" >> test.dat
  printf "20\t0\n" >> test.dat
  printf "21\t4\n" >> test.dat
  printf "22\t10\n" >> test.dat
  printf "23\t2\n" >> test.dat
  printf "24\t0\n" >> test.dat
  printf "25\t5\n" >> test.dat
  printf "26\t0\n" >> test.dat
  printf "27\t0\n" >> test.dat
  printf "28\t0\n" >> test.dat
  printf "29\t0\n" >> test.dat
  printf "30\t0\n" >> test.dat
  printf "31\t0\n" >> test.dat
  printf "32\t0\n" >> test.dat
  printf "33\t0\n" >> test.dat
  printf "34\t0\n" >> test.dat
  printf "35\t0\n" >> test.dat
  printf "36\t0\n" >> test.dat
  printf "37\t0\n" >> test.dat
  printf "38\t0\n" >> test.dat
  printf "39\t0\n" >> test.dat
  printf "40\t0\n" >> test.dat
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Simple data, no options. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h100.svg
$PROGRAM test.dat h100.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h100.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Optional title, increased ymax, reduced xmax. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h101.svg
$PROGRAM -mt="Test 1.0.1" -y2=12 -x2=30 test.dat h101.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h101.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Set x and y axis to start from negative. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h102.svg
$PROGRAM -mt="Test 1.0.2" -x1=-5 -y1=-10 test.dat h102.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h102.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case: Set x axis to start from positive. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h103.svg
$PROGRAM -mt="Test 1.0.3" -x1=10 test.dat h103.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h103.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.4 \n"
printf " Test case: Set y axis to start from positive. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h104.svg
$PROGRAM -mt="Test 1.0.4" -y1=3 test.dat h104.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h104.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.5 \n"
printf " Test case: Set y axis max to hide part of data. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h105.svg
$PROGRAM -mt="Test 1.0.5" -y2=6 test.dat h105.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h105.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Data is negative. \n"
printf " Expected result: Plot file created. \n\n"

taccalc test.dat x -1 temp.dat
printf "\n ok \n"

rm -f h110.svg
$PROGRAM -c=1 temp.dat h110.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h110.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Every data point is larger than zero. \n"
printf " Expected result: Plot file created. \n\n"

taccalc test.dat + 100 temp.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

rm -f h120.svg
$PROGRAM -mt="Test 1.2.0" temp.dat h120.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h120.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: Same but when data is negative. \n"
printf " Expected result: Plot file created. \n\n"

taccalc temp.dat x -1 temp2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

rm -f h121.svg
$PROGRAM -mt="Test 1.2.1" temp2.dat h121.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h121.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: Data contains negative and positive values. \n"
printf " Expected result: Plot file created. \n\n"

taccalc test.dat - 3 temp.dat
printf "\n ok \n"

rm -f h130.svg
$PROGRAM -c=1 temp.dat h130.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h130.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case: PMOD formatted data with x1 and x2, no options. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h200.svg
$PROGRAM test.tac h200.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h200.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Set y axis max to hide part of data. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h201.svg
$PROGRAM -mt="Test 2.0.1" -y2=60 test.tac h201.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h201.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Set x axis to hide part rectagles from both sides. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h202.svg
$PROGRAM -mt="Test 2.0.2" -x1=8 -x2=25 test.tac h202.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h202.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: File contains two datasets; the second one is selected. \n"
printf " Expected result: Plot file created. \n\n"

rm -f h210.svg
$PROGRAM -c=2 test2.tac h210.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h210.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.0 \n"
printf " Test case: Data is negative. \n"
printf " Expected result: Plot file created. \n\n"

taccalc test2.tac x -1 temp.tac
printf "\n ok \n"

rm -f h220.svg
$PROGRAM -c=2 temp.tac h220.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h220.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.2.1 \n"
printf " Test case: Both negative and positive data. \n"
printf " Expected result: Plot file created. \n\n"

taccalc test2.tac - 30 temp.tac
printf "\n ok \n"

rm -f h221.svg
$PROGRAM -c=1 temp.tac h221.svg
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f h221.svg ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
